 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kcmplx2real
   >>>> 
   >>>>    Written By: Donna Koechner
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kcmplx2real_h_
#define _kcmplx2real_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kcmplx2real/uis/kcmplx2real.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input data object (required infile)
 */
char	*i_file;	/* Input data object FILENAME */
int	 i_flag;	/* Input data object FLAG */

/*----- required   group ----*/
/*
 *  Output data object containing REAL component of input  (optional outfile)
 */
char	*or_file;	/* Output data object containing REAL component of input  FILENAME */
int	 or_flag;	/* Output data object containing REAL component of input  FLAG */

/*
 *  Output data object containing imaginary component of input (optional outfile)
 */
char	*oi_file;	/* Output data object containing imaginary component of input FILENAME */
int	 oi_flag;	/* Output data object containing imaginary component of input FLAG */

/*
 *  Output data object containing phase of input (optional outfile)
 */
char	*op_file;	/* Output data object containing phase of input FILENAME */
int	 op_flag;	/* Output data object containing phase of input FLAG */

/*
 *  Output data object containing magnitude of input (optional outfile)
 */
char	*om_file;	/* Output data object containing magnitude of input FILENAME */
int	 om_flag;	/* Output data object containing magnitude of input FLAG */

	/*---- nested optional ME group ----*/
/*
 *  Magnitude = sqrt(real*real + imag*imag) (optional flag)
 */
int	 mag_flag;  	/* Magnitude = sqrt(real*real + imag*imag) FLAG */

/*
 *  Magnitude Squared = real*real + imag*imag (optional flag)
 */
int	 magsq_flag;  	/* Magnitude Squared = real*real + imag*imag FLAG */

/*
 *  Log(Magnitude+1) = log(sqrt(real*real + imag*imag)+1) (optional flag)
 */
int	 logmag1_flag;  	/* Log(Magnitude+1) = log(sqrt(real*real + imag*imag)+1) FLAG */

/*
 *  Log(Magnitude Squared+1) = log(real*real+imag*imag+1) (optional flag)
 */
int	 logmagsq1_flag;  	/* Log(Magnitude Squared+1) = log(real*real+imag*imag+1) FLAG */

/*
 *  Log(Magnitude) = log(sqrt(real*real + imag*imag)) (optional flag)
 */
int	 logmag_flag;  	/* Log(Magnitude) = log(sqrt(real*real + imag*imag)) FLAG */

/*
 *  Log(Magnitude Squared) = log(real*real + imag*imag) (optional flag)
 */
int	 logmagsq_flag;  	/* Log(Magnitude Squared) = log(real*real + imag*imag) FLAG */

	/*-- nested optional ME group end --*/

/*-- required   group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kcmplx2real_get_args PROTO((kform *));
void kcmplx2real_usage_additions PROTO((void));
void kcmplx2real_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
