 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kclip
   >>>> 
   >>>>    Written By: Donna Koechner, Ashish Malhotra
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kclip_h_
#define _kclip_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kclip/uis/kclip.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input file (required infile)
 */
char	*i_file;	/* Input file FILENAME */
int	 i_flag;	/* Input file FLAG */

/*
 *  output file (required outfile)
 */
char	*o_file;	/* output file FILENAME */
int	 o_flag;	/* output file FLAG */

/*----- required   group ----*/
	/*---- nested optional ME group ----*/
/*
 *  Constant lower cutoff value (optional double)
 */
double	 lc_double;	/* Constant lower cutoff value DOUBLE */
int	 lc_flag;   	/* Constant lower cutoff value FLAG */

/*
 *  File containing lower cutoff values (optional infile)
 */
char	*ilc_file;	/* File containing lower cutoff values FILENAME */
int	 ilc_flag;	/* File containing lower cutoff values FLAG */

	/*-- nested optional ME group end --*/

	/*---- nested optional ME group ----*/
/*
 *  Constant upper cutoff value (optional double)
 */
double	 uc_double;	/* Constant upper cutoff value DOUBLE */
int	 uc_flag;   	/* Constant upper cutoff value FLAG */

/*
 *  File containing upper cutoff values (optional infile)
 */
char	*iuc_file;	/* File containing upper cutoff values FILENAME */
int	 iuc_flag;	/* File containing upper cutoff values FLAG */

	/*-- nested optional ME group end --*/

/*-- required   group end ---*/

/*
 *  Clip (0) or Threshold (1) Object Data (optional logical)
 */
int	 thresh_logic;	/* Clip (0) or Threshold (1) Object Data LOGIC */
int	 thresh_flag;  	/* Clip (0) or Threshold (1) Object Data FLAG */

/*
 *  Value assigned to output if evaluation is FALSE (optional double)
 */
double	 fval_double;	/* Value assigned to output if evaluation is FALSE DOUBLE */
int	 fval_flag;   	/* Value assigned to output if evaluation is FALSE FLAG */

/*
 *  Value assigned to output if evaluation is TRUE (thresholding only) (optional double)
 */
double	 tval_double;	/* Value assigned to output if evaluation is TRUE (thresholding only) DOUBLE */
int	 tval_flag;   	/* Value assigned to output if evaluation is TRUE (thresholding only) FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kclip_get_args PROTO((kform *));
void kclip_usage_additions PROTO((void));
void kclip_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
