 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kbitwise
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kbitwise.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Dual Operand Bitwise Operations
|
|       Purpose: main program for kbitwise
|
|         Input:
|		char *clui_info->i1_file; {first input data object}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->o_file; {resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->and_flag; {TRUE if -and specified}
|
|		    int clui_info->ls_flag; {TRUE if -ls specified}
|
|		    int clui_info->or_flag; {TRUE if -or specified}
|
|		    int clui_info->rs_flag; {TRUE if -rs specified}
|
|		    int clui_info->xor_flag; {TRUE if -xor specified}
|
|		    int clui_info->srs_flag; {TRUE if -srs specified}
|
|		    int clui_info->nand_flag; {TRUE if -nand specified}
|
|		    int clui_info->rr_flag; {TRUE if -rr specified}
|
|		    int clui_info->nor_flag; {TRUE if -nor specified}
|
|		    int clui_info->lr_flag; {TRUE if -lr specified}
|
|		    int clui_info->andrev_flag; {TRUE if -andrev specified}
|
|		    int clui_info->andinv_flag; {TRUE if -andinv specified}
|
|		    int clui_info->orrev_flag; {TRUE if -orrev specified}
|
|		    int clui_info->orinv_flag; {TRUE if -orinv specified}
|
|		Optional M.E. group:
|		    char *clui_info->i2_file; {second input data object}
|		    int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		    int clui_info->real_int; {constant value}
|		    int clui_info->real_flag; {TRUE if -real specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner & Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj1;
        kobject in_obj2;
        kobject out_obj;
        int    type;
        char    *function=NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kbitwise_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kbitwise",
		kbitwise_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kbitwise_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj1 = kpds_open_input_object(clui_info->i1_file))
		== KOBJECT_INVALID)
        {
           kerror("kbitwise","main",
                  "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if(!kpds_get_attribute(in_obj1,KPDS_VALUE_DATA_TYPE, &type)) {

           kerror("kbitwise", "main",
              "Cannot access input object 1.");
           kexit(KEXIT_FAILURE);

        }

        if((type == KFLOAT) || (type == KDOUBLE) || (type == KCOMPLEX) ||

           (type == KDCOMPLEX) ) {
           kerror("kbitwise", "main",
              "Cannot operate on float, double or complex data types.");
           kexit(KEXIT_FAILURE);

        }
           
        if (clui_info->i2_flag)
	{
           if ((in_obj2 = kpds_open_input_object(clui_info->i2_file))
		== KOBJECT_INVALID)
           {
              kerror("kbitwise","main",
                     "Cannot open input object.");
              kexit(KEXIT_FAILURE);
           }
	}
        else
           in_obj2 = NULL;

        if (clui_info->i2_flag) {
           if(!kpds_get_attribute(in_obj2,KPDS_VALUE_DATA_TYPE, &type)) {
              kerror("kbitwise", "main",
                 "Cannot access input object 1.");
              kexit(KEXIT_FAILURE);
           }
           if((type == KFLOAT) || (type == KDOUBLE) || (type == KCOMPLEX) ||
              (type == KDCOMPLEX) ) {
              kerror("kbitwise", "main",
                 "Cannot operate on float, double or complex data types.");
              kexit(KEXIT_FAILURE);
           }
        }

        if ((out_obj = kpds_open_output_object(clui_info->o_file))
		== KOBJECT_INVALID)
        {
           kerror("kbitwise","main",
                  "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

        if (!kpds_copy_object_attr(in_obj1, out_obj))
        {
           kerror("kbitwise","main",
                  "Cannot copy input object attributes to output object.");
           kexit(KEXIT_FAILURE);
        }

        if (clui_info->and_flag)
           function = "and";
        else if (clui_info->or_flag)
           function = "or";
        else if (clui_info->xor_flag)
           function = "xor";
        else if (clui_info->nand_flag)
           function = "nand";
        else if (clui_info->nor_flag)
           function = "nor";
        else if (clui_info->andrev_flag)
           function = "andrev";
        else if (clui_info->andinv_flag)
           function = "andinv";
        else if (clui_info->orrev_flag)
           function = "orrev";
        else if (clui_info->orinv_flag)
           function = "orinv";
        else if (clui_info->rs_flag)
           function = "rs";
        else if (clui_info->srs_flag)
           function = "srs";
        else if (clui_info->rr_flag)
           function = "rr";
        else if (clui_info->ls_flag)
           function = "ls";
        else if (clui_info->lr_flag)
           function = "lr";
	else 
	{
           kerror("kbitwise", "main", "function not specified.");
           kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkbitwise(in_obj1, in_obj2, (long) clui_info->real_int, 
		       function,out_obj))
	{
	   kexit(KEXIT_FAILURE);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kbitwise", "main", 
		  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
	}

        if (!kpds_copy_remaining_data(in_obj1, out_obj))
        {
           kerror("kbitwise","main",
                  "Cannot copy remaining data from input object to output.");
           kexit(KEXIT_FAILURE);
        }

	kpds_close_object(out_obj);
	kpds_close_object(in_obj1);
	if (clui_info->i2_flag)  kpds_close_object(in_obj2);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kbitwise_usage_additions
| 
|       Purpose: Prints usage additions in kbitwise_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kbitwise
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kbitwise_usage_additions(void)
{
	kfprintf(kstderr, "\tDual Operand Bitwise Operations\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kbitwise_free_args
| 
|       Purpose: Frees CLUI struct allocated in kbitwise_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kbitwise
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kbitwise_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->o_file);
	kfree(clui_info->i2_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
