 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kasc2time
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kasc2time.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Import ASCII Data File to Time Segment
|
|       Purpose: main program for kasc2time
|
|         Input:
|		char *clui_info->i1_file; {ASCII input data file containing new data segment}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->o_file; {output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->i2_file; {data object input to insert the new segment into}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		int clui_info->so_int; {starting point in ASCII file to start importing at}
|		int clui_info->so_flag; {TRUE if -so specified}
|
|		int clui_info->tsize_int; {time}
|		int clui_info->tsize_flag; {TRUE if -tsize specified}
|
|		int   clui_info->type_list; {data type}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|        Output:
|       Returns:
|
|    Written By: John Salas, Steve Kubica
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        int     size_vector[1];
        char    *index_order;
        kobject source_viff = KOBJECT_INVALID, destination_object;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kasc2time_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kasc2time",
		kasc2time_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kasc2time_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        /*
         * Instantiate objects.
         */
        if ( clui_info->i2_flag &&
             (source_viff = kdms_open(clui_info->i2_file,
                                         KOBJ_READ)) == NULL) {
           kerror("kasc2time", "main", "Failed to open VIFF input object");
           kexit(KEXIT_FAILURE);
        }

        if ((destination_object = kdms_open(clui_info->o_file,
                                             KOBJ_WRITE)) == NULL) {
           kerror("kasc2time", "main", "Failed to open output object");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
	size_vector[0] = clui_info->tsize_int;
	index_order = "time ";
        if ( !lkimportasc(clui_info->i1_file, source_viff,
                             KDMS_SEGMENT_TIME, 1, index_order, size_vector,
                             clui_info->type_label,
                             clui_info->so_int, 0, destination_object) ) {
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output object */
        if (!kpds_set_attribute(destination_object, 
                                KPDS_HISTORY, kpds_history_string()))
        {
           kerror("kasc2time", "main", 
                  "Unable to set history on the destination object");
           kexit(KEXIT_FAILURE);
        }
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kasc2time_usage_additions
| 
|       Purpose: Prints usage additions in kasc2time_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kasc2time
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kasc2time_usage_additions(void)
{
	kfprintf(kstderr, "\tImport ASCII Data File to Time Segment\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kasc2time_free_args
| 
|       Purpose: Frees CLUI struct allocated in kasc2time_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kasc2time
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kasc2time_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->o_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->type_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
