 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for karith2
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "karith2.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Dual Operator Pointwise Arithmetic
|
|       Purpose: main program for karith2
|
|         Input:
|		char *clui_info->i1_file; {first input data object}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->o_file; {resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    char *clui_info->i2_file; {second input data object}
|		    int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		    Loose group:
|			double clui_info->real_double; {Real constant value     }
|			int    clui_info->real_flag; {TRUE if -real specified}
|
|			double clui_info->imag_double; {Imaginary constant value}
|			int    clui_info->imag_flag; {TRUE if -imag specified}
|
|		Required M.E. group:
|		    int clui_info->add_flag; {TRUE if -add specified}
|
|		    int clui_info->hypot_flag; {TRUE if -hypot specified}
|
|		    int clui_info->sub_flag; {TRUE if -sub specified}
|
|		    int clui_info->atan2_flag; {TRUE if -atan2 specified}
|
|		    int clui_info->subfrom_flag; {TRUE if -subfrom specified}
|
|		    int clui_info->mul_flag; {TRUE if -mul specified}
|
|		    int clui_info->div_flag; {TRUE if -div specified}
|
|		    int clui_info->ldexp_flag; {TRUE if -ldexp specified}
|
|		    int clui_info->divinto_flag; {TRUE if -divinto specified}
|
|		    int clui_info->pow_flag; {TRUE if -pow specified}
|
|		    int clui_info->absdiff_flag; {TRUE if -absdiff specified}
|
|		    int clui_info->min_flag; {TRUE if -min specified}
|
|		    int clui_info->max_flag; {TRUE if -max specified}
|
|		    int clui_info->mod_flag; {TRUE if -mod specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner & Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj1 = NULL;
        kobject in_obj2 = NULL;
        kobject out_obj = NULL;
        double  real, imag;
        char    *function = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(karith2_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "karith2",
		karith2_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	karith2_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj1 = kpds_open_input_object(clui_info->i1_file)) 
		== KOBJECT_INVALID)
           kexit(KEXIT_FAILURE);

        if (clui_info->i2_flag)
	{
           if ((in_obj2 = kpds_open_input_object(clui_info->i2_file)) 
		== KOBJECT_INVALID)
              kexit(KEXIT_FAILURE);
	}
 
        if ((out_obj = kpds_open_output_object(clui_info->o_file)) 
		== KOBJECT_INVALID)
	   kexit(KEXIT_FAILURE);

	
        if (clui_info->add_flag)
           function = "add";
        else if (clui_info->sub_flag)
           function = "sub";
        else if (clui_info->mul_flag)
           function = "mult";
        else if (clui_info->div_flag)
           function = "div";
        else if (clui_info->pow_flag)
           function = "pow";
        else if (clui_info->absdiff_flag)
           function = "absdiff";
        else if (clui_info->min_flag)
           function = "minimum";
        else if (clui_info->max_flag)
           function = "maximum";
        else if (clui_info->ldexp_flag)
           function = "ldexp";
        else if (clui_info->mod_flag) 
           function = "mod";
        else if (clui_info->hypot_flag)
           function = "hypot";
        else if (clui_info->atan2_flag)
           function = "atan2";
        else if (clui_info->ldexp_flag)
           function = "ldexp";
        else if (clui_info->divinto_flag)
           function = "divinto";
        else if (clui_info->subfrom_flag)
           function = "subfrom";

        /*
         * The lkarith2 library should have no side effects on its output
         * object.  It will only manipulate the specified segment and the
         * attributes related to karith2.
         *
         * Since the input object may contain additional data segments and
         * attributes, they need to be copied to the output object so that
         * the user is not surprised by unwanted side effects, such as
         * removal of the map segment.  This is accomplished by copying
	 * the input object attributes to the output object using
	 * kpds_copy_object_attr, and after the library function returns, 
	 * copy the remaining data using the kpds_copy_remaining_data call. 
	 * The copy remaining call copys all data that was not modified
	 * by the library.
         *
         * If the copy functions fail, report the error, close the input
         * and output objects, and exit.
         */

        if (!kpds_copy_object_attr(in_obj1, out_obj))
        {
            kerror("karith2", "main",
		   "kpds_copy_object_attr failed in karith2 driver.");
            kexit(KEXIT_FAILURE);
        }

	real = clui_info->real_double;
	imag = clui_info->imag_double;
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkarith2(in_obj1, in_obj2, real, imag, function, TRUE, out_obj))
	   kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("karith2", "main", 
		  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
	}

        if (!kpds_copy_remaining_data(in_obj1, out_obj))
        {
            kerror("karith2", "main",
		   "unable to copy remaining data from input1 to output.");
            kexit(KEXIT_FAILURE);
        }
	kpds_close_object(out_obj);
	kpds_close_object(in_obj1);
	if (clui_info->i2_flag)  kpds_close_object(in_obj2);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: karith2_usage_additions
| 
|       Purpose: Prints usage additions in karith2_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname karith2
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void karith2_usage_additions(void)
{
	kfprintf(kstderr, "\tDual Operator Pointwise Arithmetic\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: karith2_free_args
| 
|       Purpose: Frees CLUI struct allocated in karith2_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname karith2
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
karith2_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->o_file);
	kfree(clui_info->i2_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
