#include "bootstrap.h"
#include <kcms/kcms.h>
#include <kcms/private.h>
 
 
void kdb_get_key(kdbm *database, char *keyname)
{
 
        kdatum key, data;
	char   temp[KLENGTH];
 
        key.dptr = keyname; 
        key.dsize = kstrlen(key.dptr) + 1;
        data = kdbm_fetch(database, key);
        kfprintf(kstdout,"%s:%s\n",key.dptr, !data.dptr ? "(NULL)" : data.dptr);
}

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	kdbm *db;
	kdatum key, data;
	char *path = "$BOOTSTRAP/repos/db/manpage";


	if (argc > 1)
	   path = argv[1];

	if (!(db = kdbm_open(path, O_RDONLY, 0666)))
	{
	   kinfo(KSTANDARD, "example:  Failed to open database '%s'", path);
	   kexit(KEXIT_FAILURE);
	}
	kdb_get_key(db, KCMS_KEY_AUTHOR_EMAIL);
	kdb_get_key(db, "SOFTWARE_OBJECTS");
	kdb_get_key(db, KCMS_KEY_AUTHOR);
	kdb_get_key(db, KCMS_KEY_TITLE);
	kdb_get_key(db, KCMS_KEY_VERSION);
	kdb_get_key(db, KCMS_KEY_SHORT_COPYRIGHT);
	kdb_get_key(db, KCMS_KEY_LONG_COPYRIGHT);
	kdb_get_key(db, "SOFTWARE_OBJECTS");
	kdb_get_key(db, KCMS_KEY_INFO_FILE);
	kdb_get_key(db, KCMS_KEY_CONFIG_FILE);
	kdb_get_key(db, KCMS_KEY_ALIAS_FILE);
	kdb_get_key(db, KCMS_KEY_TODO);
	kdb_get_key(db, KCMS_KEY_CHANGELOG_FILE);
	kdb_get_key(db, KCMS_KEY_INCLUDE_FILE);
 
	kdbm_close(db);
	kexit(KEXIT_SUCCESS);
}
