#include <bootstrap.h>


extern char *optarg;

void usage(int ex_val)
{
	 kfprintf(kstderr, "usage: ktest infile [src_pat] [rep_pat]\n");
	 kexit(ex_val);
}
void main(int argc, char **argv)
{
   kfile *out = kstderr;
   char *istr = NULL;
   char *src_pat = NULL;
   char *rep_pat = NULL;
   char *cmp;
   char *begin;
   char *end;
   char *tmp;
   char result[KLENGTH];
   int  compiler_test = FALSE;
   int  case_insensitive = FALSE;
   int  call_again = FALSE;
   int  print_before = FALSE;
   int  print_matched = FALSE;
   int  print_after = FALSE;
   int  c;

   while ((c = getopt(argc, argv, "sncp:r:i:o:bma")) != -1)
   {
      switch(c)
      {
	 case 'c':		/* Just compile the pattern into a DFA */
	    compiler_test = TRUE;
	 break;
	 case 'p':		/* Following string is a search pattern */
	    src_pat = optarg;
	 break;
	 case 'r':		/* Following string is a replace pattern */
	    rep_pat = optarg;
	 break;
	 case 'i':		/* Following string is the filename of an */
	    istr = kreadfile(optarg, NULL);	/* input parse string */
	 break;
	 case 'o':		/* Following string is the filename of the */
	    out = kfoutput(optarg);		/* output file */
	    if (out == NULL)
	    {
	       kfprintf(kstderr, "Cannot open '%s' for writing\n", optarg);
	       usage(1);
	    }
	 break;
	 case 's':
	    case_insensitive = TRUE;
	 break;
	 case 'n':
	    call_again = TRUE;
	 break;
	 case 'b':
	    print_before = TRUE;
	 break;
	 case 'm':
	    print_matched = TRUE;
	 break;
	 case 'a':
	    print_after = TRUE;
	 break;
      }
   }
   print_matched = ((print_before || print_matched || print_matched) ?
		    print_matched : TRUE);
   if (case_insensitive)
      cmp = kre_icomp(src_pat);
   else
      cmp = kre_comp(src_pat);

   if (call_again)
      cmp = kre_comp(NULL);
   if (cmp != NULL)
   {
      kfprintf(out, "Could not compile pattern\n");
      kfprintf(out, "Error returned is '%s'\n", cmp);
      kexit(0);
   }
   if (compiler_test == TRUE)
   {
      kre_debug(src_pat, out);
      kexit(0);
   }
   kfprintf(out, "Finding all occurances of: '%s'\n", src_pat);
   if (rep_pat != NULL)
      kfprintf(out, "Replacing with the pattern: '%s'\n", rep_pat);
   c = 0;
   while (kre_exec(istr) == TRUE)
   {
      c++;
      kre_pos(0,(kaddr) &begin, (kaddr) &end);
      kfprintf(out, "Found Pattern '%s' in input string\n", src_pat);
      if (rep_pat != NULL)
      {
         kre_subs(rep_pat, result);
         kfprintf(out, "\nThe replacement pattern is\n'%s'\n", result);
      }
      tmp = kstring_ncopy(istr, (int) (begin - istr), NULL);
      if (print_before)
         kfprintf(out, "The Input before the matched string is\n'%s'\n", tmp);
      kfree(tmp);
      tmp = kstring_ncopy(begin, (int) (end - begin), NULL);
      if (print_matched)
         kfprintf(out, "\nThe Pattern matched is\n'%s'\n", tmp);
      kfree(tmp);
      if (print_after)
         kfprintf(out, "\nThe Input after the matched string is\n'%s'\n", end);
      istr = end;
   }
   if (!c)
   {
      kfprintf(out, "Cannot to find '%s' in string\n'%s'\n", src_pat, istr);
   }
   else if (c > 1)
   {
      kfprintf(out, "Found pattern '%s', %d times in the input string\n",
	       src_pat, c);
   }
   kexit(0);
}
