#!/bin/sh

#
#  Khoros: $Id$
#

#
# $Log$
#

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.



#************************************************************
#  Routine Name: kconfigure
#       Purpose: 
#         Input: 
#    Written By: Neil Bowers & Tom Sauer
#          Date: July 22, 1993
# Modifications:
#************************************************************/

KPAGER=${PAGER:-more}
TMPDIR=${TMPDIR:-/tmp}
  cp="cp"
  mv="mv -f"
  rm="rm -f"
 awk="awk"
 sed="sed"
 cat="cat"
grep="grep"

# clean up behind us, for example if this script gets interrupted
# ------------------------------------------------------------------------
cleanup() {
	echo ""
	echo "kconfigure script interrupted"
	$rm $HOME/.Toolboxes.$$ $HOME/.line.$$ $HOME/.khoros_env.$$
	echo bye
	echo ""
	exit 0
}
# if user biffs ctrl-C, call our cleanup() function
trap cleanup 2

# build a $echoN variable and $echoEnd combination that will give
# will allow the echon procedure to work well.
FindEchoN()
{
        # build a list of potential echos, starting with sh built-in
        echoEnd=""
        elist="echo"
        for dir in `echo $PATH | $sed -e 's/:/ /g'`; do
                [ -x "$dir/echo" ] && elist="$elist $dir/echo"
        done
 
        # work through list, see if one of them groks -n
        for echo in $elist; do
                result=`$echo -n hello`
                if [ "$result" != "-n hello" ]; then
                        echoN="$echo -n"
                        break
                fi
        done
        if [ "$echoN" = "" ]; then
                echoN=echo
                echoEnd="\c"
                result=`$echoN "testing"$echoEnd`
                if [ "$result" != "testing" ]; then
                        unset echoEnd
                fi
        fi
}

# this is called every time we change `topic'
newtopic() {
	clear
}

# echo without without return
echon()
{
        $echoN "$* $echoEnd"
}

# prompt the user, do they want to continue
# be polite if they don't
# ------------------------------------------------------------------------
ConfirmContinue() {
	echon "Do you wish to continue? (y/n) [y]: "
	read resp
	if [ "$resp" = "n" -o "$resp" = "N" ]; then
		echo ""
		echo "Ok, bye..."
		echo ""
		exit 0
	fi
}

FindEchoN
newtopic

$cat <<EofIntro
 
				   Khoros 2.0 
			     User Configuration Script

	This script is used to configure a user's account for the Khoros 2.0
	software system. This involves the following steps:
		1. Setting up your KHOROS_TOOLBOX environment variable
		2. Creating a personal Khoros Toolbox file in \$HOME/.Toolboxes
		3. Creating a Khoros environment file in \$HOME/.khoros_env
		4. Changing your \$HOME/.cshrc to source the newly created
		   Khoros Environment file

	(If you experience any problems with this script, please report
	them to khoros-bugs@khoros.unm.edu)

EofIntro

ConfirmContinue

newtopic

if [ "$#" = 1 ]; then
	TOPDIR=$1
else
	TOPDIR="no default"
fi

ans="n"
echo ""
echo "			Location of Khoros 2.0 Software"
echo ""
while [ "$ans" = "n" ]; do
        echo ""
        echo "Please enter the full path to the toplevel of Khoros 2.0"
        echon "[$TOPDIR]: "
        read temp
        if [ "$temp" = "" ]; then
                temp=$TOPDIR
        fi

        if [ -d "$temp/bootstrap" ]; then
                TOPDIR=$temp
                ans="y"
        elif [ "$temp" = "no default" ]; then
		echo ""
                echo there is no default, try again\!
		echo ""
        elif [ ! -d "$temp" ]; then
		echo ""
                echo not a valid directory $temp\!
		echo ""
        else
		echo ""
                echo bootstrap directory does not exist in $temp\!
                echo $temp can not be the toplevel of Khoros 2.0\!
		echo ""
        fi
done


newtopic
$cat << EofTbFile




				Toolbox File

	Ok, next you need to have a toolbox file.  This contains
	a list of the toolboxes you want to use.  You let Khoros
	know where this file lives using the KHOROS_TOOLBOX environment
	variable.

	Typically, your personal toolbox file will be called .Toolboxes, and
	will live in your home directory.  You will refer to the 2.0
	distribution toolboxes by appending

			$TOPDIR/Toolboxes

	to the KHOROS_TOOLBOX environment variable.  If \$HOME/.Toolboxes file
	does not exist an empty one will be created for you.  There should be
	no duplicate entries in the toolbox files.

EofTbFile

if [ ! -f $HOME/.Toolboxes ]; then
	echo "Creating an empty .Toolboxes file in your home directory."
	echo ""
	echo "# Personal Khoros 2.0 Toolboxes Will be Listed Below" > $HOME/.Toolboxes
else
#
#  Remove duplicate entries
#
	echo "Checking your \$HOME/.Toolboxes for entries contained in the"
	echo "Khoros 2.0 toolboxes file.  Those entries will be deleted ..."
	if [ -f $TOPDIR/Toolboxes ]; then
		for TB in `$cat $TOPDIR/Toolboxes | $awk -F: '{ print $1 }'`; do
	        	$grep -v $TB $HOME/.Toolboxes > $HOME/.Toolboxes.$$
	        	$mv $HOME/.Toolboxes.$$ $HOME/.Toolboxes
		done
	fi
	echo "# Personal Khoros 2.0 Toolboxes Will be Listed Below" > $HOME/.line.$$
	$cat $HOME/.line.$$ $HOME/.Toolboxes > $HOME/.Toolboxes.$$
	$mv $HOME/.Toolboxes.$$ $HOME/.Toolboxes
	$rm $HOME/.line.$$
fi

echo ""
echo "Your Khoros Toolbox file has been updated for Khoros 2.0"
echo ""
ConfirmContinue

newtopic

ans="n"
echo ""
echo "			Location of Khoros Binaries"
echo ""
while [ "$ans" = "n" ]; do
        echo ""
        echo "Please enter the full path to the Khoros 2.0 binaries"
        echon "[$TOPDIR/bin]: "
        read temp
        if [ "$temp" = "" ]; then
                temp="$TOPDIR/bin"
        fi

        if [ -d "$temp" ]; then
                BINDIR=$temp
                ans="y"
        elif [ ! -d "$temp" ]; then
		echo ""
		echo not a valid directory $temp\!
		echo ""
        fi
done

# ========================================================================
# 
# Give the user a .khoros_env file, setup their environment
# This file will be sourced from their .cshrc
#
# ========================================================================

newtopic
$cat <<EofKhorosEnv

		Setting up Khoros Environment Variables

	You need to ensure certain environment variables are set every
	time you log in.  In this step we will give you a .khoros_env
	file, which will be source'd from your .cshrc.  We will set up
	this file to reflect your local configuration.

EofKhorosEnv
ConfirmContinue
$cat $TOPDIR/bootstrap/repos/dotfiles/khoros_env |  $sed -e s:TOPDIR:$TOPDIR:g > $HOME/.khoros_env.$$
$cat $HOME/.khoros_env.$$ | $sed -e s:BINDIR:$BINDIR:g > $HOME/.khoros_env
$rm $HOME/.khoros_env.$$

echo "Your .khoros_env file now looks like:"
echo ""
$cat $HOME/.khoros_env | $sed -e 's/^/	/'
echo ""
ConfirmContinue

newtopic
$cat <<EofCshrc

			Modifying your .cshrc

	The last step is to append a couple of lines to your .cshrc,
	which will source the .khoros_env file.  Your path is appended
	when sourcing the \$HOME/.khoros_env file:

		source \$HOME/.khoros_env

	Make sure once the script exits, you execute the following command
	   % source $HOME/.khoros_env

EofCshrc

$cat <<EofOutta >> $HOME/.cshrc
# The following line was added automatically, by Khoros kconfigure script
source \$HOME/.khoros_env
EofOutta
ConfirmContinue
exit 1
