/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/* Copyright (C) 1991, 1992 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>         Used by General Khoros STDIO Transport Routines
   >>>>
   >>>>   Private:
   >>>>			kdoscan()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"	


/*-----------------------------------------------------------
|
|  Routine Name: kdoscan - use GNUs fine _vscanf routine to let 
| 	 	 us have distributed scanfs
|
|       Purpose: This is a modified version of _vfscanf from GNU
|
|         Input: file   - kfile structure
|		 string - the input string
|		 format - the scanner format
|		 args   - the variable arguments
|
|        Output: none
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: GNU with modifications by Steve Kubica
|          Date: 
| Modifications: Modified to be use ktransport library I/O (SK)
|
------------------------------------------------------------*/

int kdoscan(
   kfile    *file,
   char     *string,
   char     *format,
   kva_list args)
{
	register char *f = format; 
        register int fc;              /* Current character of the format */
        register size_t done = 0;      /* Assignments done */
        register size_t read_in = 0;   /* Chars read in */
        register int c;                /* Last char read */
        register int decimal;          /* decimal */
        register int do_assign;        /* Whether to do an assignment */
        register int width;            /* Maximum field width */

        char is_short, is_long, is_long_double;  /* Type modifers */

        char got_dot, got_e;  /* Status for reading F-P nums.  */
        int  not_in;          /* If a [...] is a [^...].  */
        int  base;            /* Base for integral numbers.  */

        long int num;           /* Integral holding variables.  */
        unsigned long int unum; 

        double fp_num;             /* Floating-point holding variable.  */
        register char *str = NULL; /* Character-buffer pointer.  */
        char work[200];            /* Workspace.  */
        char *w;                   /* Pointer into WORK.  */

#define outchar()   (!string ? kungetc(c, file) : (string--, c))
#define inchar()    (!string ? \
		    (((c = kfgetc( file )) == EOF) ? EOF : (++read_in, c)) : \
		    (((c = *string) == '\0') ? EOF : (++read_in, ++string, c)))

        if ( format == NULL )
        {
	  errno = KINVALID_PARAMETER;
          kerror( NULL, "kfscanf", "format not specified" );
          return(EOF);
        }

	decimal = '.';
        (void) inchar();

        /* 
         *   Run through the format string.  
         */
	while ( (int) *f != '\0' )
        {
           fc = (int) *f++;

           if ( fc != '%' )
           {
              /* Characters other than format specs must just match.  */
             if (c == EOF)
               return(done);
             if (isspace(fc))
             {
                /* Whitespace characters match any amount of whitespace.  */
                while (isspace (c))
                  (void) inchar();
                continue;
             }
             else if (c == fc)
                (void) inchar();
             else
                return( (c == EOF || outchar()), done);
             continue;
           }

           /* Check for the assignment-suppressant.  */
           if ((int) *f == '*')
           {
              do_assign = 0;
              ++f;
           }
           else
              do_assign = 1;
                
           /* Find the maximum field width.  */
           width = 0;
           while (isdigit(*f))
           {
              width *= 10;
              width += (int) *f++ - '0';
           }
           if (width == 0)
              width = -1;

           /* Check for type modifiers.  */
           is_short = is_long = is_long_double = 0;
           while ((int) *f == 'h' || (int) *f == 'l' || (int) *f == 'L')
	   {
              switch (*f)
              {
                 case 'h':
                    /* int's are short int's.  */
                    is_short = TRUE;
                 break;

                 case 'l':
                    /* int's are long int's.  */
                    is_long = TRUE;
                 break;

		 default:
	         break;
             }
	     f++;
	  }

          /* End of the format string?  */
          if ((int) *f == '\0')
             return( (c == EOF || outchar()), done);

          /* Find the conversion specifier.  */
          w = work;
          fc = (int) *f++;
          if (fc != '[' && fc != 'c' && fc != 'n')
             /* Eat whitespace.  */
             while (isspace(c))
                (void) inchar();

          switch (fc)
	  {
             case '%':       /* Must match a literal '%'.  */
                if (c != fc)
                   return( (c == EOF || outchar()), done);
             break;

             case 'n':       /* Answer number of assignments done.  */
                if (do_assign)
                   *kva_arg(args, int *) = read_in;
             break;

             case 'c':       /* Match characters.  */
                if (do_assign)
                {
                   str = kva_arg(args, char *);
                   if (str == NULL)
                      return( (c == EOF || outchar()), done);
                }

                if (c == EOF)
                   return(done);

                if (width == -1)
                  width = 1;

                if (do_assign)
		{
		   do
		   {
                      *str++ = c;
		      width--;
		   }
                   while (inchar() != EOF && width > 0);
		}
                else
                   while (inchar() != EOF && width-- > 0)
                   ;

                if (do_assign)
                   ++done;

                if (c == EOF && width > 0)
                   return(done);

             break;

             case 's':       /* Read a string.  */
                if (do_assign)
                {
                   str = kva_arg(args, char *);
                   if (str == NULL)
                      return( (c == EOF || outchar()), done);
                }

                if (c == EOF)
                   return(done);

                do
                {
                   if (isspace(c))
                      break;
                   if (do_assign)
                      *str++ = c;
                   if (width > 0 && --width == 0)
                      break;
                } while (inchar() != EOF);

                if (do_assign)
                {
                   *str = '\0';
                   ++done;
                }
             break;

             case 'x':       /* Hexadecimal integer.  */
             case 'X':
                base = 16;
                goto number;

             case 'o':       /* Octal integer.  */
                base = 8;
                goto number;

             case 'u':       /* Decimal integer.  */
             case 'd':       /* Ditto.  */
                base = 10;
                goto number;

             case 'i':       /* Generic number.  */
                base = 0;

             number:;
                if (c == EOF)
                   return(done); 

                /* Check for a sign.  */
                if (c == '-' || c == '+')
                {
                   *w++ = c;
                   if (width > 0)
                      --width;
                   (void) inchar();
                }

                /* Look for a leading indication of base.  */
                if (c == '0')
                {
                   if (width > 0)
                      --width;
                   *w++ = '0';

                   (void) inchar();

                   if (tolower(c) == 'x')
                   {
                      if (base == 0)
                         base = 16;
                      if (base == 16)
                      {
                         if (width > 0)
                            --width;
                           (void) inchar();
                      }
                   }
                   else if (base == 0)
                     base = 8;
                }

                if (base == 0)
                   base = 10;

                /* Read the number into WORK.  */
                do
                {
                   if ( base == 16 ? !isxdigit(c) :
                        (!isdigit(c) || c - '0' >= base) )
                      break;
                   *w++ = c;
                   if ( width > 0 )
                      --width;
                } while ( inchar() != EOF && width != 0 );

                if (w == work ||
                   (w - work == 1 && (work[0] == '+' || work[0] == '-')))
                   /* There was on number.  */
                   return( (c == EOF || outchar()), done);

                /* Convert the number.  */
                *w = '\0';
                num = strtol(work, &w, base);
                if (w == work)
                   return( (c == EOF || outchar()), done);

                if (do_assign)
                {
                if (is_long)
                   *kva_arg(args, long int *) = num;
                else if (is_short)
                   *kva_arg(args, short int *) = (short int) num;
                else
                   *kva_arg(args, int *) = (int) num;
                ++done;
                }
             break;

             case 'e':       /* Floating-point numbers.  */
             case 'E':
             case 'f':
             case 'g':
             case 'G':
                if (c == EOF)
                   return(done); 

                /* Check for a sign.  */
                if (c == '-' || c == '+')
                {
                   *w++ = c;
                   if (inchar() == EOF)
                      return(done);
                   if (width > 0)
                     --width;
                }

                got_dot = got_e = 0;
                do
                {
                   if (isdigit(c))
                      *w++ = c;
                   else if (got_e && (int) w[-1] == 'e' &&
			(c == '-' || c == '+'))
                      *w++ = c;
                   else if (!got_e && tolower(c) == 'e')
                   {
                      *w++ = 'e';
                      got_e = got_dot = 1;
                   }
                   else if (c == decimal && !got_dot)
                   {
                      *w++ = c;
                      got_dot = 1;
                   }
                   else
                      break;
                   if (width > 0)
                      --width;
                } while (inchar() != EOF && width != 0);

                if (w == work)
                   return( (c == EOF || outchar()), done);
                if ((int) w[-1] == '-' || (int) w[-1] == '+' ||
			(int) w[-1] == 'e')
                   return( (c == EOF || outchar()), done);

                /* Convert the number.  */
                *w = '\0';
                fp_num = strtod(work, &w);
                if (w == work)
                   return( (c == EOF || outchar()), done);

                if (do_assign)
                {
                   if (is_long)
		   {
                      *kva_arg(args, double *) = (double) fp_num;
		   }
                   else
		   {
                      *kva_arg(args, float *) = (float) fp_num;
		   }
                   ++done;
                }
             break;

             case '[':       /* Character class.  */
                if (do_assign)
                {
                   str = kva_arg(args, char *);
                   if ( str == NULL )
                      return( (c == EOF || outchar()), done);
                }
    
                if (c == EOF)
                   return(done);
    
                if ((int) *f == '^')
                {
                   ++f;
                   not_in = 1;
                }
                else
                   not_in = 0;
 
                while ((fc = (int) *f++) != '\0' && fc != ']')
                {
                   if ( fc == '-' && (int) *f != '\0' && (int) *f != ']' &&
                        w > work && w[-1] <= *f )
                      /* Add all characters from the one before the '-'
                         up to (but not including) the next format char.  */
                      for (fc = w[-1] + 1; fc < (int) *f; ++fc)
                         *w++ = fc;
                   else
                      /* Add the character to the list.  */
                      *w++ = fc;
                }
                if (fc == '\0')
                   return( (c == EOF || outchar()), done);
   
                *w = '\0';
                unum = read_in;
                do
                {
                   if ((kstrchr(work, c) == NULL) != not_in)
                     break;

/* added: if (c == '\\') code below MY Feb 24, 1995 */
		   if (c == '\\')
		   {
                     *str++ = c;
		     if (inchar() == EOF) break;
		   }

                   if (do_assign)
                      *str++ = c;
                   if (width > 0)
                      --width;
                } while (inchar() != EOF && width != 0);

/* was: if (read_in == unum) MY Jun 03, 1993 */
                if (read_in == unum && !not_in)
                   return( (c == EOF || outchar()), done);
    
                if (do_assign)
                {
                   *str = '\0';
                   ++done;
                }
             break;
 
             case 'p':       /* Generic pointer.  */
                base = 16;
                /* A PTR must be the same size as a `long int'.  */
                is_long = 1;
                goto number;
          }
 	}
	return((c == EOF || outchar()), done);
}
