/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>                Form Shell Routines                    <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>                kvf_begin_form                         <<<<
   >>>>                kvf_begin_control                      <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/*-----------------------------------------------------------------
|
|  Routine Name: kvf_begin_form
|
|	Purpose: Starts up the root of the form tree, with default values.
|		 provides a "skeleton" database.
|
|	  Input: none		
|
|        Output: Returns a pointer to the form tree
|
|    Written By: Danielle Argiro
|          Date: Jul 16, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------------*/

kform *kvf_begin_form(void)
{
	static int count = 0;
	Line_Info  line_info;
	kform      *form;
	char       temp[KLENGTH];

	/* allocate room for the form structure & return on failure */
        if ((form = (kform *) kcalloc(1,sizeof (kform))) == NULL)
        {
	    kerror("kforms", "kvf_begin_form",
            	   "Could not allocate room for kform struct");
            return(NULL);
        }

	/* initialize form with defaults */
        form->toplevel        = NULL;
        form->control_line    = NULL;
        form->control_comment = NULL;
	form->quit            = FALSE;
	form->master          = NULL;
	form->subform         = NULL;
        form->var_token       = kstring_to_token("not_used");

	/* create a generic StartForm line */
	kvf_clear_line_info(&line_info);
        line_info.typeflag = KUIS_STARTSUBFORM;
        line_info.activate = 1;    
	line_info.selected = 1;
        line_info.width    = 0;            
	line_info.height   = 0;
        line_info.x        = 0;        
	line_info.y        = 0;
        line_info.xpos     = 0;      
	line_info.ypos     = 0;
        line_info.title    = NULL;
        ksprintf(temp, "not_used_%d", count++);
        line_info.variable = kstrdup(temp);
        kvf_deparse_startform_line(&line_info, &form->control_line); 

	kvf_add_entry((kaddr) form, KFORM, TRUE, NULL, NULL);
	kvf_free_line_info_strings(&line_info);
	return(form);
}


/*-----------------------------------------------------------------
|
|  Routine Name: kvf_begin_control
|
|	Purpose: Starts up a control panel for a form (a master, 
|                guidepane, or pane) with default values.
|
|	  Input: form    - pointer to form tree to which control will belong
|                subform - pointer to subform (for guide panes and panes)
|                guide   - pointer to guide   (for panes only)
|                type    - one of KMASTER, KGUIDEPANE, or KPANE
|
|        Output: Returns a pointer to the control structure
|
|    Written By: Danielle Argiro
|          Date: Oct 14, 1992
| Modifications: 
|
------------------------------------------------------------------*/

kcontrol *kvf_begin_control(
   kform    *form,
   ksubform *subform,
   kguide   *guide,
   int      type)
{
	static int count = 0;
	kcontrol   *control;
	char       temp[KLENGTH];
	Line_Info  line_info;

	/* allocate room for the form structure & return on failure */
        if ((control = (kcontrol *) kcalloc(1,sizeof (kcontrol))) == NULL)
        {
	    kerror("kforms", "kvf_begin_control",
            	   "Could not allocate room for kcontrol struct");
            return(NULL);
        }
	
	control->back		 = NULL;
	control->label_object	 = NULL;
	control->control_comment = NULL;
	control->control_line    = NULL;
	control->type            = type;
	control->excl_subforms   = FALSE;

	control->sel_list        = NULL;
	control->guide_list      = NULL;
	control->subform_list    = NULL;

	control->back_guide      = guide;
	control->back_subform    = subform;
	control->back_form       = form;

	kvf_clear_line_info(&line_info);

	/* create a generic StartForm line */
	if (type == KMASTER)
	{
	    line_info.typeflag    = KUIS_STARTMASTER;
	    line_info.activate    = 1;
	    line_info.logical_val = 0;
	    kvf_deparse_startmaster_line(&line_info, &control->control_line);
	}
	else if (type == KGUIDEPANE)
	{
            line_info.typeflag = KUIS_STARTGUIDE;
            line_info.activate = 1;    
            line_info.width    = 0;            
	    line_info.height   = 0;
            line_info.x        = 0;        
	    line_info.y        = 0;
            line_info.xpos     = 0;      
	    line_info.ypos     = 0;
            line_info.title    = kstrdup("Dummy Guide");
            ksprintf(temp, "not_used_%d", count++);
            line_info.variable = kstrdup(temp);
            kvf_deparse_startguide_line(&line_info, &control->control_line); 
	}
	else if (type == KPANE)
	{
            line_info.typeflag = KUIS_STARTPANE;
            line_info.activate = 1;
            line_info.selected = 0;
            line_info.width    = 0;
            line_info.height   = 0;
            line_info.x        = 0;
            line_info.y        = 0;
            line_info.xpos     = 0;
            line_info.ypos     = 0;
            line_info.title    = kstrdup("Dummy Pane");
            ksprintf(temp, "not_used_%d", count++);
            line_info.variable = kstrdup(temp);
            kvf_deparse_startpane_line(&line_info, &control->control_line);
        }
	control->back_kformstruct = kvf_create_struct((kaddr) control,
                                                  line_info.typeflag, type);
	kvf_link_formstruct(control->back_kformstruct);
	kvf_free_line_info_strings(&line_info);
	return(control);
}
