/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Declarations of routines to 
   >>>>                set and get kform attributes
   >>>>
   >>>>    Written By: Danielle Argiro
   >>>>
   >>>>          Date: March 21, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kforms_attributes_h_
#define _kforms_attributes_h_


#define kvf_check_boolean(val)  (((val != 0) && (val != 1))? 0 : 1)

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 * attributes.c
 */
int kvf_check_attributes PROTO((char *, kform_struct *, char *));

	/*-------------------------------------*
	|       typedefs 
	---------------------------------------*/

typedef int (*attribute_handler) PROTO((kform_struct *, char *, kaddr));

typedef struct _AttributeEntry
{
	int                     token;
        char                    *attribute;
	int                     data_type;
        attribute_handler       get_attr_routine;
        attribute_handler       set_attr_routine;

} AttributeEntry;

extern int            kvf_attribute_num;
extern AttributeEntry kvf_attribute_table[];

#endif /* _kforms_attributes_h_ */
/* Don't add after this point */
