 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>      Various Private Print Routines For the kexpr Library
   >>>>
   >>>>  Private:
   >>>>		init_constant()
   >>>>		kexpr_get_constant()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include "y.tab.h"


/*
 * Constant declaration list
 */
static struct _constant constants[] =
{
    { "e",        KE        },
    { "pi",       KPI       },
    { "deg",      KDEG      },
    { "phi",      KPHI      },
    { "maxfl",    KMAXFLOAT },
    { "maxint",   KMAXLINT  },
    { "maxshort", KMAXSINT  },
    { "gamma",    KGAMMA    },
    { "log2e",    KLOG2E    },
    { "log10e",   KLOG10E   },
    { "ln2",      KLN2      },
    { "ln10",     KLN10     },
    { "pi_2",     KPI_2     },
    { "pi_4",     KPI_4     },
    { "sqrtpi",   KSQRTPI   },
    { "sqrt2",    KSQRT2    },
    { "sqrt1_2",  KSQRT1_2  },
    {  NULL,	  0	    },
};

/*-----------------------------------------------------------
|
|  Routine Name: init_constant - initialize the kexpr parser
|
|       Purpose: This routine initializes the kexpr parser.  This call
|		 used to initialize the constants, functions, and
|		 global variable lists.  It MUST be called prior to ANY
|		 other calls to the kexpr library.
|
|         Input:
|        Output:
|	Returns:
|
|  Restrictions: 
|    Written By: Mark Young  
|          Date: Thu Jun 25 1992
|      Verified:
|  Side Effects:
| Modifications:
|
*-----------------------------------------------------------*/

static void init_constant(void)
{
	int	i;
	Varlist *varlist;
	static int initialized = FALSE;


	if (initialized == TRUE)
	   return;

	/*
	 * Install the varlist for Constants, Functions, and Global
	 * variables.
	 */
	initialized = TRUE;
	if ((varlist = kexpr_get_varlist(CONSTANT_ID)) != NULL)
	{
	   for (i = 0; constants[i].name != NULL; i++)
	   {
	       (void) kexpr_add_symbol(varlist, constants[i].name, CONSTANT,
			       constants[i].value);
	   }
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: kexpr_get_constant - get constant symbol
|
|       Purpose: kexpr_get_constant() - pulls constant name from
|		 the expression string.
|
|         Input: string - the string which contains the constant
|
|        Output: None, except that the resulting constant is stored
|		 in the global kexpr_lval.symbol.
|
|    Written By: Mark Young  
|          Date: Thu Jun 25 1992
| Modifications:
|
------------------------------------------------------------*/

Symbol *kexpr_get_constant(
   char *string)
{
	Symbol  *symbol;
	Varlist *varlist;


	/*
	 * Check for constant value first then check to see if it is
	 * a constant
	 */
	init_constant();
	if ((varlist = kexpr_get_varlist(CONSTANT_ID)) != NULL)
	{
	   if ((symbol = kexpr_get_symbol(varlist, string, TRUE)) == NULL)
	      return(kexpr_get_variable(string, TRUE));
	   else
	      return(symbol);
	}
	return(NULL);
}
