/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Code Generation library, internal definitions
   >>>>
   >>>>    Written By: Danielle Argiro
   >>>>
   >>>>          Date: Apr 04, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kcodegen_internals_h_
#define _kcodegen_internals_h_

	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include <bootstrap.h>

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

#define KCODEGEN	"kcodegen"

#define KGEN_GUI_OPTIONAL 0
#define KGEN_GUI_LIVE     1
#define KGEN_GUI_BUTTON   2


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

extern kselection *kgen_req_sels[MAX_CMDLINE_ARGS]; /* required selections */
extern kselection *kgen_opt_sels[MAX_CMDLINE_ARGS]; /* optional selections */

extern int kgen_debug;          /* TRUE if generating debug stmts */

extern int kgen_req_num;        /* # required arguments           */
extern int kgen_opt_num;        /* # optional arguments           */
extern int kgen_arg_total;      /* total # arguments              */

extern char kgen_fulltopsrc[KLENGTH];/* full src path directory              */
extern char *kgen_tmpdirname;       /* directory in which to gen tm fines    */


/*
 *  definitions of parsing calls
 */
extern char *parseI;
extern char *parseA;
extern char *parseO;
extern char *parseZ;
extern char *parsei;
extern char *parsef;
extern char *parseh;
extern char *parsel;
extern char *parseF;
extern char *parses;
extern char *parsea;
extern char *parsey;
extern char *parseT;
extern char *parseR;
extern char *parseA;
extern char *parsem;
extern char *parsen;
extern char *parsec;
extern char *parsex;
extern char *parsez;
extern char *parseH;
extern char *parseB;
extern char *parsew;
extern char *parseQ;
extern char *parseP;
extern char *parseM;

/*
 *  definitions of deparsing calls
 */
extern char *deparseI;
extern char *deparseA;
extern char *deparseO;
extern char *deparseZ;
extern char *deparsei;
extern char *deparsef;
extern char *deparseh;
extern char *deparsel;
extern char *deparses;
extern char *deparsey;
extern char *deparseT;
extern char *deparseR;
extern char *deparsea;
extern char *deparsem;
extern char *deparsen;
extern char *deparsec;
extern char *deparsex;
extern char *deparsez;
extern char *deparseH;
extern char *deparseB;
extern char *deparsew;
extern char *deparseQ;
extern char *deparseP;
extern char *deparseM;

/*
 * various & sundry helper strings
 */
extern char *kgen_str_neq_null;
extern char *kgen_fil_neq_null;
extern char *kgen_strdef_neq_null;
extern char *kgen_fildef_neq_null;
extern char *kgen_selected;


	/*-------------------------------------*
	|       macros
	---------------------------------------*/
/*---------------------------------------------------------------------
 *  NOTE: The following header is bogus, but is necessary so that the
 *  manual will have a properly formated layout example for the
 *  PS1.1.intro chapter
 *--------------------------------------------------------------------*/
/************************************************************
*
*  Routine Name: function_name - short function description
*
*       Purpose: Detailed description of the function
*
*         Input: input_1  - input argument 1 description
*                input_2  - input argument 2 description
*        Output: output_1 - output argument 1 description
*                output_2 - output argument 2 description
*       Returns: what the function returns
*  Restrictions: restrictions of the function (if any)
*    Written By: author
*          Date: date of creation
*      Verified:
*  Side Effects: side effects of the function (if any)
* Modifications:
*   Declaration: return_data_type function_name(
*		 !   data_type input_1,
*		 !   data_type input_2,
*		 !   data_type output_1,
*		 !   data_type output_2)
*************************************************************/
#define function_name		1


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* clui_codedoc.c */
int kgen_generate_whatis        PROTO((kobject, char *, char *));
int kgen_generate_manpage       PROTO((kobject, header_info *, char *));
 
/* clui_cmdline.c */
int kgen_clui_cmdline           PROTO((char *, char *, kfunc_void,
                                      kselection *, int *));
int kgen_clui_cmdline_mut_excl  PROTO((char *, char *, kfunc_void,
                                      kselection *, int *));
int kgen_clui_cmdline_mut_incl  PROTO((char *, char *, kfunc_void,
                                      kselection *, int *));
int kgen_clui_cmdline_loose     PROTO((char *, char *, kfunc_void,
                                      kselection *, int *));

/* clui_genfree.c */
void kgen_clui_print_free_args  PROTO((kobject, kfile *, char **));
 

/* clui_genhlp.c */
int kgen_clui_generate_helpfile PROTO((kobject, char **, char *, char *, 
				       char *));
 
/* clui_genincl.c */
int kgen_clui_generate_hfile    PROTO((kobject, char **, char *, char *, 
                                       char *, int));
 
/* clui_genlib.c */
int kgen_clui_generate_lfile    PROTO((kobject, char **, char *));
int kgen_clui_genlibproto       PROTO((kobject, char **, char *, char *));
 
/* clui_genlibrary.c */
int kgen_clui_generate_library  PROTO((kobject));
 
/* clui_genmain.c */
int kgen_clui_generate_cfile    PROTO((kobject, char **, char *,
				       char *, int, char *));
 
/* clui_genman1.c */
int kgen_clui_generate_man1file PROTO((kobject, char **, char *, char *, 
				       char *, char *));
 
/* clui_genman3.c */
int kgen_clui_generate_man3file PROTO((kobject, char **, char *, char *, 
				       char *));
 
/* clui_genpanescr.c */
int kgen_clui_generate_panescript PROTO((kobject, char *, char *, char *, 
				       char *));
 
/* clui_genusage.c */
int kgen_clui_generate_getargs_file PROTO((kobject, kform *, char *, char *));
 
/* clui_getpane.c */
int kgen_clui_get_pane_info       PROTO((kform *));
void kgen_free_pane_info          PROTO((void));
 
/* clui_prompt.c */
int kgen_clui_prompt              PROTO((kselection *, int *));
int kgen_clui_prompt_mut_excl     PROTO((kselection *, int, int *));
int kgen_clui_prompt_mut_incl     PROTO((kselection *, int, int *));
int kgen_clui_prompt_loose        PROTO((kselection *, int, int *));
int kgen_clui_prompt_toggle       PROTO((kselection *, int *));
int kgen_clui_prompt_list         PROTO((kselection *, int *));

/* clui_pstrings.c */
char *kgen_create_pstr            PROTO((kselection *));
 
/* clui_usage.c */
void kgen_clui_print_usage        PROTO((kfile *));

/* clui_selections.c */
void kgen_clui_print_selections   PROTO((kfile *));

/* clui_util.c */
void kgen_clui_print_bounds       PROTO((kfile *, kselection *, int));
void kgen_clui_print_toggle_vals  PROTO((kfile *, kselection *, int, int));
void kgen_clui_print_list_vals    PROTO((kfile *, kselection *, int, int));
void kgen_print_group_choices     PROTO((kselection *, char *));
int  kgen_get_group_size          PROTO((kselection *));
void kgen_clui_print_toggle_debug_stmt PROTO((kfile *, kselection *));
 
/* gui_gendrv.c */
int kgen_gui_driver          PROTO((kform *, kobject, char *, int));
int kgen_gui_selection_debug PROTO((kfile *, kselection *, char *, char *));
 
/* gui_gendrv_util.c */
void kgen_gui_selection_comment  PROTO((kfile *, char *, int, char *, char *));
int  kgen_gui_file_hdr           PROTO((char *, kobject, char *, char **, int));
void kgen_gui_selection_function PROTO((kfile *, kselection *, int, char *, 
					char *, char *, char ***, int *, int,
					int));
 
/* gui_genincl.c */
int kgen_gui_include_file PROTO((kform *, kobject, char *, int));
 
/* gui_geninfo.c */
int kgen_gui_get_forminfo PROTO((kform *, kobject, char *, int));
 
/* gui_geninit.c */
int kgen_gui_init_forminfo    PROTO((kform *, kobject, char *));
int kgen_gui_init_subforminfo PROTO((kfile *, kfile *, ksubform *, char *, 
				     char *));
 
/* gui_geninit_util.c */
void kgen_gui_print_create_subform_struct 
		PROTO((kfile *, char *, char *, char *));
void kgen_gui_print_create_pane_struct 
		PROTO((kfile *, char *, char *, char *, int, char *));
int  kgen_create_pseudo_init 
		PROTO((kfile *, kfile *, ksubform *, char *, char *));
void kgen_gui_print_create_sel_struct PROTO((kfile *, char *, int, char *));
char *kgen_uis_type_string            PROTO((int));
void kgen_gui_init_warning            PROTO((kfile *, char *));
void kgen_gui_init_error              PROTO((kfile *, char *));
void kgen_create_init_srcfile_hdr     PROTO((kfile *, char *));
 
/* gui_utilities.c */
kfile *kgen_open_file                  PROTO((kobject, char *, int *));
int   kgen_selection_codegen_warranted PROTO((kselection *));
int   kgen_subform_codegen_warranted   PROTO((ksubform *));
int   kgen_valid_selections            PROTO((kselection *));
 
/* utilities.c */
char  *kgen_ascii_datatype             PROTO((int));
char  *kgen_ascii_def_val          PROTO((kselection *));
char  *kgen_ascii_def_toggle_value PROTO((kselection *));
kform *kgen_read_uis_info          PROTO((char *));

#endif /* _kcodegen_internals_h_ */
/* Don't add after this point */
