/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>       Utility Routines  for CLUI code generation      <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>                kgen_clui_print_bounds()               <<<<
   >>>>                kgen_clui_print_toggle_vals()	      <<<<
   >>>>                kgen_clui_print_list_vals()	      <<<<
   >>>>                kgen_print_group_choices()	      <<<<
   >>>>                kgen_get_group_size()	              <<<<
   >>>>                kgen_clui_print_toggle_debug_stmt()    <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/*-----------------------------------------------------------
|
|  Routine Name: kgen_clui_print_bounds
|
|       Purpose: This routine prints the bounds of an
|                integer, float, or double argument to the man1
|                page, the help page, or the tty for usage stmt
|                depending on the use_flag value
|
|         Input: file      - open stream to file being written
|                selection - int, float, or double selection
|                use_flag  - one of KGEN_CLUI_MAN1_SYNTAX,
|                                   KGEN_CLUI_HELP_SYNTAX,
|                                   KGEN_CLUI_PRINT_USAGE,
|        Output: none
|       Returns: none
|
|    Written By: Danielle Argiro
|          Date: March 30, 1994
| Modifications:
|
------------------------------------------------------------*/

void kgen_clui_print_bounds(
   kfile      *file,
   kselection *selection,
   int        use_flag)
{
	double lower, upper;
	int    int_upper, int_lower;
	float  flt_upper, flt_lower;
	char   buffer[KLENGTH];

	if (selection->type == KUIS_INTEGER) 
	{
	    kvf_get_attributes(selection->back_kformstruct,
                               KVF_INT_LOWER, &int_lower,
                               KVF_INT_UPPER, &int_upper,
                               NULL);
	    lower = (double) int_lower;
	    upper = (double) int_upper;
	    ksprintf(buffer, "0");
	}
	else if (selection->type == KUIS_FLOAT)
        {
            kvf_get_attributes(selection->back_kformstruct,
                               KVF_FLOAT_LOWER, &flt_lower,
                               KVF_FLOAT_UPPER, &flt_upper,
                               NULL);
            lower = (double) flt_lower;
            upper = (double) flt_upper;
	    ksprintf(buffer, "0.0");
        }
        else if (selection->type == KUIS_DOUBLE)
        {
            kvf_get_attributes(selection->back_kformstruct,
                               KVF_DOUBLE_LOWER, &lower,
                               KVF_DOUBLE_UPPER, &upper,
                               NULL);
	    ksprintf(buffer, "0.0");
	}
	else 
	{
	    kerror(KCODEGEN, "kgen_clui_print_bounds",
		   "invalid selection type passed in; only int, float, and double selections accepted");
	    return;
	}

        if (lower == upper)
        {
            if (lower == -2.0)
            {
        	if ((use_flag == KGEN_CLUI_MAN1_SYNTAX) || 
		    (use_flag == KGEN_CLUI_HELP_SYNTAX))
                    kfprintf(file, "bounds: value < %s\n.br\n", buffer);
		else if  (use_flag == KGEN_CLUI_PRINT_USAGE)
                    kfprintf(file, "%s < %s", 
			     ktoken_to_string(selection->var_token), buffer);
            }
            else if (lower == -1.0)
            {
        	if ((use_flag == KGEN_CLUI_MAN1_SYNTAX) || 
		    (use_flag == KGEN_CLUI_HELP_SYNTAX))
                    kfprintf(file, "bounds: value <= %s\n.br\n", buffer);
		else if (use_flag == KGEN_CLUI_PRINT_USAGE)
                    kfprintf(file, "%s <= %s",
			     ktoken_to_string(selection->var_token), buffer);
            }
            else if (lower == 1.0)
            {
        	if ((use_flag == KGEN_CLUI_MAN1_SYNTAX) || 
		    (use_flag == KGEN_CLUI_HELP_SYNTAX))
                    kfprintf(file, "bounds: value >= %s\n.br\n", buffer);
		else if (use_flag == KGEN_CLUI_PRINT_USAGE)
                    kfprintf(file, "%s >= %s",
			     ktoken_to_string(selection->var_token), buffer);
            }
            else if (lower == 2.0)
            {
        	if ((use_flag == KGEN_CLUI_MAN1_SYNTAX) || 
		    (use_flag == KGEN_CLUI_HELP_SYNTAX))
                    kfprintf(file, "bounds: value > %s\n.br\n", buffer);
		else if (use_flag == KGEN_CLUI_PRINT_USAGE)
                    kfprintf(file, "%s > %s",
			     ktoken_to_string(selection->var_token), buffer);
            }
            else
            {
        	if ((use_flag == KGEN_CLUI_MAN1_SYNTAX) || 
		    (use_flag == KGEN_CLUI_HELP_SYNTAX))
                    kfprintf(file, "bounds: no range checking\n.br\n");
		else if (use_flag == KGEN_CLUI_PRINT_USAGE)
                 kfprintf(file, "unbounded");
            }
        }
        else   
        {
             if ((use_flag == KGEN_CLUI_MAN1_SYNTAX) || 
		 (use_flag == KGEN_CLUI_HELP_SYNTAX))
                 kfprintf(file, "bounds: %g < [-%s] < %g\n.br\n", 
        	 	  lower, ktoken_to_string(selection->var_token), 
			  upper);
	     else if (use_flag == KGEN_CLUI_PRINT_USAGE)
                 kfprintf(file, "%g <= %s <= %g", lower, 
			  ktoken_to_string(selection->var_token), upper);
        }
}

/*-----------------------------------------------------------
|
|  Routine Name: kgen_clui_print_toggle_vals
|
|       Purpose: Prints the possible toggle vals to the:
|                - man1 file (if use_flag == KGEN_CLUI_MAN1_SYNTAX)
|                - help file (if use_flag == KGEN_CLUI_HELP_SYNTAX)
|                - tty for usage stmt (if use_flag == KGEN_CLUI_PRINT_USAGE)
|                - *.h file  (if use_flag == KGEN_CLUI_INFO_STRUCT)
|
|         Input: file      - open stream to man1 page
|		 selection - selection associated with toggle argument
|		 use_flag  - one of KGEN_CLUI_MAN1_SYNTAX,
|                                   KGEN_CLUI_HELP_SYNTAX,
|                                   KGEN_CLUI_PRINT_USAGE,
|                                   KGEN_CLUI_INFO_STRUCT,
| 	 Output: none
|    Written By: Danielle Argiro
|          Date: March 30, 1994
| Modifications: 
|
------------------------------------------------------------*/

void kgen_clui_print_toggle_vals(
   kfile      *file,
   kselection *selection,
   int        use_flag,
   int        nested)
{
	int  i;
	int  toggle_type, toggle_size;
	char **descriptions, **values;

	kvf_get_attributes(selection->back_kformstruct,
			   KVF_TOGGLE_TYPE,          &toggle_type,
			   KVF_TOGGLE_SIZE,          &toggle_size,
			   KVF_TOGGLE_CONTENTS_DESC, &descriptions,
			   KVF_TOGGLE_CONTENTS,      &values,
			   NULL);
        i = 0;
        while (i < toggle_size)
	{
	    if (descriptions[i] == NULL)
		descriptions[i] = kstrdup("no description");

	    if (i < toggle_size - 1)
	    {
                if ((use_flag == KGEN_CLUI_MAN1_SYNTAX) || 
		    (use_flag == KGEN_CLUI_HELP_SYNTAX))
		    kfprintf(file, "%s (%s), \n.br\n", 
			     values[i], descriptions[i]);

		else if (use_flag == KGEN_CLUI_INFO_STRUCT)
		    kfprintf(file, " *\t%s (%s)\n", 
			     values[i], descriptions[i]);

                else if (use_flag == KGEN_CLUI_PRINT_USAGE)
                {
                    if (nested)
                       kfprintf(file, "\t\t\t%s  (%s),\n",
			        values[i], descriptions[i]);
                    else kfprintf(file, "\t\t%s  (%s),\n",
			          values[i], descriptions[i]);
                }

	        else if (use_flag == KGEN_CLUI_GETARGS_SYNTAX)
		    kfprintf(file, 
			 "\t\t    kfprintf(kstderr, \"%s\\t(%s),\\n\");\n", 
			  values[i], descriptions[i]);

		else if (use_flag == KGEN_CLUI_PSTR_SYNTAX)
		    kfprintf(file, "\\t\\t%s (%s)\\n", 
			     values[i], descriptions[i]);
	    }
	    else 
	    {
                if ((use_flag == KGEN_CLUI_MAN1_SYNTAX) || 
		    (use_flag == KGEN_CLUI_HELP_SYNTAX))
		    kfprintf(file, "or %s (%s)\n.br\n", 
			     values[i], descriptions[i]);

		else if (use_flag == KGEN_CLUI_INFO_STRUCT)
		    kfprintf(file, " *\t%s (%s),\n", 
			     values[i], descriptions[i]);

                else if (use_flag == KGEN_CLUI_PRINT_USAGE)
                {
                    if (nested)
                        kfprintf(file, "\t\t\tor %s  (%s)\n",
		  	         values[i], descriptions[i]);
                    else kfprintf(file, "\t\tor %s  (%s)\n",
		  	         values[i], descriptions[i]);
		}

	        else if (use_flag == KGEN_CLUI_GETARGS_SYNTAX)
		    kfprintf(file, 
			     "\t\t    kfprintf(kstderr, \"or %s (%s)\");\n", 
		  	     values[i], descriptions[i]);

		else if (use_flag == KGEN_CLUI_PSTR_SYNTAX)
		    kfprintf(file, "\\t\\tor %s (%s)\\n", 
		  	     values[i], descriptions[i]);

	    }
	    i++;
	}
}


/*-----------------------------------------------------------
|
|  Routine Name: kgen_clui_print_list_vals
|
|       Purpose: Prints the possible toggle vals to the:
|                - man1 file (if use_flag == KGEN_CLUI_MAN1_SYNTAX)
|                - help file (if use_flag == KGEN_CLUI_HELP_SYNTAX)
|                - tty for usage stmt (if use_flag == KGEN_CLUI_PRINT_USAGE)
|                - *.h file  (if use_flag == KGEN_CLUI_INFO_STRUCT)
|
|         Input: file      - open stream to man1 page
|                selection - selection associated with list argument
|                use_flag  - one of KGEN_CLUI_MAN1_SYNTAX,
|                                   KGEN_CLUI_HELP_SYNTAX,
|                                   KGEN_CLUI_PRINT_USAGE,
|                                   KGEN_CLUI_INFO_STRUCT,
|
|        Output: none
|    Written By: Danielle Argiro
|          Date: March 30, 1994
| Modifications: 
|
------------------------------------------------------------*/

void kgen_clui_print_list_vals(
   kfile      *file,
   kselection *selection,
   int        use_flag,
   int        nested)
{
	int  i, list_size, list_start;
	char **list_contents;

	kvf_get_attributes(selection->back_kformstruct, 
			   KVF_LIST_SIZE,     &list_size,
			   KVF_LIST_START,    &list_start,
			   KVF_LIST_CONTENTS, &list_contents,
			   NULL);
        i = 0;
        while (i < list_size)
        {
            if (i < list_size - 1)
	    {
                if ((use_flag == KGEN_CLUI_MAN1_SYNTAX) || 
		    (use_flag == KGEN_CLUI_HELP_SYNTAX))
		    kfprintf(file, " %d (%s), \n.br\n",
			     list_start+i, list_contents[i]);

		else if (use_flag == KGEN_CLUI_INFO_STRUCT)
		    kfprintf(file, " *\t%d (%s),\n",
			     list_start+i, list_contents[i]);

		else if (use_flag == KGEN_CLUI_PRINT_USAGE)
                {
		    if (nested)
		       kfprintf(file, "\t\t\t%d  \"%s\",\n",
			        list_start+i, list_contents[i]);

		    else kfprintf(file, "\t\t%d  \"%s\",\n",
			          list_start+i, list_contents[i]);
		}
	        else if (use_flag == KGEN_CLUI_GETARGS_SYNTAX)
		    kfprintf(file, 
			"\t\t    kfprintf(kstderr, \"%d  \\\"%s\\\", \\n\");\n",
			     list_start+i, list_contents[i]);
		
		else if (use_flag == KGEN_CLUI_PSTR_SYNTAX)
                    kfprintf(file, "\\t\\t%d (\\\"%s\\\")\\n",
			     list_start+i, list_contents[i]);
	    }
            else
	    {
                if ((use_flag == KGEN_CLUI_MAN1_SYNTAX) || 
		    (use_flag == KGEN_CLUI_HELP_SYNTAX))
                    kfprintf(file, "  or %d (%s)\n.br\n",
			     list_start+i, list_contents[i]);

                else if (use_flag == KGEN_CLUI_INFO_STRUCT)
                    kfprintf(file, " *\tor %d (%s)\n\n\t",
			     list_start+i, list_contents[i]);

		else if (use_flag == KGEN_CLUI_PRINT_USAGE)
                {
		    if (nested)
		        kfprintf(file, "\t\t\t or %d  \"%s\"\n",
			         list_start+i, list_contents[i]);

		    else kfprintf(file, "\t\t%d  \"%s\"\n",
			          list_start+i, list_contents[i]);
		}

                else if (use_flag == KGEN_CLUI_GETARGS_SYNTAX)
                    kfprintf(file, 
		      "\t\t    kfprintf(kstderr, \" or %d (\\\"%s\\\")\\n\");\n",
			     list_start+i, list_contents[i]);

                else if (use_flag == KGEN_CLUI_PSTR_SYNTAX)
                    kfprintf(file, "\\t\\tor %d (\\\"%s\\\")\\n",
			     list_start+i, list_contents[i]);
	    }
            i++;
        }
}

/*-----------------------------------------------------------
|
|       Routine: kgen_print_group_choices
|
|       Purpose: This routine prints the choices for
|                mutually exclusive groups' values to the tty
|
|         Input: print_space - spaces to print before values
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro
|          Date: March 30, 1994
| Modifications:
|
------------------------------------------------------------*/

void kgen_print_group_choices(
   kselection *group_start,
   char       *print_space)
{
	kselection *subgroup;
        kselection *groupmember;

        if (print_space != NULL)
            kfprintf(kstderr, "%s", print_space);

        groupmember = group_start->group_next;
        while (groupmember != NULL)
        {
	    if (groupmember->type == KUIS_BLANK)
	    {
		groupmember = groupmember->next;
		continue;
	    }
            if (groupmember->type == KUIS_MUTEXCL)
                kfprintf(kstderr, "one of the M.E. group (");
            if (groupmember->type == KUIS_MUTINCL)
                kfprintf(kstderr, "all or none of the M.I. group (");
            if (groupmember->type == KUIS_GROUP)
                kfprintf(kstderr, "one or more of the group (");
	    if ((groupmember->type == KUIS_GROUP) ||
		(groupmember->type == KUIS_MUTEXCL) ||
		(groupmember->type == KUIS_MUTINCL))
	    {
		subgroup = groupmember->group_next;
		while (subgroup != NULL)
	        {
		    if (subgroup->next != NULL)
		        kfprintf(kstderr, "-%s, ", 
		 	         ktoken_to_string(subgroup->var_token));
		    else kfprintf(kstderr, "-%s",
				 ktoken_to_string(subgroup->var_token));
		    subgroup = subgroup->next;
		}
		if (groupmember->next != NULL)
		   kfprintf(kstderr, "), or\n");
		else kfprintf(kstderr, ")\n");
	    }
            else 
	    {
		if (groupmember->next != NULL)
		   kfprintf(kstderr, "-%s, ",
                            ktoken_to_string(groupmember->var_token));
		else kfprintf(kstderr, "-%s",
                            ktoken_to_string(groupmember->var_token));
	    }
            groupmember = groupmember->next;
        }
        kfprintf(kstderr, "\n");

}  /* end kgen_print_group_choices */


/*-----------------------------------------------------------
|
|       Routine: kgen_get_group_size
|
|       Purpose: This routine counts the number of members in a group.
|
|         Input: group_start - header of the group list
|        Output: none
|       Returns: number of members in the group
|    Written By: Danielle Argiro
|          Date: March 31, 1994
| Modifications:
|
------------------------------------------------------------*/

int kgen_get_group_size(
   kselection *group_start)
{
        kselection *groupmember;
        int        count = 0;

        groupmember = group_start->group_next;
        while (groupmember != NULL)
        {
	    if (groupmember->type == KUIS_BLANK)
	    {
		groupmember = groupmember->next;
		continue;
	    }
            count++;
            groupmember = groupmember->next;
        }
        return(count);
}

/*-----------------------------------------------------------
|
|       Routine: kgen_clui_print_toggle_debug_stmt
|
|       Purpose: prints a single debug statement (for toggles only)
|
|         Input: file      - open stream to *.c file
|                selection - selection representing toggle
|                name      - name of program being generated
|
|        Output: none
|    Written By: Danielle Argiro
|          Date: Jul 20, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/

void kgen_clui_print_toggle_debug_stmt(
   kfile      *file,
   kselection *selection)
{
	int  toggle_type;
	char *variable;

	kvf_get_attribute(selection->back_kformstruct,
			  KVF_TOGGLE_TYPE, &toggle_type);

	variable = ktoken_to_string(selection->var_token);

        if ((toggle_type == KUIS_INPUTFILE)  ||
	    (toggle_type == KUIS_OUTPUTFILE) ||
	    (toggle_type == KUIS_STRING))
	{
	   kfprintf(file,
		"\tkfprintf(kstderr, \"%s_toggle = %%s\\n\", clui_info->%s_toggle);\n",
		variable, variable);
	}

	else if ((toggle_type == KUIS_LOGICAL)   || 
                 (toggle_type == KUIS_INTEGER) || 
		 (toggle_type == KUIS_FLAG))
	{
	   kfprintf(file,
		"\tkfprintf(kstderr, \"%s_toggle = %%d\\n\", clui_info->%s_toggle);\n",
		variable, variable);
	}

	else if (toggle_type == KUIS_FLOAT)
	{
	   kfprintf(file,
		"\tkfprintf(kstderr, \"%s_toggle = %%#g\\n\", clui_info->%s_toggle);\n",
		variable, variable);
	}
	
	else if (toggle_type == KUIS_DOUBLE)
	{
	   kfprintf(file,
		"\tkfprintf(kstderr, \"%s_toggle = %%#g\\n\", clui_info->%s_toggle);\n",
		variable, variable);
	}
	
	else if ((toggle_type == KUIS_LIST) ||
		 (toggle_type == KUIS_DISPLAYLIST))
	{
	   kfprintf(file,
		"\tkfprintf(kstderr, \"%s = %%d\\n\", clui_info->%s_list);\n",
		variable, variable);
	   kfprintf(file,
		"\tkfprintf(kstderr, \"%s_label = %%s\\n\", clui_info->%s_label);\n",
		variable, variable);
	}

	else if (toggle_type == KUIS_CYCLE) 
	{
	   kfprintf(file,
		"\tkfprintf(kstderr, \"%s = %%d\\n\", clui_info->%s_cycle);\n",
		variable, variable);
	   kfprintf(file,
		"\tkfprintf(kstderr, \"%s_label = %%s\\n\", clui_info->%s_label);\n",
		variable, variable);
	}
}  /* end kgen_clui_print_toggle_debug_stmt */

