/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>   Routines to Generate frontend shell script for pane <<<<
   >>>>                                                       <<<<
   >>>>   Private:                                            <<<<
   >>>>                kgen_clui_generate_panescript()        <<<<
   >>>>                                                       <<<<
   >>>>    Static:                                            <<<<
   >>>>    Public:                                            <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

/*-----------------------------------------------------------
|
|  Routine Name: kgen_clui_generate_panescript
|
|       Purpose: This routine creates the front-end shell script
|                for a pane object
|
|         Input: program   - program object being created
|                opath     -  path to program object being created
|                tb_name   -  toolbox passed in by user
|                oname     -  name of program object being generated
|		 bname	   -  name of the program binary being generated
|
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: Danielle Argiro
|          Date: Jan 17, 1994
| Modifications: 
|
------------------------------------------------------------*/

int  kgen_clui_generate_panescript(
   kobject   program,
   char      *opath,
   char      *tb_name,
   char      *oname,
   char      *bname)
{
        kstring   routine     = "kgen_clui_generate_panescript()";
	kobject   toolbox     = NULL;
	kobject   file_object = NULL;
	kstring   copyright   = NULL;
	int       force_flag  = FALSE;
	int       isnewfile   = FALSE;
	kfile    *file;
	kstring   filepath;
	char      temp[KLENGTH];

        /*
         * get file object representing *.sh page
         */
	if (!kcms_get_attributes(program,
				 KCMS_PARENT,           &toolbox,
				 KCMS_CMOBJ_GEN_SCRIPT, &file_object,
				 KCMS_END)
	    || !kcms_query_bit(program, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE,
			       &force_flag))
	    return(FALSE);
		
	/*
         * 1st time *.sh file has been created - create file object, so that 
         * kcms registers the shell script in the kcms database
         */
	if (file_object == NULL)
        {
            ksprintf(temp, "%s/src/%s.sh", opath, oname);
            file_object = kcms_create_fileobj(program, temp, NULL,
                                              KCMS_FOBJ_TYPE_SCRIPT,
					      KCMS_FOBJ_SUBTYPE_SH,
					      KCMS_FOBJ_GEN_SCRIPT,
					      KCMS_FOBJ_ACCESS_RDWR);
	    if (file_object == NULL)
		return(FALSE);
	    isnewfile = TRUE;
	    filepath = temp;
	}

	/*
         * the *.sh file has already been created & added to kcms database;
         * simply get the path to the *.sh file.
         */
	else if (!kcms_get_attribute(file_object, KCMS_PATH, &filepath))
            return(FALSE);

        /*
         *  if somehow the database GHOST_SRC key got deleted from the kcms
         *  database, but the *.sh file really is there, don't want to
         *  clobber it!
         */
	if ((isnewfile) && (kaccess(filepath, R_OK) == 0))
	{
	    kerror(KCODEGEN, "kgen_clui_generate",
                  "WARNING!  CMS database appears to have been corrupted; cms dbm key GHOST_SRC is missing, but the %s.sh file does exist.  Regeneration of *.sh file will NOT take place. Adding GHOST_SRC cms key to database; next run of ghostwriter should be OK.", oname);
	    return(FALSE);
        }

	/*
	 *  see if *.sh file already exists.  If so, prompt to over-write,
	 *  return TRUE if the answer is NO
	 */
	if (!force_flag &&
	   koverwrite(kget_notify(), filepath) == FALSE)
	   return(TRUE);

	/*
	 *  create & open *.sh file
	 */
	if (kaccess(filepath, R_OK) != 0)
	   isnewfile = TRUE;
	if ((file = kfopen(filepath, "w"))== NULL)
	{
	    kerror(KCODEGEN, "kgen_clui_generate_cfile", 
		   "Could not create file '%s'", filepath);
	    return(FALSE);
	}

	/* start shell script */
	kfprintf(file, "#!/bin/sh\n\n");

        /*
         * next in shell script is RCS header
         */
        kgen_rcs_shhdr(file);

        /*
         * follow RCS header with copyright
         */
	copyright = kcms_get_copyright(toolbox, KCMS_TB_COPYRIGHT_LONG,
				       KCMS_LANG_SH);
        if (copyright != NULL)
            kfprintf(file, "%s\n", copyright);
        kfree(copyright);

	kfprintf(file, "# This file is automatically generated by ghostwriter.  Please\n");
	kfprintf(file, "# do not modify this file directly as your changes will be lost.\n");
	kfprintf(file, "# Also any changes that you make to this file may also mean that\n");
	kfprintf(file, "# this program will not properly work within a distributed\n");
	kfprintf(file, "# environment.\n\n\n");

	/*
	 * put in the kexec line which is the frontend for the pane object
	 */
	kfprintf(file, "exec kexec -tb %s -oname %s -args \"$*\"\n", 
	         tb_name, bname);

	/*
	 *  all done!
	 */
 	kfclose(file);
	kannounce(KCODEGEN, routine, "done generating %s.sh", oname);
	kinfo(KHOSTILE, "i don't really see why i bother generating %s.sh", 
              oname);
	return(TRUE);
}
