/*
 * Khoros: $Id$
 */
 
/*
 * $Log$
 */
 
/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */
 

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose:
   >>>>
   >>>>    Written By:
   >>>>
   >>>>          Date: 
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kcms_fileP_h_
#define _kcms_fileP_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/

#include <kutils/kobject.h>

	/*-------------------------------------*
	|       #defines
	---------------------------------------*/


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

/*
 *   Definition for file object, used by the internal CMS manipulation
 *   routines.  This structure should not be manipulated by the application
 *   programmer, but used as the "id" parameter for the public CMSL routines.
 */

struct _kobject
{
   int		type;		        /* kobject type field	*/
   int		attribute_cnt;	        /* attribute count	*/
   AttrTbl	*attributes;	        /* attribute table	*/
   int		(*add_sub_obj) PROTO((kobject, kobject));
   int		(*del_sub_obj) PROTO((kobject, kobject));
   int		(*mod_sub_obj) PROTO((kobject, kobject));
   kobject	parent;
   klist       *callbacks;

   int		ftype;		/* SRC, MAN, HELP, MANUAL, UIS, etc */
   int		subtype;	/* subtype, depending on type */
   int		generated;	/* type of file being generated */
   int		access;		/* read only or read-write */
   int		dirname;	/* $TOOLBOX/path information of file */
   int		basename;	/* filename of file (no path) */
   int		cm_name;	/* path stored in cm file */
   int		fullname;	/* cm_name with $TOOLBOX/...  */
				/* update routine for the file     */
   int		(*update_routine) PROTO((kobject, int));
   int		file_modified;	/* action to request call of update */
   int		exist;		/* does file actually exist? */
};

typedef struct _kobject *filedebug;

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

AttrTbl *kcms_fobj_attr_tbl             PROTO((void));


#endif /* _kcms_fileP_h_ */
/* Don't add after this point */
