/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            KCMS Error Handling Routines
   >>>>
   >>>>  Private:
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

	/*
	 * error status defines
	 */
int
   KCMS_OK,
   KCMS_EINTERNAL,
   KCMS_ENULLTB,
   KCMS_ENULLSW,
   KCMS_ENOTFOUND,
   KCMS_EWRONGOBJTYPE,
   KCMS_ENULLCHILD,
   KCMS_EALREADYTHERE,
   KCMS_EBADFILETYPE,
   KCMS_EINVALIDATTR,
   KCMS_ENODB,
   KCMS_NOCMFILE,
   KCMS_NOCMORIMAKE,
   KCMS_IMAKEOPENERR,
   KCMS_CMOPENERR,
   KCMS_IMAKEPARSEERR,
   KCMS_CMPARSEERR,
   KCMS_CMPANENULL,
   KCMS_NULLNAME,
   KCMS_NULLPATH,
   KCMS_NULLPARENT,
   KCMS_NULLOBJ,
   KCMS_CANNOTMALLOCOBJ,
   KCMS_OBJNOTEXIST,
   KCMS_WRONGOBJTYPE,
   KCMS_TOOLBOXUPDATEFAIL,
   KCMS_OBJALREADYEXIST,
   KCMS_ASSOCLIBNOTEXIST,
   KCMS_PERMISSION,
   KCMS_INVALIDPATH,
   KCMS_NOMETHOD,
   KCMS_INVALIDATTRIBUTE,
   KCMS_RANGEERR,
   KCMS_TOKENERR,
   KCMS_METHODERR,
   KCMS_OBJTYPEMISMATCH;

kerrlist kcms_errors[] =
{
   { &KCMS_EINTERNAL,
     "Internal Error - please report as a bug" },

   { &KCMS_ENULLTB,
     "NULL toolbox object" },

   { &KCMS_ENULLSW,
     "NULL software object" },

   { &KCMS_ENOTFOUND,
     "Specified object could not be found."},

   { &KCMS_EWRONGOBJTYPE,
     "Wrong object type for operation."},

   { &KCMS_ENULLCHILD,
     "NULL child object."},

   { &KCMS_EALREADYTHERE,
     "Object is already there."},

   { &KCMS_EBADFILETYPE,
     "Invalid file object type for operation."},

   { &KCMS_EINVALIDATTR,
     "Invalid attribute identifier."},

   { &KCMS_ENODB,
     "Could not read database (not present, or not readable)."},

   { &KCMS_CMOPENERR,
     "Unable to open the object's CM file"},

   { &KCMS_CMPANENULL,
     "Object requires a .pane file and one does not exist."},

   { &KCMS_NULLNAME, "A NULL name was specified"},

   { &KCMS_NULLPATH, "A NULL path was specified"},

   { &KCMS_NULLPARENT,
     "A NULL parent object was specified"},

   { &KCMS_NULLOBJ,
     "A NULL object was specified"},

   { &KCMS_CANNOTMALLOCOBJ,
     "A memory allocation error occured during a mallocation"},

   { &KCMS_WRONGOBJTYPE,
     "This object is not recognized by this routine"},

   { &KCMS_TOOLBOXUPDATEFAIL,
     "Unable to add new object to parent object's CM file"},

   { &KCMS_OBJALREADYEXIST,
     "This operation cannot be performed; the object already exists"},

   { &KCMS_PERMISSION,
     "Disk permissions denied access"},

   { &KCMS_INVALIDPATH,
     "Invalid source directory path"},

   { &KCMS_NOMETHOD,
     "This method does not exist for this object type"},

   { &KCMS_INVALIDATTRIBUTE,
     "This attribute does not exist for this object type"},

   { &KCMS_RANGEERR,
     "Attribute range error"},

   { &KCMS_TOKENERR,
     "Error setting/getting token value"},

   { &KCMS_METHODERR,
     "Attribute call failed"},

   { &KCMS_OBJTYPEMISMATCH,
     "The object types do not match, operation aborted"}
};

int kcms_numerrors = knumber(kcms_errors);


/*-----------------------------------------------------------
|
| Routine Name:	kcms_init_errors - initialize the kcms errno's errors
|
| Purpose:	This routine initlaizes the errno's for the kcms errors.
| Input:	
| Output:	
| Returns:	
| Written By:	Mark Young
| Date:		Nov 1, 1993
| Modifications:
|
------------------------------------------------------------*/

void
kcms_init_errors(void)
{
   KCMS_OK = 0;
   kerrno_init_errors(kcms_errors, kcms_numerrors);
}
