/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Khoros Program library object routines
   >>>>
   >>>>   Static:
   >>>>		  _kcms_cmobj_openit()
   >>>>		  _kcms_cmobj_get_path()
   >>>>		  _kcms_cmobj_get_proginfo()
   >>>>		  _kcms_cmobj_get_prog_spec()
   >>>>		  _kcms_cmobj_get_obj_attr()
   >>>>		  _kcms_cmobj_get_uisfile()
   >>>>		  _kcms_cmobj_get_headerinfo()
   >>>>		  _kcms_cmobj_get_headerlist()
   >>>>		  _kcms_cmobj_get_allsrc()
   >>>>		  _kcms_cmobj_get_allfiles()
   >>>>		  _kcms_cmobj_get_alluis()
   >>>>		  _kcms_cmobj_get_alldoc()
   >>>>		  _kcms_cmobj_get_alllist()
   >>>>		  _kcms_cmobj_get_parent()
   >>>>		  _kcms_cmobj_set_string()
   >>>>		  _kcms_cmobj_set_proginfo()
   >>>>		  _kcms_cmobj_set_ghostlibname()
   >>>>		  _kcms_cmobj_set_filename()
   >>>>		  _kcms_cmobj_set_bname()
   >>>>		  _kcms_cmobj_set_uis_file()
   >>>>  Private:
   >>>>		  kcms_cmobj_attr_tbl()
   >>>>
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include "cmobjP.h"

static kobject _kcms_sw_openit		PROTO((kobject));


/*-----------------------------------------------------------------------
|	attribute handlers for GETTING attributes
-----------------------------------------------------------------------*/
static kbool _kcms_sw_get_progspec	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_proginfo	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_obj_attr	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_headerinfo	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_headerlist	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_allsrc	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_allfiles	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_alluis	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_alldoc	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_alllist	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_allinfo	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_allconfig	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_string_attr	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_int_attr	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_ulong_attr	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_stringlist	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_assoc		PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_get_date		PROTO((kobject,int,kva_list *));


/*-----------------------------------------------------------------------
|	attribute handlers for SETTING attributes
-----------------------------------------------------------------------*/
static kbool _kcms_sw_set_proginfo	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_set_ghostlibname	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_set_filename	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_set_bname		PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_set_string_attr	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_set_int_attr	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_set_ulong_attr	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_set_stringlist	PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_set_assoc		PROTO((kobject,int,kva_list *));
static kbool _kcms_sw_set_date		PROTO((kobject,int,kva_list *));

AttrTbl cmobj_attr_tbl[] = {
{ 0,                             NULL,
				 NULL                      },

/*-- attributes common to all kcms objects ----------------------------*/

{ KCMS_NAME,		        _kcms_sw_get_string_attr,
				NULL	   },
{ KCMS_TYPE,			_kcms_sw_get_int_attr,
				NULL                       },
{ KCMS_PATH,			_kcms_sw_get_string_attr,
				NULL                       },
{ KCMS_PARENT,		        _kcms_sw_get_obj_attr,
				NULL                       },
{ KCMS_DATE,		        _kcms_sw_get_date,
				_kcms_sw_set_date          },

/*-- attributes specific to software objects --------------------------*/

{ KCMS_CMOBJ_CATEGORY,           _kcms_sw_get_string_attr,
				 _kcms_sw_set_string_attr  },
{ KCMS_CMOBJ_SUBCATEGORY,        _kcms_sw_get_string_attr,
				 _kcms_sw_set_string_attr  },
{ KCMS_CMOBJ_PROGSPEC,           _kcms_sw_get_progspec,
				 NULL                      },
{ KCMS_CMOBJ_PROG_AUTHORS,       _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAN1LONGDESC,  _kcms_sw_get_proginfo,
 				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAN1EXAMPLES,  _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAN1RESTRICT,  _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAN1REFERENCES,_kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAN1SEEALSO,   _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_USAGEADD,      _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_INCLUDEINC,    _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_INCLUDEDEF,    _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_INCLUDETYPE,   _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_INCLUDEVAR,    _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_INCLUDEMAC,    _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_INCLUDEROUT,   _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_INCLUDEADD,    _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAINVAR,       _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAINGETARGS,   _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAINBEFORELIB, _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAINLIBCALL,   _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAINAFTERLIB,  _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_FREEHANDADD,   _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_LIBSHORTDESC,  _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_LIBLONGDESC,   _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_LIBINPUT,      _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_LIBOUTPUT,     _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_LIBRETURNS,    _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_LIBRESTRICT,   _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_LIBVERIFY,     _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_LIBSIDEEFF,    _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_LIBMODS,       _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_LIBDEF,        _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_LIBCODE,       _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_LIBINCLUDES,   _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAN3SHORTDESC, _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAN3LONGDESC,  _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAN3ADDINFO,   _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAN3SEEALSO,   _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_PROG_MAN3MANUAL,    _kcms_sw_get_proginfo,
				 _kcms_sw_set_proginfo     },
{ KCMS_CMOBJ_GEN_MAIN,           _kcms_sw_get_obj_attr,
				 NULL                         },
{ KCMS_CMOBJ_GEN_INCL,           _kcms_sw_get_obj_attr,
				 NULL                         },
{ KCMS_CMOBJ_GEN_LFILE,          _kcms_sw_get_obj_attr,
				 NULL                         },
{ KCMS_CMOBJ_GEN_LIBNAME,        _kcms_sw_get_string_attr,
				 _kcms_sw_set_ghostlibname },
{ KCMS_CMOBJ_GEN_MAN1,           _kcms_sw_get_obj_attr,
				 NULL                         },
{ KCMS_CMOBJ_GEN_MAN3,           _kcms_sw_get_obj_attr,
				 NULL                         },
{ KCMS_CMOBJ_GEN_HELP,           _kcms_sw_get_obj_attr,
				 NULL                         },
{ KCMS_CMOBJ_GEN_GWFILE,         NULL,
				 NULL                         },
{ KCMS_CMOBJ_GEN_DOFILE,         NULL,
				 NULL                         },
{ KCMS_CMOBJ_GEN_SCRIPT,          _kcms_sw_get_obj_attr,
				 NULL                         },
{ KCMS_CMOBJ_UIS_PANE,           _kcms_sw_get_obj_attr,
				 NULL                         },
{ KCMS_CMOBJ_UIS_FORM,           _kcms_sw_get_obj_attr,
				 NULL                         },
{ KCMS_CMOBJ_FLAGS,              _kcms_sw_get_ulong_attr,
				 _kcms_sw_set_ulong_attr    },
{ KCMS_CMOBJ_CODETYPE,           _kcms_sw_get_int_attr,
				 _kcms_sw_set_int_attr     },
{ KCMS_CMOBJ_LEVELS,             _kcms_sw_get_int_attr,
				 _kcms_sw_set_int_attr        },
{ KCMS_CMOBJ_TYPE,               _kcms_sw_get_int_attr,
				 NULL                         },
{ KCMS_CMOBJ_LANGTYPE,           _kcms_sw_get_int_attr,
				 _kcms_sw_set_int_attr        },
{ KCMS_CMOBJ_ONAME_TKN,          _kcms_sw_get_int_attr,
				 NULL                         },
{ KCMS_CMOBJ_BNAME,              _kcms_sw_get_string_attr,
				 _kcms_sw_set_bname           },
{ KCMS_CMOBJ_TOPSRC,             _kcms_sw_get_string_attr,
				 NULL                         },
{ KCMS_CMOBJ_UPDATE_DB,          _kcms_sw_get_ulong_attr,
				 _kcms_sw_set_ulong_attr      },
{ KCMS_CMOBJ_INCANTATA,          _kcms_sw_get_int_attr,
				 _kcms_sw_set_int_attr	      },
{ KCMS_CMOBJ_FILENAME,           _kcms_sw_get_string_attr,
				 _kcms_sw_set_filename	      },
{ KCMS_CMOBJ_ROUTINENAME,        _kcms_sw_get_string_attr,
				 _kcms_sw_set_string_attr     },
{ KCMS_CMOBJ_HEADERINFO,         _kcms_sw_get_headerinfo,
				 NULL       },
{ KCMS_CMOBJ_HEADERLIST,         _kcms_sw_get_headerlist,
				 NULL                         },
{ KCMS_CMOBJ_ALL_SRC,            _kcms_sw_get_allsrc,
				 NULL                         },
{ KCMS_CMOBJ_ALL_FILES,          _kcms_sw_get_allfiles,
				 NULL                         },
{ KCMS_CMOBJ_ALL_UIS,            _kcms_sw_get_alluis,
				 NULL                         },
{ KCMS_CMOBJ_ALL_DOC,            _kcms_sw_get_alldoc,
				 NULL                         },
{ KCMS_CMOBJ_ALL_MISC,           _kcms_sw_get_alllist,
				 NULL                         },
{ KCMS_CMOBJ_ALL_C,              _kcms_sw_get_alllist,
				 NULL                         },
{ KCMS_CMOBJ_ALL_YACC,           _kcms_sw_get_alllist,
				 NULL                         },
{ KCMS_CMOBJ_ALL_LEX,            _kcms_sw_get_alllist,
				 NULL                         },
{ KCMS_CMOBJ_ALL_FORTRAN,        _kcms_sw_get_alllist,
				 NULL                         },
{ KCMS_CMOBJ_ALL_CPLUSCPLUS,     _kcms_sw_get_alllist,
				 NULL                         },
{ KCMS_CMOBJ_ALL_INCLUDE,        _kcms_sw_get_alllist,
				 NULL                         },
{ KCMS_CMOBJ_ALL_SCRIPT,         _kcms_sw_get_alllist,
				 NULL                         },
{ KCMS_CMOBJ_ALL_LIBMAN,         _kcms_sw_get_alllist,
				 NULL                         },
{ KCMS_CMOBJ_ALL_HELP,           _kcms_sw_get_alllist,
				 NULL                         },
{ KCMS_CMOBJ_ALL_CONFIG,         _kcms_sw_get_allconfig,
				 NULL                         },
{ KCMS_CMOBJ_AUTHOR_EMAIL,	_kcms_sw_get_string_attr,
				_kcms_sw_set_string_attr      },
{ KCMS_CMOBJ_AUTHOR,		_kcms_sw_get_string_attr,
				_kcms_sw_set_string_attr      },
{ KCMS_CMOBJ_APP_DEFAULTS,	_kcms_sw_get_alllist,
				NULL},
{ KCMS_CMOBJ_TODO,		_kcms_sw_get_obj_attr,
				NULL},
{ KCMS_CMOBJ_BUGS,		_kcms_sw_get_obj_attr,
				NULL},
{ KCMS_CMOBJ_DONE,		_kcms_sw_get_obj_attr,
				NULL},
{ KCMS_CMOBJ_CHANGELOG,		_kcms_sw_get_obj_attr,
				NULL},
{ KCMS_CMOBJ_ALL_INFO,		_kcms_sw_get_allinfo,
				NULL                         },
{ KCMS_CMOBJ_ICON_NAME,		_kcms_sw_get_string_attr,
				_kcms_sw_set_string_attr     },
{ KCMS_CMOBJ_SHORT_DESC,	_kcms_sw_get_string_attr,
				_kcms_sw_set_string_attr     },
{ KCMS_CMOBJ_GENERATE_EXECUTABLE,
				_kcms_sw_get_int_attr,
				_kcms_sw_set_int_attr        },
{ KCMS_CMOBJ_WORKSPACE,		_kcms_sw_get_obj_attr,
				NULL                         },
{ KCMS_CMOBJ_UIS_MISC,		_kcms_sw_get_alllist,
				NULL                         },
{ KCMS_CMOBJ_KEYWORDS,          _kcms_sw_get_stringlist,
                                _kcms_sw_set_stringlist      },
{ KCMS_CMOBJ_VERSION,           _kcms_sw_get_string_attr,
                                _kcms_sw_set_string_attr     },
{ KCMS_CMOBJ_ASSOCIATED_OBJECT, _kcms_sw_get_assoc,
                                _kcms_sw_set_assoc           }
};


/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_openit - force full open of passed object
|
| Purpose:	This function is called by attribute handlers for
|		attributes which require the object to be fully opened.
|
| Input:	cmobj	- the object to be fully opened.
| Returns:	the fully opened object, or NULL on failure.
|
| Written By:	Steven Jorgensen
| Date:		
------------------------------------------------------------*/
static kobject 
_kcms_sw_openit(
   kobject  cmobj)
{
   if (cmobj->noaccess == TRUE)
      return NULL;

   if (cmobj->fullyopen == TRUE)
      return cmobj;

   return kcms_cmobj_complete_open(cmobj);
}
 
/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_stringlist - attribute handler for strings
|
| Purpose:	This function is an attribute handler used in the attribute
|		table for attributes which are simple strings.
|
| Input:	cmobj     - software object we're getting attribute from.
|		attribute - identifier for attribute.
|		valist    - varargs list
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Neil Bowers
| Date:		20-nov-93
------------------------------------------------------------*/
static kbool
_kcms_sw_get_stringlist(
   kobject   object,
   int	     attribute,
   kva_list  *valist)
{
   klist     **ptr;
   kbool     result = TRUE;


   if (_kcms_sw_openit(object) == NULL)
      return FALSE;

   ptr = kva_arg(*valist, klist **);
   switch (attribute)
   {
      case KCMS_CMOBJ_KEYWORDS:
	 *ptr = object->keywords;
	 break;

      default:
	 kerror(KCMS,"Get String Array Attributes",
		"Illegal attribute identifier (%d)", attribute);
	 result = FALSE;
	 break;
   }

   return result;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_set_stringlist - attribute handler for string lists
|
| Purpose:	This function is an attribute handler used in the attribute
|		table for attributes which are lists of strings.
|
| Input:	cmobj      - software object we're getting attribute from.
|		attribute  - identifier for attribute.
|		valist     - varargs list
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Neil Bowers
| Date:		20-nov-93
------------------------------------------------------------*/
static kbool
_kcms_sw_set_stringlist(
   kobject   object,
   int	     attribute,
   kva_list  *valist)
{
   klist     *stringlist;
   kbool     result = TRUE;


   if (_kcms_sw_openit(object) == NULL)
      return FALSE;

   stringlist = kva_arg(*valist, klist *);
   switch (attribute)
   {
      case KCMS_CMOBJ_KEYWORDS:
	 /*UPDATE: should free the existing list, if there is one. --*/
	 object->keywords = stringlist;
	 kcms_set_attribute(object, KCMS_CMOBJ_UPDATE_DB,
			    (object->update | KCMS_UPDATE_SYNC));
	 break;

      default:
	 kerror(KCMS, "Set String Array Attributes",
		"Illegal attribute identifier (%d)", attribute);
	 result = FALSE;
	 break;
   }

   return result;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_string_attr - attribute handler for strings
|
| Purpose:	This function is an attribute handler used in the attribute
|		table for attributes which are simple strings.
|
| Input:	cmobj	  - The software object we're getting attribute from.
|		attribute - The identifier for attribute.
|		list      - varargs list
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Neil Bowers
| Date:		20-nov-93
------------------------------------------------------------*/
static kbool
_kcms_sw_get_string_attr(
   kobject   cmobj,
   int	     attribute,
   kva_list  *list)
{
   kstring  *valptr;


   if (attribute != KCMS_CMOBJ_FILENAME && attribute != KCMS_CMOBJ_ROUTINENAME
       && attribute != KCMS_CMOBJ_TOPSRC && attribute != KCMS_PATH
       && attribute != KCMS_NAME
       && _kcms_sw_openit(cmobj) == NULL)
   {
      return FALSE;
   }

   valptr = kva_arg(*list, kstring *);

   switch (attribute)
   {
      case KCMS_NAME:
	 *valptr = cmobj->oname;
	 break;

      case KCMS_CMOBJ_BNAME:
	 *valptr = (cmobj->bname != NULL ? cmobj->bname : cmobj->oname);
	 break;

      case KCMS_CMOBJ_CATEGORY:
	 *valptr = cmobj->category;
	 break;

      case KCMS_CMOBJ_SUBCATEGORY:
	 *valptr = cmobj->subcategory;
	 break;

      case KCMS_PATH:
	 *valptr = cmobj->opath;
	 break;

      case KCMS_CMOBJ_TOPSRC:
	 *valptr = cmobj->topsrc;
	 break;

      case KCMS_CMOBJ_AUTHOR:
	 *valptr = cmobj->poc_name;
	 break;

      case KCMS_CMOBJ_AUTHOR_EMAIL:
	 *valptr = cmobj->poc_email;
	 break;

      case KCMS_CMOBJ_FILENAME:
	 *valptr = cmobj->filename;
	 break;

      case KCMS_CMOBJ_ICON_NAME:
	 *valptr = cmobj->icon_name;
	 break;

      case KCMS_CMOBJ_SHORT_DESC:
	 *valptr = cmobj->short_description;
	 break;

      case KCMS_CMOBJ_GEN_LIBNAME:
	 *valptr = cmobj->library;
	 break;

      case KCMS_CMOBJ_ROUTINENAME:
	 /*-- NOTE: this attribute is stored as a token ---------------*/
	 *valptr = ktoken_to_string(cmobj->routine);
	 break;

      case KCMS_CMOBJ_VERSION:
	 *valptr = (cmobj->version != NULL
		    ? cmobj->version
		    : "2.0.1.0");
	 break;

      default:
	 kerror(KCMS,"Get String Attribute", "illegal attribute (%d) passed.",
		attribute);
	 return FALSE;
   }

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_proginfo - get the prog field from the
|		kobject structure
|
| Purpose:	This routine is a _kcms_get_attribute front end to
|		kghost_get_proginfo.
|
| Input:	list - variable list of arguments that need to be set
|		cmobj - the kobject to get the prog spec from
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Apr 24, 1993 17:26
------------------------------------------------------------*/
/* ARGSUSED */
static kbool 
_kcms_sw_get_proginfo(
   kobject    cmobj,
   int	      attr,
   kva_list  *list)
{
   char  **ptr;
   int	   info = attr - KCMS_CMOBJ_PROG_AUTHORS;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   ptr = kva_arg(*list,char **);

   if (info < 0 || info >= MAX_PROGSPEC_SIZE)
   {
      errno = KCMS_RANGEERR;
      *ptr = NULL;
      return FALSE;
   }

   if (cmobj->prog_valid != NULL && cmobj->prog_valid[info] == TRUE)
      *ptr = cmobj->prog_spec[info];
   else
      *ptr = kghost_get_progitem(cmobj,info);

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_prog_spec - get the prog specification from the
|		kobject structure
|
| Purpose:	This routine is a _kcms_sw_get_attribute front end to
|		kghost_get_progspec.
|
| Input:	list - variable list of arguments that need to be set
|		cmobj - the kobject to get the prog spec from
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Oct 31, 1992 22:33
------------------------------------------------------------*/
/* ARGSUSED */
static kbool 
_kcms_sw_get_progspec(
   kobject   cmobj,
   int	     attr,
   kva_list  *list)
{
   char   ***ptr;
#ifdef UNDEFINED
   int	  i       = 0;
   kbool  valid   = TRUE;
#endif


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   ptr = kva_arg(*list, char ***);

   *ptr = kghost_get_progspec(cmobj);

#ifdef UNDEFINED
   if (cmobj->prog_spec == NULL)
   {
      *ptr = kghost_get_progspec(cmobj);
      return TRUE;
   }
   while (valid == TRUE && i < cmobj->prog_cnt)
   {
      valid = cmobj->prog_valid[i];
      i++;
   }
   if (valid)
      *ptr = cmobj->prog_spec;
   else
      *ptr = kghost_get_progspec(cmobj);
#endif

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_obj_attr - get ghostwriter attributes
|
| Purpose:	This function is an attribute handler which is used to
|		retrieve Ghostwriter related attributes from a
|		software object.
|
| Input:	cmobj - software object
|		attr  - attribute identifier
|		list  - varargs list containing attribute arguments.
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steve Jorgensen & Neil Bowers
| Date:		29-mar-94
------------------------------------------------------------*/
static kbool 
_kcms_sw_get_obj_attr(
   kobject    cmobj,
   int        attr,
   kva_list  *list)
{
   kobject *	pObject;


   if (attr != KCMS_PARENT && _kcms_sw_openit(cmobj) == NULL)
      return FALSE;
   pObject  = kva_arg(*list,kobject *);
   *pObject = NULL;

   switch (attr)
   {
      case KCMS_CMOBJ_GEN_MAIN:
	 *pObject = cmobj->cfile;
	 break;
      case KCMS_CMOBJ_GEN_INCL:
	 *pObject = cmobj->hfile;
	 break;
      case KCMS_CMOBJ_GEN_LFILE:
	 *pObject = cmobj->lfile;
	 break;
      case KCMS_CMOBJ_GEN_MAN1:
	 *pObject = cmobj->man1file;
	 break;
      case KCMS_CMOBJ_GEN_MAN3:
	 *pObject = cmobj->man3file;
	 break;
      case KCMS_CMOBJ_GEN_HELP:
	 *pObject = cmobj->helpfile;
	 break;
      case KCMS_CMOBJ_GEN_SCRIPT:
	 *pObject = cmobj->scriptfile;
	 break;
      case KCMS_CMOBJ_UIS_PANE:
	 *pObject = cmobj->pane;
	 break;
      case KCMS_CMOBJ_UIS_FORM:
	 *pObject = cmobj->form;
	 break;
      case KCMS_CMOBJ_TODO:
	 *pObject = cmobj->todo;
	 break;
      case KCMS_CMOBJ_BUGS:
	 *pObject = cmobj->bugs;
	 break;
      case KCMS_CMOBJ_DONE:
	 *pObject = cmobj->done;
	 break;
      case KCMS_CMOBJ_CHANGELOG:
	 *pObject = cmobj->changelog;
	 break;
      case KCMS_PARENT:
	 *pObject = cmobj->parent;
	 break;
      case KCMS_CMOBJ_WORKSPACE:
	 *pObject = cmobj->workspace;
	 break;
      default:
	 errno = KCMS_RANGEERR;
	 kerror(KCMS,"_kcms_sw_get_obj_attr()",
		"called with illegal attribute value\n");
	 return FALSE;
   }

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_int_attr - get integer attribute
| Purpose:	
|
| Input:	
| Returns:	
| Written By:	Neil Bowers
| Date:		7-feb-94
------------------------------------------------------------*/
static kbool 
_kcms_sw_get_int_attr(
   kobject   cmobj,
   int	     attribute,
   kva_list  *list)
{
   kstring   routine = "Get Integer Attribute";
   int      *iptr;


   if (attribute != KCMS_CMOBJ_TYPE && attribute != KCMS_TYPE
       && attribute != KCMS_CMOBJ_ONAME_TKN
       && _kcms_sw_openit(cmobj) == NULL)
   {
      return FALSE;
   }

   /*-- get pointer to integer from variable argument list ------------*/
   iptr = kva_arg(*list, int *);

   switch (attribute)
   {
      case KCMS_TYPE:
	 *iptr = cmobj->type;
	 break;

      case KCMS_CMOBJ_LANGTYPE:
	 *iptr = cmobj->lang_type;
	 break;

      case KCMS_CMOBJ_ONAME_TKN:
	 *iptr = cmobj->oname_tkn;
	 break;

      case KCMS_CMOBJ_TYPE:
	 *iptr = cmobj->prog_type;
	 break;

      case KCMS_CMOBJ_CODETYPE:
	 *iptr = cmobj->code_type;
	 break;

      case KCMS_CMOBJ_GENERATE_EXECUTABLE:
	 if (cmobj->prog_type != KCMS_PANE)
	 {
	    kwarn(KCMS,routine,
		  "\nAttempt to get KCMS_CMOBJ_GENERATE_EXECUTABLE "
		  "attribute on `%s'.\n"
		  "This attribute only applies to pane objects.\n"
		  "%s is a %s object.",
		  cmobj->oname, cmobj->oname,
		  kcms_attr_int2string(KCMS_CMOBJ_TYPE, cmobj->prog_type));
	    return FALSE;
	 }
	 *iptr = cmobj->generate_executable;
	 break;

      case KCMS_CMOBJ_INCANTATA:
	 *iptr = cmobj->ci_installed;
	 break;

      case KCMS_CMOBJ_LEVELS:
	 /* *iptr = cmobj->levels; */
	 *iptr = 1;
	 break;

      default:
	 errno = KCMS_RANGEERR;
	 kerror(KCMS,"Get Integer Attribute",
		"called with illegal attribute value\n");
	 return FALSE;
   }

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_ulong_attr - get unsigned long attribute
| Purpose:	
| Input:	
| Output:	
| Returns:	
| Written By:	Neil Bowers
| Date:		28-mar-94
------------------------------------------------------------*/
static kbool 
_kcms_sw_get_ulong_attr(
   kobject    cmobj,
   int        attribute,
   kva_list  *list)
{
   kstring         routine = "Get unsigned long Attribute";
   unsigned long  *pul;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   pul = kva_arg(*list, unsigned long *);
   *pul = (unsigned long) 0;
   switch (attribute)
   {
      case KCMS_CMOBJ_UPDATE_DB:
	 *pul = cmobj->update;
	 break;

      case KCMS_CMOBJ_FLAGS:
	 *pul = cmobj->flags;
	 break;

      default:
	 errno = KCMS_RANGEERR;
	 kerror(KCMS, routine, "called with illegal attribute value\n");
	 return FALSE;
   }

   return TRUE;
}

/*-----------------------------------------------------------

| Routine Name:	_kcms_sw_set_ulong_attr - set unsigned long attribute
| Purpose:	This function is an set-attribute handler for attributes
|		of type \fIunsigned long\fP.
| Input:	object    - The software object to set the attribute on.
|		attribute - The identifier for the attribute to set.
|		valist    - The variable argument list containing the
|			    argument(s) of the attribute.
| Returns:	TRUE (1) if the attribute is successfully set,
|		FALSE (0) otherwise.
| Written By:	Neil Bowers
| Date:		28-mar-94
------------------------------------------------------------*/
static kbool 
_kcms_sw_set_ulong_attr(
   kobject    cmobj,
   int        attribute,
   kva_list  *valist)
{
   kstring        routine  = "Get unsigned long Attribute";
   unsigned long  ulValue;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   ulValue = kva_arg(*valist, unsigned long);
   switch (attribute)
   {
      case KCMS_CMOBJ_UPDATE_DB:
	 cmobj->update = ulValue;
	 break;

      case KCMS_CMOBJ_FLAGS:
	 cmobj->flags = ulValue;
	 break;

      default:
	 errno = KCMS_RANGEERR;
	 kerror(KCMS, routine, "called with illegal attribute value\n");
	 return FALSE;
   }

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_headerinfo - get a header information structure
|
| Purpose:	This routine calls the parsing routines that get
|		all the documentation information out of a routines
|		public header description, and fills out a
|		header_info structure.  A copy of this structure is
|		malloc'ed and returned to the user.
|
| Input:	list - the variable argument list to return info in
|		cmobj - the program cmobj to get the header from.
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Dec 08, 1992 12:04
------------------------------------------------------------*/
/* ARGSUSED */
static kbool 
_kcms_sw_get_headerinfo(
   kobject    cmobj,
   int        attr,
   kva_list  *list)
{
   header_info  **info;
   klist         *flist;
   int            token;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   info = kva_arg(*list, header_info **);
   token = (cmobj->routine == 0) ? cmobj->single : cmobj->routine;

   if (token == 0)
      flist = klist_head(cmobj->header_list);
   else
      flist = klist_locate(cmobj->header_list, (kaddr) token);
   if (cmobj->routine == 0)
      flist = klist_next(flist);
   if (flist != NULL)
      *info = (header_info *) klist_clientdata(flist);
   else if (kcms_get_header_info(cmobj) == TRUE)
      *info = (header_info *) klist_clientdata(
		   klist_locate(cmobj->header_list, (kaddr) cmobj->single));
   else
      *info = NULL;
   if ((*info) == NULL)
   {
      errno = KCMS_RANGEERR;
      return FALSE;
   }

   return TRUE;
}


/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_headerlist - get a header information list
|
| Purpose:	This routine ASSUMES that all the parsing routines that get
|		all the documentation information out of a routines
|		public header description HAVE ALREADY BEEN CALLED, and 
|		returns a pointer to the list of the header info/
|
| Input:	list - the variable argument list to return info in
|		cmobj - the program cmobj to get the header from.
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Nov 19, 1993 12:04
------------------------------------------------------------*/
/* ARGSUSED */
static kbool 
_kcms_sw_get_headerlist(
   kobject    cmobj,
   int        attr,
   kva_list  *list)
{
   klist  **info;
   int      status = TRUE;


   if (_kcms_sw_openit(cmobj) == NULL)
      status = FALSE;
   else
   {
      info = kva_arg(*list, klist **);
      *info = cmobj->header_list;
   }

   return status;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_allsrc - get a klist of all the source code
|		                      file objects for the cmobj
|
| Purpose:	This routine gets all the kobjects to the source
|		code files belonging to the program cmobj passed into
|		this routine.
|
| Input:	cmobj - the kobject to get the list of source files from
|		attr   - the attribute we're getting
|		list   - the variable argument list to return the list on
| Output:	
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		May 31, 1993 15:05
------------------------------------------------------------*/
/* ARGSUSED */
static kbool 
_kcms_sw_get_allsrc(
   kobject    cmobj,
   int        attr,
   kva_list  *list)
{
   klist  **list1;
   klist   *clist;
   int      status = TRUE;
   int      tkn;


   if (_kcms_sw_openit(cmobj) == NULL)
      status = FALSE;
   else
   {
      list1 = kva_arg(*list, klist **);

      if (cmobj->allsrc != NULL)
	 *list1 = cmobj->allsrc;
      else
      {
	 *list1 = NULL;

	 clist = klist_copy(cmobj->y_files);
	 cmobj->allsrc = klist_merge(cmobj->allsrc, clist);

	 clist = klist_copy(cmobj->l_files);
	 cmobj->allsrc = klist_merge(cmobj->allsrc, clist);

	 clist = klist_copy(cmobj->c_files);
	 cmobj->allsrc = klist_merge(cmobj->allsrc, clist);

	 clist = klist_copy(cmobj->f_files);
	 cmobj->allsrc = klist_merge(cmobj->allsrc, clist);

	 clist = klist_copy(cmobj->cplus_files);
	 cmobj->allsrc = klist_merge(cmobj->allsrc, clist);

	 clist = klist_copy(cmobj->inc_files);
	 cmobj->allsrc = klist_merge(cmobj->allsrc, clist);

	 clist = klist_copy(cmobj->script_files);
	 cmobj->allsrc = klist_merge(cmobj->allsrc, clist);

	 if (cmobj->lfile != NULL
	     && kcms_get_attribute(cmobj->lfile,KCMS_FOBJ_FULLNAME_TKN,&tkn))
	 {
	    cmobj->allsrc = klist_add(cmobj->allsrc, (kaddr)tkn,
				      (kaddr)cmobj->lfile);
	 }

	 *list1 = cmobj->allsrc;
      }
   }

   return status;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_allfiles - get a list of all files associated
|		with the cmobj
|
| Purpose:	This routine takes the information given by the
|		cmobj structure, and generate a list of files
|		that belong to the cmobj with their full
|		pathnames beginning with $TOOLBOX.
|
| Input:	list	- variable list of arguments that need to be set
|		obj	- the kobject to get the prog spec from
| Output:	
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Jan 23, 1993 20:07
------------------------------------------------------------*/
/* ARGSUSED */
static kbool 
_kcms_sw_get_allfiles(
   kobject    cmobj,
   int        attr,
   kva_list  *list)
{
   klist  **list1;
   klist   *clist;
   klist   *flist;
   int      tkn;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   list1 = kva_arg(*list, klist **);

   *list1 = NULL;

   if (cmobj->allfiles != NULL)
   {
      *list1 = cmobj->allfiles;
      return TRUE;
   }

   if (!kcms_get_attribute(cmobj, KCMS_CMOBJ_ALL_SRC, &flist))
      return FALSE;
   clist = klist_copy(flist);
   cmobj->allfiles = klist_merge(cmobj->allfiles, clist);

   if (!kcms_get_attribute(cmobj, KCMS_CMOBJ_ALL_MISC, &flist))
      return FALSE;
   clist = klist_copy(flist);
   cmobj->allfiles = klist_merge(cmobj->allfiles, clist);

   if (!kcms_get_attribute(cmobj, KCMS_CMOBJ_APP_DEFAULTS, &flist))
      return FALSE;
   clist = klist_copy(flist);
   cmobj->allfiles = klist_merge(cmobj->allfiles, clist);

   if (!kcms_get_attribute(cmobj, KCMS_CMOBJ_APP_DEFAULTS, &flist))
      return FALSE;
   clist = klist_copy(flist);
   cmobj->allfiles = klist_merge(cmobj->allfiles, clist);

   if (!kcms_get_attribute(cmobj, KCMS_CMOBJ_ALL_DOC, &flist))
      return FALSE;
   clist = klist_copy(flist);
   cmobj->allfiles = klist_merge(cmobj->allfiles, clist);

   if (!kcms_get_attribute(cmobj, KCMS_CMOBJ_ALL_UIS, &flist))
      return FALSE;
   clist = klist_copy(flist);
   cmobj->allfiles = klist_merge(cmobj->allfiles, clist);

   if (cmobj->todo)
   {
      if (kcms_get_attribute(cmobj->todo,KCMS_FOBJ_FULLNAME_TKN,&tkn))
	 cmobj->allfiles = klist_add(cmobj->allfiles, (kaddr)tkn, cmobj->todo);
   }

   if (cmobj->bugs)
   {
      if (kcms_get_attribute(cmobj->bugs, KCMS_FOBJ_FULLNAME_TKN,&tkn))
	 cmobj->allfiles = klist_add(cmobj->allfiles, (kaddr)tkn, cmobj->bugs);
   }

   if (cmobj->done)
   {
      if (kcms_get_attribute(cmobj->done,KCMS_FOBJ_FULLNAME_TKN,&tkn))
	 cmobj->allfiles = klist_add(cmobj->allfiles, (kaddr)tkn, cmobj->done);
   }

   if (cmobj->changelog)
   {
      if (kcms_get_attribute(cmobj->changelog,KCMS_FOBJ_FULLNAME_TKN, &tkn))
	 cmobj->allfiles = klist_add(cmobj->allfiles,
				     (kaddr) tkn,cmobj->changelog);
   }

   if (cmobj->workspace)
   {
      if (kcms_get_attribute(cmobj->workspace, KCMS_FOBJ_FULLNAME_TKN, &tkn))
	 cmobj->allfiles = klist_add(cmobj->allfiles,
				     (kaddr) tkn,cmobj->workspace);
   }

   if (cmobj->database != NULL && kcms_get_attribute(cmobj->database,
						     KCMS_FOBJ_FULLNAME_TKN,
						     &tkn))
      cmobj->allfiles = klist_add(cmobj->allfiles, (kaddr) tkn,
				  cmobj->database);

   if (cmobj->imakefile && kcms_get_attribute(cmobj->imakefile,
					      KCMS_FOBJ_FULLNAME_TKN,&tkn))
      cmobj->allfiles = klist_add(cmobj->allfiles, (kaddr) tkn,
				  cmobj->imakefile);
   if (cmobj->makefile && kcms_get_attribute(cmobj->makefile,
					     KCMS_FOBJ_FULLNAME_TKN,&tkn))
      cmobj->allfiles = klist_add(cmobj->allfiles, (kaddr) tkn,
				  cmobj->makefile);

   *list1 = cmobj->allfiles;

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_alluis - get pathnames for all user interface
|		files of this cmobj
|
| Purpose:	This routine gets all the pathnames to the user interface
|		files belonging to the program cmobj passed into
|		this routine.
|
|
| Input:	list - variable list of arguments that need to be set
|		obj  - the kobject to get the uis files from
|
| Output:	
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Apr 22, 1993 01:02
------------------------------------------------------------*/
/* ARGSUSED */
static kbool 
_kcms_sw_get_alluis(
   kobject    cmobj,
   int        attr,
   kva_list  *list)
{
   int      tkn;
   klist  **list1;
   klist   *clist;
   klist   *misc;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   list1 = kva_arg(*list, klist **);

   if (cmobj->alluis != NULL)
   {
      *list1 = cmobj->alluis;
      return TRUE;
   }

   *list1 = NULL;

   if (cmobj->pane != NULL && kcms_get_attribute(cmobj->pane,
						 KCMS_FOBJ_FULLNAME_TKN,&tkn))
      *list1 = klist_add(*list1, (kaddr) tkn, (kaddr) cmobj->pane);

   if (cmobj->form != NULL && kcms_get_attribute(cmobj->form,
						 KCMS_FOBJ_FULLNAME_TKN,&tkn))
      *list1 = klist_add(*list1, (kaddr) tkn, (kaddr) cmobj->form);

   if (!kcms_get_attribute(cmobj, KCMS_CMOBJ_UIS_MISC, &misc))
      return FALSE;
   clist = klist_copy(misc);
   *list1 = klist_merge(*list1, clist);

   cmobj->alluis = *list1;
   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_allinfo - get pathnames for all info files
|		of this cmobj
|
| Purpose:	This routine gets all the pathnames to the user interface
|		files belonging to the program cmobj passed into
|		this routine.
|
| Input:	list - variable list of arguments that need to be set
|		obj  - the kobject to get the uis files from
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Apr 22, 1993 01:02
------------------------------------------------------------*/
/* ARGSUSED */
static kbool 
_kcms_sw_get_allinfo(
   kobject    cmobj,
   int        attr,
   kva_list  *list)
{
   int      tkn;
   klist  **list1;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   list1 = kva_arg(*list, klist **);

   if (cmobj->allinfo != NULL)
   {
      *list1 = cmobj->allinfo;
      return TRUE;
   }

   *list1 = NULL;

   if (cmobj->todo != NULL && kcms_get_attribute(cmobj->todo,
						 KCMS_FOBJ_FULLNAME_TKN,&tkn))
      *list1 = klist_add(*list1, (kaddr) tkn, (kaddr) cmobj->todo);

   if (cmobj->bugs != NULL && kcms_get_attribute(cmobj->bugs,
						 KCMS_FOBJ_FULLNAME_TKN,&tkn))
      *list1 = klist_add(*list1, (kaddr) tkn, (kaddr) cmobj->bugs);

   if (cmobj->done != NULL && kcms_get_attribute(cmobj->done,
						 KCMS_FOBJ_FULLNAME_TKN,&tkn))
      *list1 = klist_add(*list1, (kaddr) tkn, (kaddr) cmobj->done);

   if (cmobj->changelog != NULL && kcms_get_attribute(cmobj->changelog,
						      KCMS_FOBJ_FULLNAME_TKN,
						      &tkn))
      *list1 = klist_add(*list1,(kaddr) tkn,(kaddr) cmobj->changelog);

   cmobj->allinfo = *list1;
   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_alldoc - get pathnames for all documentation
|		files for this cmobj
|
| Purpose:	This routine gets all the pathnames to the documentation
|		files belonging to the program cmobj passed into
|		this routine.
|
| Input:	list - variable list of arguments that need to be set
|		obj  - the kobject to get the doc files from
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Feb 15, 1993 13:12
------------------------------------------------------------*/
/* ARGSUSED */
static kbool 
_kcms_sw_get_alldoc(
   kobject    cmobj,
   int        attr,
   kva_list  *list)
{
   klist  **list1;
   klist   *clist;
   int      tkn;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   list1 = kva_arg(*list, klist **);

   *list1 = NULL;

   if (cmobj->alldoc != NULL)
   {
      *list1 = cmobj->alldoc;
      return TRUE;
   }

   clist = klist_copy(cmobj->help_files);
   cmobj->alldoc = klist_merge(cmobj->alldoc, clist);

   clist = klist_copy(cmobj->libman_files);
   cmobj->alldoc = klist_merge(cmobj->alldoc, clist);

   if (cmobj->man1file != NULL
       && kcms_get_attribute(cmobj->man1file, KCMS_FOBJ_FULLNAME_TKN, &tkn))
   {
      cmobj->alldoc = klist_add(cmobj->alldoc, (kaddr)tkn,
				(kaddr)cmobj->man1file);
   }

   if (cmobj->man3file != NULL && kcms_get_attribute(cmobj->man3file,
					KCMS_FOBJ_FULLNAME_TKN,&tkn))
      cmobj->alldoc = klist_add(cmobj->alldoc, (kaddr)tkn,
				(kaddr)cmobj->man3file);

   *list1 = cmobj->alldoc;
   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_allconfig - get pathnames for all config
|		files for this cmobj
|
| Purpose:	This routine gets all the pathnames to the config
|		files belonging to the program cmobj passed into
|		this routine.
|
| Input:	list - variable list of arguments that need to be set
|		obj  - the kobject to get the config files from
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Feb 15, 1993 13:12
------------------------------------------------------------*/
/* ARGSUSED */
static kbool 
_kcms_sw_get_allconfig(
   kobject    cmobj,
   int        attr,
   kva_list  *list)
{
   klist  **list1;
   klist   *clist = NULL;
   int      tkn;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   list1 = kva_arg(*list, klist **);

   *list1 = NULL;

   if (cmobj->allconfig != NULL)
   {
      *list1 = cmobj->allconfig;
      return TRUE;
   }

   if (cmobj->database != NULL && kcms_get_attribute(cmobj->database,
       KCMS_FOBJ_FULLNAME_TKN, &tkn))
      clist = klist_add(clist, (kaddr) tkn, (kaddr) cmobj->database);

   if (cmobj->imakefile != NULL && kcms_get_attribute(cmobj->imakefile,
       KCMS_FOBJ_FULLNAME_TKN, &tkn))
      clist = klist_add(clist, (kaddr) tkn,(kaddr) cmobj->imakefile);

   if (cmobj->makefile != NULL && kcms_get_attribute(cmobj->makefile,
       KCMS_FOBJ_FULLNAME_TKN, &tkn))
      clist = klist_add(clist, (kaddr) tkn, (kaddr) cmobj->makefile);

   cmobj->allconfig = clist;

   *list1 = cmobj->allconfig;
   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_alllist - get pathnames for all misc files for
|		this cmobj
|
| Purpose:	This routine gets all the pathnames to the misc
|		files belonging to the program cmobj passed into
|		this routine.
|
| Input:	list - variable list of arguments that need to be set
|		obj  - the kobject to get the misc files from
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Feb 15, 1993 13:12
------------------------------------------------------------*/
static kbool 
_kcms_sw_get_alllist(
   kobject		cmobj,
   int		attr,
   kva_list *	list)
{
   klist **	list1;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   list1 = kva_arg(*list, klist **);

   switch (attr)
   {
      case KCMS_CMOBJ_ALL_MISC:
	 *list1 = cmobj->misc_files;
	 break;

      case KCMS_CMOBJ_ALL_C:
	 *list1 = cmobj->c_files;
	 break;

      case KCMS_CMOBJ_ALL_YACC:
	 *list1 = cmobj->y_files;
	 break;

      case KCMS_CMOBJ_ALL_LEX:
	 *list1 = cmobj->l_files;
	 break;

      case KCMS_CMOBJ_ALL_FORTRAN:
	 *list1 = cmobj->f_files;
	 break;

      case KCMS_CMOBJ_ALL_CPLUSCPLUS:
	 *list1 = cmobj->cplus_files;
	 break;

      case KCMS_CMOBJ_ALL_INCLUDE:
	 *list1 = cmobj->inc_files;
	 break;

      case KCMS_CMOBJ_ALL_SCRIPT:
	 *list1 = cmobj->script_files;
	 break;

      case KCMS_CMOBJ_ALL_LIBMAN:
	 *list1 = cmobj->libman_files;
	 break;

      case KCMS_CMOBJ_ALL_HELP:
	 *list1 = cmobj->help_files;
	 break;

      case KCMS_CMOBJ_APP_DEFAULTS:
	 *list1 = cmobj->app_defaults;
	 break;

      case KCMS_CMOBJ_UIS_MISC:
	 *list1 = cmobj->miscuis;
	 break;

      default:
	 kerror(KCMS, "Get All List", "Illegal attribute id (%d).", attr);
	 return FALSE;
   }

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_set_proginfo - set the prog field in the
|		kobject structure
|
| Purpose:	This routine is a set_attribute front end to
|		kghost_set_proginfo.
|
| Input:	list - variable list of arguments that need to be set
|		cmobj - the kobject to get the prog spec from
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Apr 24, 1993 17:26
------------------------------------------------------------*/
static kbool 
_kcms_sw_set_proginfo(
   kobject    cmobj,
   int        attr,
   kva_list  *list)
{
   char  *ptr;
   int    info  = attr - KCMS_CMOBJ_PROG_AUTHORS;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   ptr = kva_arg(*list, char *);

   if (info < 0 || info >= MAX_PROGSPEC_SIZE)
   {
      ptr = NULL;
      return FALSE;
   }
   return kghost_set_progitem(cmobj,info,ptr,-1);
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_set_string_attr - set-attribute handler for string
|					   attributes
|
| Purpose:	This routine is a set_attribute front end to
|		kghost_set_proginfo.
|
| Input:	list - variable list of arguments that need to be set
|		cmobj - the kobject to get the prog spec from
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Neil Bowers
| Date:		16-nov-94
------------------------------------------------------------*/
static kbool 
_kcms_sw_set_string_attr(
   kobject    cmobj,
   int        attribute,
   kva_list  *list)
{
   kstring        newvalue;
   unsigned long  update;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   newvalue = kva_arg(*list, kstring);
   if (newvalue != NULL && attribute != KCMS_CMOBJ_ROUTINENAME)
      newvalue = kstrdup(newvalue);

   kcms_get_attribute(cmobj, KCMS_CMOBJ_UPDATE_DB, &update);
   switch (attribute)
   {
      case KCMS_CMOBJ_CATEGORY:
	 cmobj->category = newvalue;
	 break;

      case KCMS_CMOBJ_SUBCATEGORY:
	 cmobj->subcategory = newvalue;
	 break;

      case KCMS_CMOBJ_ROUTINENAME:
	 cmobj->routine = kstring_to_token(newvalue);
	 break;

      case KCMS_CMOBJ_AUTHOR_EMAIL:
	 cmobj->poc_email = newvalue;
	 break;

      case KCMS_CMOBJ_AUTHOR:
	 cmobj->poc_name = newvalue;
	 break;

      case KCMS_CMOBJ_ICON_NAME:
	 cmobj->icon_name = newvalue;
	 break;

      case KCMS_CMOBJ_SHORT_DESC:
	 cmobj->short_description = newvalue;
	 kcms_cmobj_set_pane_title(cmobj, newvalue);
	 update |= KCMS_UPDATE_REGEN_CODE;
	 break;

      case KCMS_CMOBJ_VERSION:
	 cmobj->version = newvalue;
	 break;

      default:
	 kerror(KCMS, "Set String Attribute",
		"Illegal attribute identifier (%d)", attribute);
	 return FALSE;
   }

   /*-- all attributes apart from one are stored in the database ------*/
   if (attribute != KCMS_CMOBJ_ROUTINENAME)
      update |= KCMS_UPDATE_SYNC;

   /*-- set cache update flag for those attributes in objects cache ---*/
   if (attribute != KCMS_CMOBJ_ROUTINENAME && attribute != KCMS_CMOBJ_AUTHOR
       && attribute != KCMS_CMOBJ_AUTHOR_EMAIL
       && attribute != KCMS_CMOBJ_VERSION)
      update |= KCMS_UPDATE_CACHE;

   /*-- has the update flag changed? ----------------------------------*/
   if (update != cmobj->update)
      kcms_set_attribute(cmobj, KCMS_CMOBJ_UPDATE_DB, update);

   return TRUE;
}

/* ARGSUSED */
static kbool 
_kcms_sw_set_ghostlibname(
   kobject    cmobj,
   int        attr,
   kva_list  *list)
{
   kstring   routine = "_kcms_sw_set_ghostlibname()";
   int       tkn;
   kstring   tmp1;
   kstring   tmp2;
   char      temp1[KLENGTH];
   kobject   fobj;
   kobject   lobj;
   klist    *l;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   kcms_cmobj_free_comb_lists(cmobj);

   if (cmobj->prog_type != KCMS_KROUTINE)
      return TRUE;
   tmp1 = kva_arg(*list, char *);
   if (kstrcasecmp(tmp1, cmobj->library) == 0)
      return TRUE;
   if (cmobj->lfile != NULL
       && kcms_get_attribute(cmobj->lfile, KCMS_FOBJ_FULLNAME_TKN, &tkn))
   {
      if ((lobj = kcms_open_cmobj(cmobj->parent,cmobj->library)) == NULL)
	 return FALSE;
      l = klist_locate(lobj->c_files, (kaddr) tkn);
      kfree(cmobj->library);
      cmobj->library = NULL;
      kcms_destroy(cmobj->lfile);
      if (l != NULL)
	 kcms_destroy((kobject) klist_clientdata(l));
      kcms_close(lobj);
      cmobj->lfile = NULL;
   }
   if (kstrlen(tmp1) == 0)
      return TRUE;

   if ((lobj = kcms_open_cmobj(cmobj->parent, tmp1)) == NULL)
      return FALSE;
   kcms_get_attribute(lobj, KCMS_CMOBJ_TOPSRC, &tmp2);
   ksprintf(temp1, "%s/l%s.c", tmp2, cmobj->oname);
   cmobj->library = kstrdup(tmp1);
   fobj = kcms_create_fileobj(cmobj, temp1, NULL, KCMS_FOBJ_TYPE_SRC,
			      KCMS_FOBJ_SUBTYPE_C, KCMS_FOBJ_GEN_LFILE,
			      KCMS_FOBJ_ACCESS_RDWR);
   if (fobj == NULL)
      kwarn(KCMS, routine, "Failed to create file object for file %s.\n",
	    temp1);

   fobj = kcms_create_fileobj(lobj, temp1, NULL, KCMS_FOBJ_TYPE_SRC,
			      KCMS_FOBJ_SUBTYPE_C, KCMS_FOBJ_GEN_NONE,
			      KCMS_FOBJ_ACCESS_RDWR);
   if (fobj == NULL)
      kwarn(KCMS, routine,
	    "Failed to create file object in library for file %s.\n", temp1);

   kcms_close(lobj);
   return TRUE;
}

static kbool 
_kcms_sw_set_int_attr(
   kobject    cmobj,
   int        attribute,
   kva_list  *list)
{
   kstring        routine = "Set Integer Attribute";
   int           *iptr;
   int            newvalue;
   int            lower;
   int            upper;
   unsigned long  update;


   if (!_kcms_sw_openit(cmobj))
      return FALSE;

   /*-- get new integer value from varargs list -----------------------*/
   newvalue = kva_arg(*list, int);

   kcms_get_attribute(cmobj, KCMS_CMOBJ_UPDATE_DB, &update);

   switch (attribute)
   {
      case KCMS_CMOBJ_GENERATE_EXECUTABLE:
	 if (cmobj->prog_type != KCMS_PANE)
	 {
	    kwarn(KCMS, routine,
		  "Attempt to set KCMS_CMOBJ_GENERATE_EXECUTABLE "
		  "attribute on `%s'.\n"
		  "This attribute only applies to pane objects.\n"
		  "%s is a %s object.",
		  cmobj->oname,cmobj->oname,
		  kcms_attr_int2string(KCMS_CMOBJ_TYPE, cmobj->prog_type));
	    return FALSE;
	 }
	 iptr = &cmobj->generate_executable;
	 lower = 0;
	 upper = 1;
	 update |= (KCMS_UPDATE_SYNC | KCMS_UPDATE_REGEN);
	 break;

      case KCMS_CMOBJ_INCANTATA:
	 lower = FALSE;
	 upper = TRUE;
	 iptr  = &cmobj->ci_installed;
	 update |= (KCMS_UPDATE_SYNC | KCMS_UPDATE_CACHE);
	 break;

      case KCMS_CMOBJ_LEVELS:
	 lower = 1;
	 upper = 3;
	 iptr  = &cmobj->levels;
	 update |= (KCMS_UPDATE_SYNC | KCMS_UPDATE_REGEN_CODE |
			   KCMS_UPDATE_REGEN);
	 break;

      case KCMS_CMOBJ_LANGTYPE:
	 lower = KCMS_LANG_NONE;
	 upper = KCMS_LANG_ADA;
	 iptr  = &cmobj->lang_type;
	 update |= (KCMS_UPDATE_SYNC | KCMS_UPDATE_REGEN);
	 break;

      case KCMS_CMOBJ_CODETYPE:
	 lower = KCMS_ANSI;
	 upper = KCMS_KNR;
	 iptr  = &cmobj->code_type;
	 update |= (KCMS_UPDATE_SYNC | KCMS_UPDATE_REGEN);
	 break;

      default:
	 kerror(KCMS, routine, "Illegal attribute identifier (%d)", attribute);
	 return FALSE;
   }

   /*-- lower == upper means that the attribute has no bounds ---------*/
   if (lower != upper && (newvalue < lower || newvalue > upper))
   {
      errno = KCMS_RANGEERR;
      kerror(KCMS, routine,
	     "Attempt to set attribute (%d) to invalid value (%d).",
	     attribute, newvalue);
      return FALSE;
   }
   else
   {
      *iptr = newvalue;
      if (update != cmobj->update)
	 kcms_set_attribute(cmobj, KCMS_CMOBJ_UPDATE_DB, update);
   }

   return TRUE;
}


/* ARGSUSED */
static kbool 
_kcms_sw_set_filename(
   kobject    cmobj,
   int        attr,
   kva_list  *list)
{
   char     *ptr;
   klist    *tlist;
   int	     token;
   int	     token2;
   kobject   fobj;


   ptr = kva_arg(*list, char *);
   if (ptr != NULL)
   {
      kcms_get_attribute(cmobj, KCMS_CMOBJ_ALL_SRC, &tlist);
      token = kstring_to_token(ptr);
      for (tlist = klist_head(tlist); tlist != NULL;
				      tlist = klist_next(tlist))
      {
	 fobj = (kobject) klist_clientdata(tlist);
	 kcms_get_attribute(fobj,KCMS_FOBJ_BASENAME_TKN,&token2);
	 if (token == token2)
	    break;
      }
      if (tlist == NULL)
      {
	 errno = KCMS_INVALIDPATH;
	 return FALSE;
      }
   }
   kfree(cmobj->filename);
   cmobj->filename = kstrdup(ptr);
   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_set_bname - set a new binary name for on cmobj
|
| Purpose:	This routine will change the bname variable in the
|		program structure, as well as the man1 path if
|		it was there before, and finally updates the
|		cm and Imakefile on disk.  Note: nothing happens
|		if the new binary name is the same as the old binary
|		name
|
| Input:	list   - variable list of arguments that need to be set
|		cmobj - program or library cmobj to change
| Output:	
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Jan 15, 1993 02:04
------------------------------------------------------------*/
/* ARGSUSED */
static kbool 
_kcms_sw_set_bname(
   kobject    cmobj,
   int        attr,
   kva_list  *list)
{
   kstring  ptr;
   kstring  old;
   kstring  opath;
   char     path1[KLENGTH];
   kstring  path2;
   kobject  fobj;
   int      force;
   kstring  tbname;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;

   if (!kcms_get_indirect_attribute(cmobj, KCMS_PARENT, KCMS_NAME, &tbname))
      return FALSE;

   ptr = kva_arg(*list, kstring);
   if (kstrcmp(cmobj->bname, ptr) == 0)
      return TRUE;
   old = cmobj->bname;
   cmobj->bname = kstrdup(ptr);
   (void) kcms_get_attribute(cmobj, KCMS_PATH, &opath);
   kcms_set_attribute(cmobj, KCMS_CMOBJ_UPDATE_DB,
		      (cmobj->update | KCMS_UPDATE_SYNC | KCMS_UPDATE_REGEN));

   if (cmobj->man1file != NULL)
   {
      ksprintf(path1, "%s/man/%s", opath, cmobj->bname);
      kcms_get_attribute(cmobj->man1file, KCMS_PATH, &path2);
      if (cmobj->man1file != NULL
	  && kcms_query_bit(cmobj, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE,
			    &force)
	  && (force ||
	      (kprompt(KSTANDARD, NULL, NULL, TRUE,
		       "\nOperation: change BINARY NAME of software object\n\n"
		       "\tToolbox: %s\n"
		       "\tObject:  %s\n\n"
		       "Rename old man1 page '%s' to man1 page '%s'?",
		       tbname, cmobj->oname, path2, path1) == TRUE)))
      {
	 if (!ksedfile(path2, path1, FALSE, KFILE_UPDATE, NULL,
		       old, cmobj->bname, NULL))
	 {
	    kfree(cmobj->bname);
	    cmobj->bname = old;
	    return FALSE;
	 }
      }
      fobj = cmobj->man1file;
      /*-- UPDATE: should be able to just change FULLNAME attr --*/
      if (kcms_create_fileobj(cmobj, path1, NULL, KCMS_FOBJ_TYPE_MAN,
			      KCMS_FOBJ_SUBTYPE_MAN1, KCMS_FOBJ_GEN_MAN1,
			      KCMS_FOBJ_ACCESS_RDWR) == NULL)
	 return FALSE;
      /*-- should tell 'em we didn't remove old fileobj --*/
      if (kcms_destroy(fobj) == FALSE)
	 return FALSE;
   }
   kfree(old);
   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	kcms_cmobj_attr_tbl - returns the address of the attribute
|		table.
|
| Purpose:	This routine returns the address of the attribute
|		table.  It is called by the initialize routine so
|		that it can initialized the kobject's internal
|		attribute pointer.
|
| Returns:	pointer to the start of the cmobj attribute table.
| Written By:	Steven Jorgensen
| Date:		Apr 25, 1993 13:58
------------------------------------------------------------*/
AttrTbl *
kcms_cmobj_attr_tbl(void)
{
   return cmobj_attr_tbl;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_get_assoc - get associated software object
| Purpose:	
| Input:	
| Output:	
| Returns:	
| Written By:	Neil Bowers
| Date:		6-feb-1995
------------------------------------------------------------*/
static kbool 
_kcms_sw_get_assoc(
   kobject    cmobj,
   int        attribute,
   kva_list  *list)
{
   kstring    routine = "_kcms_sw_get_assoc()";
   kstring   *pAssocTbname;
   kstring   *pAssocOname;
   kstring   *pAssocArgs;


   if (_kcms_sw_openit(cmobj) == NULL)
      return FALSE;
   if (attribute != KCMS_CMOBJ_ASSOCIATED_OBJECT)
   {
      kerror(KCMS, routine, "called with illegal attribute value (%d)\n",
	     attribute);
      return FALSE;
   }

   pAssocTbname  = kva_arg(*list, kstring *);
   pAssocOname   = kva_arg(*list, kstring *);
   pAssocArgs    = kva_arg(*list, kstring *);
   *pAssocTbname = cmobj->assoc_tbname;
   *pAssocOname  = cmobj->assoc_oname;
   *pAssocArgs   = cmobj->assoc_args;

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_sw_set_assoc - set associated software object
| Purpose:	
| Input:	
| Output:	
| Returns:	
| Written By:	Neil Bowers
| Date:		6-feb-1995
------------------------------------------------------------*/
static kbool 
_kcms_sw_set_assoc(
   kobject    object,
   int        attribute,
   kva_list  *list)
{
   kstring      routine     = "_kcms_sw_set_assoc()";
   kstring      tbname;
   kstring      oname;
   kstring      args;
   char         binpath[KLENGTH];
   kobject      pane_fobj   = NULL;
   kform       *form;
   kselection  *selection;
   kstring      filepath;
   int          force_flag  = TRUE;
   int          make_backup = FALSE;


   if (_kcms_sw_openit(object) == NULL)
      return FALSE;
   if (attribute != KCMS_CMOBJ_ASSOCIATED_OBJECT)
   {
      kerror(KCMS, routine, "called with illegal attribute value (%d)\n",
	     attribute);
      return FALSE;
   }

   if (!kcms_get_attribute(object, KCMS_CMOBJ_UIS_PANE, &pane_fobj)
       || pane_fobj == NULL
       || !kcms_get_attribute(pane_fobj, KCMS_PATH, &filepath))
      return FALSE;

   tbname               = kva_arg(*list, kstring);
   oname                = kva_arg(*list, kstring);
   args                 = kva_arg(*list, kstring);

   if ((tbname == NULL || oname == NULL)
       && (tbname != NULL || oname != NULL))
   {
      kerror(KCMS, routine,
	     "Attempt to set the ASSOCIATED_OBJECT attribute with the "
	     "%s specified, but not the %s.\n"
	     "BOTH must be specified, or neither.\n"
	     "The attribute will not be changed.\n",
	     (tbname != NULL ? "toolbox" : "software object"),
	     (tbname != NULL ? "software object" : "toolbox"));
      return TRUE;
   }

   object->assoc_tbname = kstring_upper(tbname, NULL);
   object->assoc_oname  = kstrdup(oname);
   object->assoc_args   = args != NULL ? kstrdup(args) : NULL;
   kcms_set_attribute(object, KCMS_CMOBJ_UPDATE_DB,
		      (object->update | KCMS_UPDATE_SYNC));

   if (object->assoc_tbname != NULL)
      ksprintf(binpath, "$%sBIN/%s %s",
	       object->assoc_tbname, object->assoc_oname,
	       object->assoc_args != NULL ? object->assoc_args : "");
   else
      kstrcpy(binpath, "");

   if ((form = kvf_create_form(filepath, NONE, NULL, NULL)) == NULL
       || !kvf_check_for_single_pane(form, NULL))
       return FALSE;

   selection = form->subform->guide->pane->sel_list;
   while (selection != NULL && selection->type != KUIS_ROUTINE)
	selection = selection->next;

   if (selection != NULL && selection->type == KUIS_ROUTINE)
   {
      kvf_set_attribute(selection->back_kformstruct, KVF_ROUTINE, binpath);
      kvf_print_UIS_file(form, filepath, force_flag, make_backup);
   }
   else
      kwarn(KCMS, routine, "Unable to change the -R line in the object's "
	    "pane UIS file.");

   return TRUE;
}

static kbool
_kcms_sw_set_date(
   kobject    object,
   int	      attribute,
   kva_list  *valist)
{
   kstring  string;


   if (_kcms_sw_openit(object) == NULL)
      return FALSE;

   if ((string = kva_arg(*valist, kstring)) != NULL)
   {
      object->times.creation = kstrdup(string);
      object->update |= KCMS_UPDATE_SYNC;
   }

   if ((string = kva_arg(*valist, kstring)) != NULL)
   {
      object->times.modification = kstrdup(string);
      object->update |= KCMS_UPDATE_SYNC;
   }

   if ((string = kva_arg(*valist, kstring)) != NULL)
   {
      object->times.generation = kstrdup(string);
      object->update |= KCMS_UPDATE_SYNC;
   }

   return TRUE;
}

static kbool
_kcms_sw_get_date(
   kobject    object,
   int	      attribute,
   kva_list  *valist)
{
   kstring  *string_ptr;


   if (_kcms_sw_openit(object) == NULL)
      return FALSE;

   if ((string_ptr = kva_arg(*valist, kstring *)) != NULL)
      *string_ptr = object->times.creation;

   if ((string_ptr = kva_arg(*valist, kstring *)) != NULL)
      *string_ptr = object->times.modification;

   if ((string_ptr = kva_arg(*valist, kstring *)) != NULL)
      *string_ptr = object->times.generation;

   return TRUE;
}
