/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private definitions for software object
   >>>>
   >>>>    Written By: Tom Sauer, Steve Jorgensen, Neil Bowers
   >>>>
   >>>>          Date: Oct 16, 1992 15:58
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kcms_cmobjP_h_
#define _kcms_cmobjP_h_

	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include <bootstrap.h>


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

#define CM_VERSION "1.1"

#define KCMS_CI_CAT_MASK	0x1
#define KCMS_CI_SUBCAT_MASK	0x2
#define KCMS_CI_PANE_MASK	0x4

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


/*
 * Definition for program and library objects, used by the internal 
 * CMS manipulation routines.  This structure should not be manipulated by
 * the application programmer but used as the "id" parameter for the public
 * kcms routines.
 */

struct _kobject
{
   int		  type;
   int		  attribute_cnt;
   AttrTbl       *attributes;
   int		(*add_sub_obj) PROTO((kobject, kobject));
   int		(*del_sub_obj) PROTO((kobject, kobject));
   int		(*mod_sub_obj) PROTO((kobject, kobject));
   kobject	  parent;

   klist         *callbacks;

   char		 *oname;
   int		  oname_tkn;
   char		 *bname;
   char		 *opath;
   char		 *topsrc;
   char		 *icon_name;
   kobject        database;
   kobject	  imakefile;
   kobject	  makefile;

   /*-- todo, bugs and done files, file objects --*/

   kobject	  todo;
   kobject	  bugs;
   kobject	  done;
   kobject	  changelog;

   klist         *keywords;

   unsigned long  update;
   int		  fullyopen;
   int		  ci_installed; /* installed in cantata file */
   int		  ci_init;      /* ci file initialized this value */

   int		  routine;
   char		 *filename;

   char		 *category;
   char		 *subcategory;
   char		 *short_description;

   int		  single;
   klist	 *header_list;

   unsigned long  flags;
   int		  tballoc;

   int		  levels;

   int		  code_type;

   klist	 *y_files;
   klist	 *l_files;
   klist	 *c_files;
   klist	 *f_files;
   klist	 *cplus_files;
   klist	 *inc_files;
   klist	 *script_files;
   klist	 *libman_files;
   klist	 *help_files;

   klist         *miscuis;

   klist	 *allsrc;
   klist	 *allfiles;
   klist         *alluis;
   klist	 *alldoc;
   klist	 *allinfo;
   klist	 *allconfig;
   klist	 *app_defaults;

   kobject	  pane;
   kobject	  form;

   int		  installed;

   int		  prog_cnt;
   char		**prog_spec;
   int		 *prog_valid;
   kobject	  cfile;
   kobject	  hfile;
   char		 *library;
   kobject	  lfile;
   kobject        man1file;
   kobject        man3file;
   kobject        helpfile;
   kobject	  scriptfile;

   klist         *misc_files;

   int		  prog_type;      /* kroutine, xvroutine, lib, script, etc */
   int		  lang_type;	/* fortran, perl, sh, csh, ksh, etc */

   char		 *poc_email;
   char		 *poc_name;

   int            noaccess;     /* if true, openit will NOT fully open the */
				/* object, but instead return FALSE */

   int		  generate_executable;
   kobject	  workspace;

   kstring        version;      /* object version string */

   kstring        assoc_tbname;
   kstring        assoc_oname;
   kstring        assoc_args;

   kcms_times     times;
};

typedef struct _kobject *progdebug;

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

AttrTbl *kcms_cmobj_attr_tbl   PROTO((void));

char    *kghost_get_progitem   PROTO((kobject,int));

int	 kcms_cmobj_sync       PROTO((kobject));
int	 kghost_set_progitem   PROTO((kobject,int,char *,int));
int	 update_progtype       PROTO((kobject,int));
int	 update_langtype       PROTO((kobject,int));

void	 kcms_cmobj_free       PROTO((kobject));


#endif /* _kcms_cmobjP_h_ */
/* Don't add after this point */
