 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kgenobj.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kgenobj_get_args
| 
|       Purpose: Gets command line args for kgenobj
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenobj
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgenobj_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kgenobj is out of sync with arguments specified in kgenobj's *.pane file; please rerun ghostwriter on kgenobj.";


	/*
	 * allocate the kgenobj structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "oname",
			  &(clui_info->oname_string),
			  &(clui_info->oname_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "description",
			  &(clui_info->description_string),
			  &(clui_info->description_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "temp_obj",
			  &(clui_info->temp_obj_string),
			  &(clui_info->temp_obj_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "temp_tb",
			  &(clui_info->temp_tb_string),
			  &(clui_info->temp_tb_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "bname",
			  &(clui_info->bname_string),
			  &(clui_info->bname_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "form",
			  &(clui_info->form_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "lang", KVF_TOGGLE_VAL,
			  &(clui_info->lang_toggle),
			  &(clui_info->lang_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_value(pane, "type", KVF_TOGGLE_VAL,
			  &(clui_info->type_toggle),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_flag(pane, "pane",
			  &(clui_info->pane_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "cantata",
			  &(clui_info->cantata_logic),
			  &(clui_info->cantata_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "cat",
			  &(clui_info->cat_string),
			  &(clui_info->cat_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "subcat",
			  &(clui_info->subcat_string),
			  &(clui_info->subcat_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "lib",
			  &(clui_info->lib_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "lname",
			  &(clui_info->lname_string),
			  &(clui_info->lname_flag))))
	{
	    kerror(NULL, "kgenobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



