 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kgenimake.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kgenimake_get_args
| 
|       Purpose: Gets command line args for kgenimake
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenimake
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgenimake_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kgenimake is out of sync with arguments specified in kgenimake's *.pane file; please rerun ghostwriter on kgenimake.";


	/*
	 * allocate the kgenimake structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "kgenimake_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "recreate",
			  &(clui_info->recreate_flag))))
	{
	    kerror(NULL, "kgenimake_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "oname",
			  &(clui_info->oname_string),
			  &(clui_info->oname_flag))))
	{
	    kerror(NULL, "kgenimake_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "dir",
			  &(clui_info->dir_flag))))
	{
	    kerror(NULL, "kgenimake_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "mdir",
			  &(clui_info->mdir_flag))))
	{
	    kerror(NULL, "kgenimake_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "example",
			  &(clui_info->example_flag))))
	{
	    kerror(NULL, "kgenimake_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "manual",
			  &(clui_info->manual_flag))))
	{
	    kerror(NULL, "kgenimake_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "xexample",
			  &(clui_info->xexample_flag))))
	{
	    kerror(NULL, "kgenimake_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "mindex",
			  &(clui_info->mindex_flag))))
	{
	    kerror(NULL, "kgenimake_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "testsuite",
			  &(clui_info->testsuite_flag))))
	{
	    kerror(NULL, "kgenimake_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "mglossary",
			  &(clui_info->mglossary_flag))))
	{
	    kerror(NULL, "kgenimake_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



