 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kgenimake
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kgenimake.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Create or update Imakefile according to directory contents
|
|       Purpose: main program for kgenimake
|
|         Input:
|		char *clui_info->tb_string; {Toolbox name}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		int clui_info->recreate_flag; {TRUE if -recreate specified}
|
|		Optional M.E. group:
|		    char *clui_info->oname_string; {The object name}
|		    int   clui_info->oname_flag; {TRUE if -oname specified}
|
|		    int clui_info->dir_flag; {TRUE if -dir specified}
|
|		    int clui_info->mdir_flag; {TRUE if -mdir specified}
|
|		    int clui_info->example_flag; {TRUE if -example specified}
|
|		    int clui_info->manual_flag; {TRUE if -manual specified}
|
|		    int clui_info->xexample_flag; {TRUE if -xexample specified}
|
|		    int clui_info->mindex_flag; {TRUE if -mindex specified}
|
|		    int clui_info->testsuite_flag; {TRUE if -testsuite specified}
|
|		    int clui_info->mglossary_flag; {TRUE if -mglossary specified}
|
|        Output:
|       Returns:
|
|    Written By: Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kstring  routine    = "main()";
	kstring  tbname     = NULL;
	kstring  oname      = NULL;
	kstring *poname     = NULL;
	int      type       = 0;
	int     *ptype      = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "BOOTSTRAP");
	kexit_handler(kgenimake_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "BOOTSTRAP",
			"kgenimake", kgenimake_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kgenimake_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/*-- were toolbox or object name given on the command-line? ---*/
	if (clui_info->tb_flag)
	   tbname = kstrdup(clui_info->tb_string);
	if (clui_info->oname_flag)
	   oname = kstrdup(clui_info->oname_string);


	if (clui_info->dir_flag)
	    type = KCMS_DIR;
	else if (clui_info->mdir_flag)
	    type = KCMS_MDIR;
	else if (clui_info->manual_flag)
	    type = KCMS_MANUAL;
	else if (clui_info->mindex_flag)
	    type = KCMS_MINDEX;
	else if (clui_info->mglossary_flag)
	    type = KCMS_MGLOSSARY;
	else if (clui_info->example_flag)
	    type = KCMS_EXAMPLE;
	else if (clui_info->xexample_flag)
	    type = KCMS_XEXAMPLE;
	else if (clui_info->testsuite_flag)
	    type = KCMS_TESTSUITE;
	else
	{
	   poname = &oname;
	   if (oname == NULL)
	      ptype = &type;
	}

	/*-- if not, try and parse them from an Imakefile -------------*/
	if (!kcms_get_imake_symbols(&tbname, poname, NULL, ptype))
	{
	   kerror(NULL, routine, "Could not determine toolbox and object "
		  "names, so nothing was generated\n");
	   kexit(KEXIT_FAILURE);
	}	

	if (type != KCMS_MINDEX && type != KCMS_MGLOSSARY &&
	    type != KCMS_DIR    && type != KCMS_EXAMPLE   &&
	    type != KCMS_MANUAL && type != KCMS_TESTSUITE &&
	    type != KCMS_XEXAMPLE && type != KCMS_MDIR)
	{
	   type = 0;
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	generate_imakefile(tbname, oname, type, clui_info->recreate_flag);
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kgenimake_usage_additions
| 
|       Purpose: Prints usage additions in kgenimake_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenimake
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgenimake_usage_additions(void)
{
	kfprintf(kstderr, "\tCreate or update Imakefile according to directory contents\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kgenimake_free_args
| 
|       Purpose: Frees CLUI struct allocated in kgenimake_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenimake
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kgenimake_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->oname_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
