/* $XConsortium: main.c,v 1.83 94/04/17 20:10:36 gildea Exp $ */
/*

Copyright (c) 1993, 1994  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#include "kgendepend.h"
#define MAKEDEPEND
#include "kimake.h"     /* from config sources */
#undef MAKEDEPEND

#define INCLUDEDIR "/usr/include"
char *ProgramName;

char	*directives[] = {
	"if",
	"ifdef",
	"ifndef",
	"else",
	"endif",
	"define",
	"undef",
	"include",
	"line",
	"pragma",
	"error",
	"ident",
	"sccs",
	"elif",
	"eject",
	NULL
};

struct	inclist inclist[ MAXFILES ],
		*inclistp = inclist,
		maininclist;

char	*filelist[ MAXFILES ];
char	*includedirs[ MAXDIRS + 1 ];
char	*notdotdot[ MAXDIRS ];
char	*objprefix = "";
char	*objsuffix = ".o";
char	*startat = "# DO NOT DELETE";
int	width = 78;
boolean	append = FALSE;
boolean	printed = FALSE;
boolean	verbose = FALSE;
boolean	show_where_not = FALSE;
boolean warn_multiple = FALSE;	/* Warn on multiple includes of same file */

void
process_depend(
   int	argc,
   char	**argv)
{
	register char	**fp = filelist;
	register char	**incp = includedirs;
	register char	*p;
	register struct inclist	*ip;
	char	*makefile = NULL;
	struct filepointer	*filecontent;
#if 0
	struct symtab *psymp = predefs;
#endif
	char *endmarker = NULL;
	char *defincdir = NULL;

	ProgramName = argv[0];

#if 0
	while (psymp->s_name)
	{
	    define2(psymp->s_name, psymp->s_value, &maininclist);
	    psymp++;
	}
#endif

	if (argc == 2 && argv[1][0] == '@') {
	    char *args;
	    char **nargv;
	    int nargc;
	    char quotechar = '\0';

	    nargc = 1;
	    if ((args = kreadfile(argv[1]+1, NULL)) == NULL) {
		kerror(NULL, NULL, "failed to read %s\n", argv[1]+1);
		kexit(1);
	    }
	    for (p = args; *p; p++) {
		if (quotechar) {
		    if (quotechar == '\\' ||
			(*p == quotechar && p[-1] != '\\'))
			quotechar = '\0';
		    continue;
		}
		switch (*p) {
		case '\\':
		case '"':
		case '\'':
		    quotechar = *p;
		    break;
		case ' ':
		case '\n':
		    *p = '\0';
		    if (p > args && p[-1])
			nargc++;
		    break;
		}
	    }
	    if (p[-1])
		nargc++;
	    nargv = (char **)kmalloc(nargc * sizeof(char *));
	    nargv[0] = argv[0];
	    argc = 1;
	    for (p = args; argc < nargc; p += kstrlen(p) + 1)
		if (*p) nargv[argc++] = p;
	    argv = nargv;
	}
	for(argc--, argv++; argc; argc--, argv++) {
	    	/* if looking for endmarker then check before parsing */
		if (endmarker && kstrcmp (endmarker, *argv) == 0) {
		    endmarker = NULL;
		    continue;
		}
		if (**argv != '-') {
			/* treat +thing as an option for C++ */
			if (endmarker && **argv == '+')
				continue;
			*fp++ = argv[0];
			continue;
		}
		switch(argv[0][1]) {
		case '-':
			endmarker = &argv[0][2];
			if (endmarker[0] == '\0') endmarker = "--";
			break;
		case 'D':
			if (argv[0][2] == '\0') {
				argv++;
				argc--;
			}
			for (p=argv[0] + 2; *p ; p++)
				if (*p == '=') {
					*p = ' ';
					break;
				}
			define(argv[0] + 2, &maininclist);
			break;
		case 'I':
			if (incp >= includedirs + MAXDIRS) {
			    kerror(NULL, NULL, "Too many -I flags.\n");
			    kexit(1);
			}
			*incp++ = argv[0]+2;
			if (**(incp-1) == '\0') {
				*(incp-1) = *(++argv);
				argc--;
			}
			break;
		case 'Y':
			defincdir = argv[0]+2;
			break;
		/* do not use if endmarker processing */
		case 'a':
			if (endmarker) break;
			append = TRUE;
			break;
		case 'w':
			if (endmarker) break;
			if (argv[0][2] == '\0') {
				argv++;
				argc--;
				width = atoi(argv[0]);
			} else
				width = atoi(argv[0]+2);
			break;
		case 'o':
			if (endmarker) break;
			if (argv[0][2] == '\0') {
				argv++;
				argc--;
				objsuffix = argv[0];
			} else
				objsuffix = argv[0]+2;
			break;
		case 'p':
			if (endmarker) break;
			if (argv[0][2] == '\0') {
				argv++;
				argc--;
				objprefix = argv[0];
			} else
				objprefix = argv[0]+2;
			break;
		case 'v':
			if (endmarker) break;
			verbose = TRUE;
#ifdef DEBUG
			if (argv[0][2])
				_debugmask = atoi(argv[0]+2);
#endif
			break;
		case 's':
			if (endmarker) break;
			startat = argv[0]+2;
			if (*startat == '\0') {
				startat = *(++argv);
				argc--;
			}
			if (*startat != '#') {
				kerror(NULL, NULL, "-s flag's value %s\n",
					"should start with '#'.");
				kexit(1);
			}
			break;
		case 'f':
			if (endmarker) break;
			makefile = argv[0]+2;
			if (*makefile == '\0') {
				makefile = *(++argv);
				argc--;
			}
			break;

		case 'm':
			warn_multiple = TRUE;
			break;
			
		/* Ignore -O, -g so we can just pass ${CFLAGS} to
		   makedepend
		 */
		case 'O':
		case 'g':
			break;
		default:
			if (endmarker) break;
			kinfo(KSTANDARD, "ignoring option %s\n", argv[0]);
		}
	}
	if (!defincdir) {
#ifdef PREINCDIR
	    if (incp >= includedirs + MAXDIRS) {
		kerror(NULL, NULL, "Too many -I flags.\n");
		kexit(1);
	    }
	    *incp++ = PREINCDIR;
#endif
	    if (incp >= includedirs + MAXDIRS) {
		kerror(NULL, NULL, "Too many -I flags.\n");
		kexit(1);
	    }
	    *incp++ = INCLUDEDIR;
#ifdef POSTINCDIR
	    if (incp >= includedirs + MAXDIRS) {
		kerror(NULL, NULL, "Too many -I flags.\n");
		kexit(1);
	    }
	    *incp++ = POSTINCDIR;
#endif
	} else if (*defincdir) {
	    if (incp >= includedirs + MAXDIRS) {
		kerror(NULL, NULL, "Too many -I flags.\n");
		kexit(1);
	    }
	    *incp++ = defincdir;
	}

	redirect(startat, makefile);

	/*
	 * now peruse through the list of files.
	 */
	for(fp=filelist; *fp; fp++) {
		filecontent = getfile(*fp);
		ip = newinclude(*fp, (char *)NULL);

		find_includes(filecontent, ip, ip, 0, FALSE);
		freefile(filecontent);
		recursive_pr_include(ip, ip->i_file, base_name(*fp));
		inc_clean();
	}
	if (printed)
		kprintf("\n");
	kexit(0);
}

struct filepointer *getfile(char *file)
{
	int    size;
	struct filepointer	*content;

	content = (struct filepointer *)kmalloc(sizeof(struct filepointer));
	if ((content->f_base = kreadfile(file, &size)) == NULL) {
		kerror(NULL, NULL, "failed to read %s\n", file);
		kexit(1);
	}
	content->f_len = size+1;
	content->f_p = content->f_base;
	content->f_end = content->f_base + size;
	content->f_line = 0;
	return(content);
}

void
freefile(struct filepointer *fp)
{
	kfree(fp->f_base);
	kfree(fp);
}

char *copy(register char *str)
{
	register char	*p = (char *)kmalloc((unsigned)(kstrlen(str) + 1));

	kstrcpy(p, str);
	return(p);
}

int
match(register char *str, register char **list)
{
	register int	i;

	for (i=0; *list; i++, list++)
		if (kstrcmp(str, *list) == 0)
			return(i);
	return(-1);
}

/*
 * Get the next line.  We only return lines beginning with '#' since that
 * is all this program is ever interested in.
 */
char *getline(register struct filepointer *filep)
{
	register char	*p,	/* walking pointer */
			*eof,	/* end of file pointer */
			*bol;	/* beginning of line pointer */
	register	lineno;	/* line number */

	p = filep->f_p;
	eof = filep->f_end;
	if (p >= eof)
		return((char *)NULL);
	lineno = filep->f_line;

	for(bol = p--; ++p < eof; ) {
		if (*p == '/' && *(p+1) == '*') { /* consume comments */
			*p++ = ' ', *p++ = ' ';
			while (*p) {
				if (*p == '*' && *(p+1) == '/') {
					*p++ = ' ', *p = ' ';
					break;
				}
				else if (*p == '\n')
					lineno++;
				*p++ = ' ';
			}
			continue;
		}
#ifdef WIN32
		else if (*p == '/' && *(p+1) == '/') { /* consume comments */
			*p++ = ' ', *p++ = ' ';
			while (*p && *p != '\n')
				*p++ = ' ';
			lineno++;
			continue;
		}
#endif
		else if (*p == '\\') {
			if (*(p+1) == '\n') {
				*p = ' ';
				*(p+1) = ' ';
				lineno++;
			}
		}
		else if (*p == '\n') {
			lineno++;
			if (*bol == '#') {
				register char *cp;

				*p++ = '\0';
				/* punt lines with just # (yacc generated) */
				for (cp = bol+1; 
				     *cp && (*cp == ' ' || *cp == '\t'); cp++);
				if (*cp) goto done;
			}
			bol = p+1;
		}
	}
	if (*bol != '#')
		bol = NULL;
done:
	filep->f_p = p;
	filep->f_line = lineno;
	return(bol);
}

/*
 * Strip the file name down to what we want to see in the Makefile.
 * It will have objprefix and objsuffix around it.
 */
char *base_name(register char *file)
{
	register char	*p;

	file = copy(file);
	for(p=file+kstrlen(file); p>file && *p != '.'; p--) ;

	if (*p == '.')
		*p = '\0';
	return(file);
}

void redirect(char *line, char *makefile)
{
	struct stat	st;
	kfile	*fdin, *fdout;
	char	backup[ BUFSIZ ],
		buf[ BUFSIZ ];
	boolean	found = FALSE;
	int	len;

	/*
	 * if makefile is "-" then let it pour onto kstdout.
	 */
	if (makefile && *makefile == '-' && *(makefile+1) == '\0')
		return;

	/*
	 * use a default makefile is not specified.
	 */
	if (!makefile) {
		if (stat("Makefile", &st) == 0)
			makefile = "Makefile";
		else if (stat("makefile", &st) == 0)
			makefile = "makefile";
		else {
			kerror(NULL, NULL, "[mM]akefile is not present\n");
			kexit(1);
		}
	}
	else
	    stat(makefile, &st);
	if ((fdin = kfopen(makefile, "r")) == NULL) {
		kerror(NULL, NULL, "cannot open \"%s\"\n", makefile);
	}
	ksprintf(backup, "%s.bak", makefile);
	kunlink(backup);
#ifdef WIN32
	kfclose(fdin);
#endif
	if (krename(makefile, backup) < 0) {
		kerror(NULL, NULL,"cannot rename %s to %s\n", makefile, backup);
		kexit(1);
	}
#ifdef WIN32
	if ((fdin = kfopen(backup, "r")) == NULL) {
		kerror(NULL, NULL, "cannot open \"%s\"\n", backup);
		kexit(1);
	}
#endif
	if ((fdout = kfreopen(makefile, "w", kstdout)) == NULL) {
		kerror(NULL, NULL, "cannot open \"%s\"\n", backup);
		kexit(1);
	}
	len = kstrlen(line);
	while (!found && kfgets(buf, BUFSIZ, fdin)) {
		if (*buf == '#' && kstrncmp(line, buf, len) == 0)
			found = TRUE;
		kfputs(buf, fdout);
	}
	if (!found) {
		if (verbose)
		kinfo(KSTANDARD,"Adding new delimiting line \"%s\" and dependencies...\n",
			line);
		kfprintf(fdout,"%s\n", line);
	} else if (append) {
	    while (kfgets(buf, BUFSIZ, fdin)) {
		kfputs(buf, fdout);
	    }
	}
	kfflush(fdout);
        chmod(makefile, st.st_mode);
}
