 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: This file contains the Operating System
   >>>>		       definitions.
   >>>>
   >>>>    Written By: Mark Young, John Salas, Jeremy Worley
   >>>>
   >>>>          Date: Jul 16, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _machine_kopsys_h_
#define _machine_kopsys_h_

        /*-------------------------------------*
        |       #include 
        ---------------------------------------*/


        /*-------------------------------------*
        |       #defines 
        ---------------------------------------*/

/*
 *  Defines for raw storage format of the different operating system
 *  definitions
 */
#define KOPSYS_UNKNOWN	 	 0		/* integrated	*/
#define KOPSYS_OSF	 	 1		/* ported	*/
#define KOPSYS_AIX	 	 2		/* ported	*/
#define KOPSYS_HPUX	 	 3		/* ported	*/
#define KOPSYS_SUNOS		 4		/* ported	*/
#define KOPSYS_SOLARIS		 5		/* ported	*/
#define KOPSYS_ULTRIX		 6		/* not ported	*/
#define KOPSYS_IRIX		 7		/* ported	*/
#define KOPSYS_UNICOS		 8		/* ported	*/
#define KOPSYS_DGUX		10		/* ported	*/
#define KOPSYS_BSDI		11		/* ported	*/
#define KOPSYS_LINUX		12		/* ported	*/
#define KOPSYS_386BSD		13		/* not ported	*/
#define KOPSYS_NETBSD		14		/* not ported	*/
#define KOPSYS_FREEBSD		15		/* ported	*/
#define KOPSYS_INTERACTIVE	16		/* not ported	*/
#define KOPSYS_SCO		17		/* not ported	*/
#define KOPSYS_CONVEX		18		/* not ported	*/
#define KOPSYS_APOLLO		19		/* not ported	*/
#define KOPSYS_SVR3		20		/* not ported	*/
#define KOPSYS_NEXT		21		/* not ported	*/
#define KOPSYS_AUX	 	22		/* not ported	*/
#define KOPSYS_NEWSOS		23		/* not ported	*/
#define KOPSYS_LUNA		24		/* not ported	*/
#define KOPSYS_DYNIX		25		/* ported	*/

/*
 *   Get the correct machine
 */
                     /* This one for OSF */
#if defined(__osf__) || defined(__osf) || defined(_OSF) || defined(__OSF1__)
#define KOPSYS_LOCAL KOPSYS_OSF
#endif
                     /* This one for AIX */
#if defined(__aix__) || defined(__aix) || defined(_AIX) || defined(_IBMR2)
#define KOPSYS_LOCAL KOPSYS_AIX
#endif
                     /* This one for HPUX */
#if defined(__hpux__) || defined(__hpux) || defined(_HPUX) || defined(__hp9000s800) || defined(__hp9000s700)
#define KOPSYS_LOCAL KOPSYS_HPUX
#endif
                     /* This one for SUNOS */
#if (defined(__sun__) || defined(__sun) || defined(_SUN)) && !defined(SVR4)
#define KOPSYS_LOCAL KOPSYS_SUNOS
#endif
                     /* This one for SOLARIS */
#if (defined(__sun__) || defined(__sun) || defined(_SUN)) && defined(SVR4)
#define KOPSYS_LOCAL KOPSYS_SOLARIS
#endif
                     /* This one for ULTRIX */
#if defined(__ultrix__) || defined(__ultrix) || defined(_ULTRIX)
#define KOPSYS_LOCAL KOPSYS_ULTRIX
#endif
                     /* This one for IRIX */
#if defined(__sgi__) || defined(__sgi) || defined(_SGI)
#define KOPSYS_LOCAL KOPSYS_IRIX
#endif
                     /* This one for UNICOS */
#if defined(__unicos__) || defined(__unicos) || defined(_UNICOS)
#define KOPSYS_LOCAL KOPSYS_UNICOS
#endif
                     /* This one for DGUX */
#if defined(__dgux__) || defined(__dgux) || defined(_DGUX) || defined(__DGUX__)
#define KOPSYS_LOCAL KOPSYS_DGUX
#endif
                     /* This one for BSDI */
#if defined(__bsdi__) || defined(__bsdi) || defined(_BSDI)
#define KOPSYS_LOCAL KOPSYS_BSDI
#endif
                     /* This one for LINUX */
#if defined(__linux__) || defined(__linux) || defined(_LINUX)
#define KOPSYS_LOCAL KOPSYS_LINUX
#endif
                     /* This one for 386BSD */
#if defined(__386bsd__) || defined(__386bsd) || defined(_386BSD)
#define KOPSYS_LOCAL KOPSYS_386BSD
#endif
                     /* This one for NETBSD */
#if defined(__NetBSD__)
#define KOPSYS_LOCAL KOPSYS_NETBSD
#endif
                     /* This one for FREEBSD */
#if defined(__FreeBSD__)
#define KOPSYS_LOCAL KOPSYS_FREEBSD
#endif
                     /* This one for INTERACTIVE */
#if defined(__interactive__) || defined(__interactive) || defined(_INTERACTIVE)
#define KOPSYS_LOCAL KOPSYS_INTERACTIVE
#endif
                     /* This one for SCO UNIX */
#if defined(__sco__) || defined(__sco) || defined(_SCO)
#define KOPSYS_LOCAL KOPSYS_SCO
#endif
                     /* This one for CONVEX */
#if defined(__convex__) || defined(__convex) || defined(_CONVEX)
#define KOPSYS_LOCAL KOPSYS_CONVEX
#endif
                     /* This one for APOLLO */
#if defined(__apollo__) || defined(__apollo) || defined(_APOLLO)
#define KOPSYS_LOCAL KOPSYS_APOLLO
#endif
                     /* This one for SVR3 */
#if defined(__svr3__) || defined(__svr3) || defined(_SVR3)
#define KOPSYS_LOCAL KOPSYS_SVR3
#endif
                     /* This one for NEXT */
#if defined(__next__) || defined(__next) || defined(_NEXT)
#define KOPSYS_LOCAL KOPSYS_NEXT
#endif
                     /* This one for AUX */
#if defined(__aux__) || defined(__aux) || defined(_AUX)
#define KOPSYS_LOCAL KOPSYS_AUX
#endif
                     /* This one for NEWSOS */
#if defined(__newsos__) || defined(__newsos) || defined(_NEWSOS)
#define KOPSYS_LOCAL KOPSYS_NEWSOS
#endif
                     /* This one for LUNA */
#if defined(__luna__) || defined(__luna) || defined(_LUNA)
#define KOPSYS_LOCAL KOPSYS_LUNA
#endif

		     /* This one for Sequent Dynix/Ptx */
#if defined(_SEQUENT_) 
#define KOPSYS_LOCAL KOPSYS_DYNIX
#endif

               /* unknown type */
#if !defined(KOPSYS_LOCAL)
#define KOPSYS_LOCAL KOPSYS_UNKNOWN
#endif


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/


#endif /* _machine_kopsys_h_ */
/* Don't add after this point */
