/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: This routine contains #defines for the
   >>>>                category argument of kerror
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Oct 25, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kutils_knotify_h_
#define _kutils_knotify_h_

        /*-------------------------------------*
        |       #defines 
        ---------------------------------------*/

#define KDEBUG		(1 << 0)
#define KHOSTILE        (1 << 1)
#define KSYSLIB		(1 << 2)
#define KXVLIB		(1 << 3)
#define KVERBOSE	(1 << 4)
#define KSTANDARD	(1 << 5)
#define KQUIET		(1 << 6)
#define KFORCE		(1 << 7)
#define KNOTIFYALL	(~0L)


extern int
    KMEMORY_ALLOCATION,         /* Memory Allocation Error                 */
    KNULL_PARAMETER,            /* Illegal NULL Paramete                   */
    KFILE_LIST,                 /* Illegal File List                       */
    KMISSING_INPUT,             /* Missing Input                           */
    KINVALID_DIR,               /* Invalid Directory                       */
    KINVALID_FILE,              /* Invalid File                            */
    KINVALID_FILE_DIR,          /* Invalid File or Directory               */
    KINVALID_INPUT,             /* Invalid Input                           */
    KINVALID_ALIAS,             /* Invalid Alias                           */
    KINVALID_PARAMETER,         /* Invalid Parameter                       */
    KINVALID_UISFILE,           /* Invalid UIS File                        */
    KINVALID_USER,              /* Invalid User                            */
    KINVALID_DATATYPE,          /* Invalid Data Type                       */
    KCANT_OPEN_INFILE,          /* Unable to Open Input File               */
    KCANT_OPEN_OUTFILE,         /* Unable to Open Output File              */
    KCANT_EXPAND_PATH,          /* Unable to Expand Path                   */
    KINTERNAL,                  /* Internal Error                          */
    KCALL,                      /* Invalid Call to Routine                 */
    KPARAMETERS,                /* Invalid Number of Parameters to Routine */
    KWIDGET_CREATION,           /* Widget Creation Error                   */
    KWIDGET_QUERY,              /* Unsuccessful Query of Widget            */
    KGUI_CREATION,              /* GUI Creation Error                      */
    KUIS_SYNTAX,                /* UIS Syntax Error                        */
    KUIS_LOGIC,                 /* UIS Logic Error                         */
    KNOENVIRONMENT_VAR,         /* Environment Variable Not Defined        */
    KTOOLBOX_NOEXIST,           /* Toolbox Entry is Non-Existent           */
    KTOOLBOX_CANTINIT,          /* Cannot initialize toolbox list          */
    KNUMERIC,                   /* Numeric Error                           */
    KLIMITATION,                /* Limitation                              */
    KDBM_EMPTY_DATABASE,	/* Empty Database encountered		   */
    KDBM_BLOCK_SIZE_ERROR,	/* Block Size Error in Database 	   */
    KDBM_CANT_BE_READER,	/* Reading Database Not Allowed 	   */
    KDBM_CANT_BE_WRITER,	/* Writing Database Not Allowed 	   */
    KDBM_FILE_WRITE_ERROR,	/* Failed To Write to Database  	   */
    KDBM_FILE_READ_ERROR,	/* Failed To Read from Database  	   */
    KDBM_FILE_SEEK_ERROR,	/* Failed To Seek in Database   	   */
    KDBM_BAD_MAGIC_NUMBER,	/* Bad Magic Number Found in Database  	   */
    KDBM_ITEM_NOT_FOUND,	/* Item Not Found in Database		   */
    KDBM_READER_CANT_STORE,	/* Reader Not Allowed To Store in Database */
    KDBM_ILLEGAL_DATA,		/* Illegal Data Found in Database	   */
    KDBM_CANNOT_REPLACE,	/* Cannot Replace Entry in Database	   */
    KDBM_READER_CANT_DELETE,	/* Reader Not Allowed To Delete from Database */
    KNO_KEY,                    /* Key not found                           */
    KNO_BEGIN_KEY,              /* Begin key not found                     */
    KNO_END_KEY,                /* End key not found                       */
    KDATA_ERROR,                /* Data error during parse                 */   
    KPART_KEY,                  /* Parser out of data matching the key     */   
    KPART_BEGIN_KEY,            /* Parser out of data matching the begin key*/
    KPART_END_KEY,              /* Parser out of data matching the end key */ 
    KNULL_KEY,                  /* Key is NULL                             */
    KNULL_BEGIN_KEY,            /* Begin key is NULL                       */
    KNULL_END_KEY,              /* End key is NULL                         */
    KSYNTAX_KEY,                /* Key has a syntax error                  */
    KSYNTAX_BEGIN_KEY,          /* Begin key has a syntax error            */
    KSYNTAX_END_KEY;            /* End key has a syntax error              */



        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

/*
 *  
 */
typedef int (*knotify)();

/*
 *  messages for khoros errno strings
 */
typedef struct {
        int     *kerrno;
        char    *message;
} kerrlist;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/* notify.c */
char *kvchoose	PROTO((int, char **, int, int, char *, int *, char *,kva_list));
char *kchoose	PROTO((int, char **, int, int, char *, int *, char *, kvalist));
int  kverror	 PROTO((char *, char *, char *, kva_list));
int  kerror	 PROTO((char *, char *, char *, kvalist));
int  kvwarn	 PROTO((char *, char *, char *, kva_list));
int  kwarn	 PROTO((char *, char *, char *, kvalist));
int  kvprompt	 PROTO((int, char *, char *, int, char *, kva_list));
int  kprompt	 PROTO((int, char *, char *, int, char *, kvalist));
int  koverwrite	 PROTO((int, char *));
int  kvinfo	 PROTO((int, char *, kva_list));
int  kinfo	 PROTO((int, char *, kvalist));
int  kvannounce	 PROTO((char *, char *, char *, kva_list));
int  kannounce	 PROTO((char *, char *, char *, kvalist));
int  kset_notify PROTO((int));
int  kget_notify PROTO((void));

char    *kerrno_lookup	      PROTO((int));
int	kerrno_check	      PROTO((int, kerrlist *, int));
int     kerrno_init_errors    PROTO((kerrlist *, int));
knotify kset_errorhandler     PROTO((knotify));
knotify kset_prompthandler    PROTO((knotify));
knotify kset_choosehandler    PROTO((knotify));
knotify kset_infohandler      PROTO((knotify));
knotify kset_warnhandler      PROTO((knotify));
knotify kset_announcehandler  PROTO((knotify));


#endif /* _kutils_knotify_h_ */
/* do not add after this line */
