/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Khoros Data Declarations
   >>>>
   >>>>    Written By: Jeremy Worley and Mark Young
   >>>>
   >>>>          Date: Oct 09, 1992 16:06
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _klibm_kdata_h_
#define _klibm_kdata_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 * Used for interpolating, complex conversion, and down casting
 */
#define KNONE		0

/*
 * Things associated with interpolation for kdata_manip()
 */
#define KPAD 		1
#define KZERO_ORDER	2
#define KFIRST_ORDER	3

/*
 * Things associated with down casting
 */
#define KCAST			1
#define KSCALE			2
#define KNORMALIZE		3

/*
 * Things associated with complex converting
 */
#define KREAL			1
#define KIMAGINARY		2
#define KPHASE			3
#define KMAGNITUDE		4
#define KLOGMAGP1      		5
#define KLOGMAG			6
#define KLOGMAGSQP1		7
#define KLOGMAGSQ		8
#define KMAGSQ			9


	/* 
	 * the karith2 functions are internally supported in lkarith2 
	 * for different data types according to the following table.  
	 * (asterisk - supported, dash - unsupported).
	 |                 ubyte   ulong   long    double  dcomplex
	 | KADD            *       *       *       *       *
	 | KSUB            *       *       *       *       *
         | KSUBFROM        *       *       *       *       *
         | KMULT           *       *       *       *       *
         | KDIV            *       *       *       *       *
         | KDIVINTO        *       *       *       *       *
	 |
         | KABSDIFF        *       *       *       *       -
         | KMODULO         *       *       *       *       -
         | KMINIMUM        *       *       *       *       -
         | KMAXIMUM        *       *       *       *       -
 	 |
         | KPOW            -       -       -       *       -
         | KATAN2          -       -       -       *       -
         | KHYPOT          -       -       -       *       -
         | KLDEXP          -       -       -       *       -
	 */

#define KADD     0
#define KSUB     1
#define KSUBFROM 2
#define KMULT    3
#define KDIV     4
#define KDIVINTO 5
#define KABSDIFF 6
#define KMODULO  7
#define KMINIMUM 8
#define KMAXIMUM 9
#define KPOW     10
#define KATAN2   11
#define KHYPOT   12
#define KLDEXP	 13

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* data_utils.c */
int kdata_cast      PROTO((kaddr, int, int, int, int, double, double, kaddr));
int kdata_size      PROTO((int));
int kdata_sample    PROTO((kaddr, int, int, int, int, int, double, double, double, double, kaddr));
int kdata_resample  PROTO((kaddr, int, int, int, int, int, double, double, double, double, double, kaddr));
int kdata_scale     PROTO((kaddr, int, int, double, double, double, double, kaddr));
int kdata_normalize PROTO((kaddr, int, int, double, double, kaddr));
int kdata_fill	    PROTO((kaddr, int, int, double, double));
int kdata_manip	    PROTO((kaddr, int, int, int, int, double, double, double, double, double, double, int, int, double, double, unsigned long, kaddr));
int kdatatype_cast_process	PROTO((int, int, int));
int kdatatype_cast_output	PROTO((int, int));
int kdatatype_to_define		PROTO((char *));
char *kdefine_to_datatype	PROTO((int));

void kdata_arith2_ubyte    PROTO((int, int, unsigned char *, unsigned char *,
				unsigned char *, unsigned char *));
void kdata_arith2_ulong    PROTO((int, int, unsigned long *, unsigned long *,
				unsigned char *, unsigned char *));
void kdata_arith2_long     PROTO((int, int, long *, long *, long, 
				unsigned char *, unsigned char *));
void kdata_arith2_double   PROTO((int, int, double *, double *, double, 
				unsigned char *, unsigned char *));
void kdata_arith2_dcomplex PROTO((int, int, kdcomplex *, kdcomplex *, 
				kdcomplex, unsigned char *, unsigned char *));

#endif /* _klibm_kdata_h_ */
/* Don't add after this point */
