/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose:  To provide function declarations and
   >>>>			definitions for the kutils kdbm utilities
   >>>>
   >>>>    Written By:  Mark Young & Jeremy Worley & John Salas
   >>>>
   >>>>          Date:  Dec 4, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kutils_kdbm_h_
#define _kutils_kdbm_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/


	/*-------------------------------------*
	|       #defines
	---------------------------------------*/

/*
 * flags to kdbm_store()
 */
#define KDBM_INSERT	0
#define KDBM_REPLACE	1

        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct
{
	char *dptr;	/* the data pointer		   */
	int   dsize;	/* the size of data stored in dptr */
} kdatum;

/*
 *  Declare the kdbm to be a struct _kdbm.  The declaration for
 *  this structure is actually in the file:
 *
 *              $BOOTSTRAP/objects/library/klibdb/dbm.h
 */
typedef struct _kdbm kdbm;

 
	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

kdbm   *kdbm_open        PROTO((char *, int, int));
kdbm   *kdbm_fdopen      PROTO((int, int, int));
void    kdbm_close       PROTO((kdbm *));
kdatum  kdbm_fetch       PROTO((kdbm *, kdatum));
int     kdbm_store       PROTO((kdbm *, kdatum, kdatum, int));
int     kdbm_delete      PROTO((kdbm *, kdatum));
kdatum  kdbm_firstkey    PROTO((kdbm *));
kdatum  kdbm_nextkey     PROTO((kdbm *));
int     kdbm_checkkey    PROTO((kdbm *, kdatum));
int     kdbm_read        PROTO((kdbm *, kdatum, kaddr, int, int));
int     kdbm_write       PROTO((kdbm *, kdatum, kaddr, int, int));
int     kdbm_lseek       PROTO((kdbm *, kdatum, int, int));
int     kdbm_getmachtype PROTO((kdbm *));
int	kdbm_check	 PROTO((int));

#endif /* _kutils_kdbm_h_ */
/* Don't add after this point */
