/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose:	KCMS software object public definitions
   >>>>
   >>>>    Written By:	Steve Jorgensen and Neil Bowers
   >>>>
   >>>>          Date:	23 march 1995
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kcms_cmobj_h_
#define _kcms_cmobj_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/


	/*-------------------------------------*
	|       #defines
	---------------------------------------*/

        /*
         * object program types used by the attribute KCMS_CMOBJ_PROGTYPE
         */

#define KCMS_NONE		0L
#define KCMS_KROUTINE		(1L << 0)
#define KCMS_XVROUTINE		(1L << 1)
#define KCMS_EXAMPLE		(1L << 2)
#define KCMS_XEXAMPLE		(1L << 3)
#define KCMS_TESTSUITE		(1L << 4)
#define KCMS_LIBRARY		(1L << 5)
#define KCMS_SCRIPT		(1L << 6)
#define KCMS_PANE		(1L << 7)
#define KCMS_MANUAL		(1L << 8)
#define KCMS_MINDEX		(1L << 9)
#define KCMS_MGLOSSARY		(1L << 10)
#define KCMS_DIR		(1L << 11)
#define KCMS_MDIR		(1L << 12)

#define KCMS_ALL_OBJECT_TYPES	( KCMS_KROUTINE  | KCMS_XVROUTINE | \
                                  KCMS_EXAMPLE   | KCMS_XEXAMPLE  | \
                                  KCMS_TESTSUITE | KCMS_LIBRARY   | \
                                  KCMS_SCRIPT    | KCMS_PANE      | \
                                  KCMS_MANUAL    | KCMS_MINDEX    | \
                                  KCMS_MGLOSSARY | KCMS_DIR       | \
				  KCMS_MDIR )

/*-----------------------------------------------------------------------
| bit flags for the KCMS_CMOBJ_FLAGS attribute
-----------------------------------------------------------------------*/

#define KCMS_BIT_CMOBJ_FORCE	(1L << 0)
#define KCMS_BIT_CMOBJ_GENDEBUG	(1L << 1)


/*-----------------------------------------------------------------------
|	language types used by the attribute KCMS_CMOBJ_LANGTYPE
-----------------------------------------------------------------------*/

#define KCMS_LANG_NONE		0
#define KCMS_LANG_C		1
#define KCMS_LANG_FORTRAN	2
#define KCMS_LANG_PERL		3
#define KCMS_LANG_CSH		4
#define KCMS_LANG_SH		5
#define KCMS_LANG_KSH		6
#define KCMS_LANG_CPLUSPLUS	7
#define KCMS_LANG_ADA		8

#define KCMS_LANG_ROFF		256
#define KCMS_LANG_TEX		257
#define KCMS_LANG_KHOROS_UIS	258
#define KCMS_LANG_HTML		259

#define KCMS_NOLANG		KCMS_LANG_C
#define KCMS_FORTRAN		KCMS_LANG_FORTRAN
#define KCMS_PERL		KCMS_LANG_PERL
#define KCMS_CSH		KCMS_LANG_CSH
#define KCMS_SH			KCMS_LANG_SH
#define KCMS_KSH		KCMS_LANG_KSH

        /*
         * code types used by the attribute KCMS_CMOBJ_CODETYPE
         */
#define KCMS_ANSI		1
#define KCMS_KNR		2


#define KCMS_CMOBJ_OFFSET	200
#define KCMS_CMOBJ_MAX		102

/*
 * The attribute code uses variable argument lists to allow different
 * types and amounts of information to passed to and from the kobject.
 */

/*-- common attributes -----------------------------------------------*/

#define KCMS_CMOBJ_ONAME	KCMS_NAME
				/* KCMS_TYPE is #2 */
#define KCMS_CMOBJ_OPATH	KCMS_PATH
#define KCMS_CMOBJ_PARENTOBJ	KCMS_PARENT
				/* KCMS_DATE is #5 */



/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_CATEGORY
| Type:		kstring
| Description:	This attribute holds the category string for the software
|		object.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_CATEGORY		6

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_SUBCATEGORY
| Type:		kstring
| Description:	The subcategory string associated with the software object.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_SUBCATEGORY		7

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROGSPEC
| Type:		kstring *
| Description:	An array of strings which contains details of the
|		software object.  The array should be indexed using the
|		following symbols.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROGSPEC		8

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_AUTHORS
| Type:		kstring
| Description:	The list of authors for this object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_AUTHORS		9

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAN1LONGDESC
| Type:		kstring
| Description:	The long description for the object's man page.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAN1LONGDESC	10

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAN1EXAMPLES
| Type:		kstring
| Description:	Examples from the man page.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAN1EXAMPLES	11

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAN1RESTRICT
| Type:		kstring
| Description:	The restrictions from the man page.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAN1RESTRICT	12

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAN1REFERENCES
| Type:		kstring
| Description:	The references from the man page.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAN1REFERENCES	13

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAN1SEEALSO
| Type:		kstring
| Description:	The "See Also" section from the man page.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAN1SEEALSO	14

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_USAGEADD
| Type:		kstring
| Description:	The usage additions string.  This string will appear in
|		the usage string, displayed with the -U switch.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_USAGEADD	15

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_INCLUDEINC
| Type:		kstring
| Description:	The text which goes between the include tags in the
|		object's private include file.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_INCLUDEINC	16

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_INCLUDEDEF
| Type:		kstring
| Description:	The section for preprocessor defines in the object's
|		private include file.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_INCLUDEDEF	17

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_INCLUDETYPE
| Type:		kstring
| Description:	The section for typedef statements in the object's
|		private include file.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_INCLUDETYPE	18

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_INCLUDEVAR
| Type:		kstring
| Description:	The list of global variables which are defined in the
|		object's private include file.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_INCLUDEVAR	19

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_INCLUDEMAC
| Type:		kstring
| Description:	The macro section in the object's private include file.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_INCLUDEMAC	20

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_INCLUDEROUT
| Type:		kstring
| Description:	The list of function prototypes which appear at the end
|		of the object's private include file.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_INCLUDEROUT	21

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_INCLUDEADD
| Type:		kstring
| Description:	Header additions field.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_INCLUDEADD	22

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAINVAR
| Type:		string
| Description:	The list of local variables in the main() function.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAINVAR		23

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAINGETARGS
| Type:		kstring
| Description:	The code in main() for getting the command-line arguments.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAINGETARGS	24

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAINBEFORELIB
| Type:		kstring
| Description:	The code in main() which appears before the main library
|		function call.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAINBEFORELIB	25

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAINLIBCALL
| Type:		kstring
| Description:	The code in main() for the main library call, which
|		implements the functionality of the program.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAINLIBCALL	26

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAINAFTERLIB
| Type:		kstring
| Description:	The code in main() which appears after the main
|		library function call.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAINAFTERLIB	27

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_FREEHANDADD
| Type:		kstring
| Description:	The section of code in the automatically generated exit
|               handler, where a user can add their own variables to be
|		freed on exit.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_FREEHANDADD	28

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_LIBSHORTDESC
| Type:		kstring
| Description:	The short description of the associated library function.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_LIBSHORTDESC	29

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_LIBLONGDESC
| Type:		kstring
| Description:	Long description for the library function.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_LIBLONGDESC	30

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_LIBINPUT
| Type:		kstring
| Description:	Description of the inputs to the library function.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_LIBINPUT	31

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_LIBOUTPUT
| Type:		kstring
| Description:	Details of the output arguments of the associated
|		library function.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_LIBOUTPUT	32

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_LIBRETURNS
| Type:		kstring
| Description:	Description of the return value of the associated
|		library function.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_LIBRETURNS	33

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_LIBRESTRICT
| Type:		kstring
| Description:	Restrictions in using the associated library function.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_LIBRESTRICT	34

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_LIBVERIFY
| Type:		kstring
| Description:	The Verification section from the header of the library
|		function.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_LIBVERIFY	35

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_LIBSIDEEFF
| Type:		kstring
| Description:	Any side effects of the associated library function.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_LIBSIDEEFF	36

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_LIBMODS
| Type:		kstring
| Description:	A description of any modifications made to the library
|		function since it's initial development.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_LIBMODS		37

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_LIBDEF
| Type:		kstring
| Description:	The definition of the associated library function.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_LIBDEF		38

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_LIBCODE
| Type:		kstring
| Description:	The code (function body) of the associated library function.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_LIBCODE		39

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_LIBINCLUDES
| Type:		kstring
| Description:	The list of #include statements for the associated
|		library function.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_LIBINCLUDES	40

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAN3SHORTDESC
| Type:		kstring
| Description:	The short description for the associated library function,
|		as it appears in the function's man page.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAN3SHORTDESC	41

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAN3LONGDESC
| Type:		kstring
| Description:	The long description of the associated library function,
|		taken from the function's man page.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAN3LONGDESC	42

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAN3ADDINFO
| Type:		kstring
| Description:	Additional information on the associated library function,
|		taken from the function's man page.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAN3ADDINFO	43

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAN3SEEALSO
| Type:		kstring
| Description:	The text from the "See Also" section of the man page for
|		associated library function.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAN3SEEALSO	44

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_PROG_MAN3MANUAL
| Type:		kstring
| Description:	Man3 manual reference
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_PROG_MAN3MANUAL	45

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_GEN_MAIN
| Type:		kobject
| Description:	File object for the object's main source file, <object-name>.c
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_GEN_MAIN		46

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_GEN_INCL
| Type:		kobject
| Description:	File object for the object's private include file,
|		<object-name>.h
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_GEN_INCL		47

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_GEN_LFILE
| Type:		kobject
| Description:	File object for the associated library file, l<object-name>.c
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_GEN_LFILE		48

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_GEN_LIBNAME
| Type:		kstring
| Description:	The name of the associated library, which contains the
|		library function for this object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_GEN_LIBNAME		49

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_GEN_MAN1
| Type:		kobject
| Description:	File object for the object's section 1 man page.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_GEN_MAN1		50

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_GEN_MAN3
| Type:		kobject
| Description:	File object for the object's section 3 man page.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_GEN_MAN3		51

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_GEN_HELP
| Type:		kobject
| Description:	File object for the object's help page.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_GEN_HELP		52

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_GEN_GWFILE
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all generated files.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_GEN_GWFILE		53

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_GEN_DOFILE
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all do_*.c files.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_GEN_DOFILE		54

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_GEN_SCRIPT
| Type:		kobject
| Description:	A file object for the optional script associated with
|		pane objects.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_GEN_SCRIPT		55

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_UIS_PANE
| Type:		kobject
| Description:	A file object for the pane UIS file.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_UIS_PANE		56

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_UIS_FORM
| Type:		kobject
| Description:	A file object for the form UIS file.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_UIS_FORM		57

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_FLAGS
| Type:		unsigned long
| Description:	Bit flags associated with the software object.
| Access:	read/write
| Persistence:	transient
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_FLAGS		58

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_CODETYPE
| Type:		int
| Description:	A flag which specifies whether the code is ANSI compliant
|		or not.
| Legal Values:	KCMS_ANSI
|		KCMS_KNR
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_CODETYPE		59

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_LEVELS
| Type:		int
| Description:	Extraction levels for the code generators when generating
|		code which drives the GUI.
| Legal Values:	1 - 3
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_LEVELS		60

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_TYPE
| Type:		int
| Description:	The type of software object.
| Legal Values:	KCMS_KROUTINE
|		KCMS_XVROUTINE
|		KCMS_PANE
|		KCMS_LIBRARY
|		KCMS_SCRIPT
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_TYPE			61
#define KCMS_CMOBJ_PROGTYPE		61

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_LANGTYPE
| Type:		int
| Description:	The programming language the object is written in.
| Legal-Values:	KCMS_LANG_C
|		KCMS_LANG_FORTRAN
|		KCMS_LANG_PERL
|		KCMS_LANG_SH
|		KCMS_LANG_CSH
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_LANGTYPE		62

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ONAME_TKN
| Type:		int
| Description:	The token for the name of the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ONAME_TKN		63

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_BNAME
| Type:		kstring
| Description:	The binary name of the object.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_BNAME		64

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_TOPSRC
| Type:		kstring
| Description:	The path to the objects's source directory.
|		The path is specified relative to the toolbox directory.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_TOPSRC		65

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_UPDATE_DB
| Type:		unsigned long
| Description:	A multi-bit flag, which specifies what, if any,
|		updates are needed on the software object.
| Access:	read/write
| Persistence:	transient
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_UPDATE_DB		66

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_INCANTATA
| Type:		int
| Description:	A boolean flag which specifies whether the object should
|		appear in the cantata menus.
| Legal Values:	FALSE
|		TRUE
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_INCANTATA		67
#define KCMS_CMOBJ_CI_INSTALLED		67

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_FILENAME
| Type:		kstring
| Description:	Name of file currently being search (an internal attribute).
| Access:	read/write
| Persistence:	transient
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_FILENAME		68

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ROUTINENAME
| Type:		kstring
| Description:	The name of the function which we want the header
|		information for.  This attribute must be set before getting
|		the
|		.symbol index KCMS_CMOBJ_HEADERINFO
|		attribute.
| Access:	read/write
| Persistence:	transient
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ROUTINENAME		69

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_HEADERINFO
| Type:		header_info *
| Description:	Information sucked out of the comment block header for the
|		function specified with the
|		.symbol index KCMS_CMOBJ_ROUTINENAME
|		attribute.
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_HEADERINFO		70

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_HEADERLIST
| Type:		klist *
| List Type:	header_info *
| Description:	A list of header_info structures, which contains all
|		which have been read in up to this point.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_HEADERLIST		71

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_SRC
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all source code files within
|		the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_SRC		72

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_FILES
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all files within the software
|		object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_FILES		73

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_UIS
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all UIS files within the
|		software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_UIS		74

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_DOC
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all doc files associated with
|		the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_DOC		75

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_MISC
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all miscellaneous files
|		associated with the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_MISC		76

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_C
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all C source code files
|		associate with the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_C		77

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_YACC
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all YACC source code files
|		associated with the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_YACC		78

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_LEX
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all LEX source code files
|		associated with the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_LEX		79

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_FORTRAN
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all FORTRAN source code files
|		associated with the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_FORTRAN		80

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_CPLUSCPLUS
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all C++ source code files
|		associated with the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_CPLUSCPLUS	81

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_INCLUDE
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all include files associated
|		with the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_INCLUDE		82

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_SCRIPT
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all scripts associated with
|		the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_SCRIPT		83

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_LIBMAN
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all library man pages
|		associated with the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_LIBMAN		84

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_HELP
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all online help files
|		associated with the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_HELP		85

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_CONFIG
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all configuration file objects
|		associated with the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_CONFIG		86

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_AUTHOR_EMAIL
| Type:		kstring
| Description:	A contact email address for the author of the
|		software object.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_AUTHOR_EMAIL		87

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_AUTHOR
| Type:		kstring
| Description:	The name of the author of, or contact person for,
|		the software object.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_AUTHOR		88

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_APP_DEFAULTS
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all app-defaults files
|		associated with the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_APP_DEFAULTS		89


/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_TODO
| Type:		kobject
| Description:	A file object for the object's `todo' file.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_TODO			90

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_BUGS
| Type:		kobject
| Description:	A file object for the object's `bugs' file.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_BUGS			91

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_DONE
| Type:		kobject
| Description:	A file object for the object's `bugs' file.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_DONE			92

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_CHANGELOG
| Type:		kobject
| Description:	A file object for the object's `changelog' file.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_CHANGELOG		93

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ALL_INFO
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects, for all info files associated with
|		the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ALL_INFO		94

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ICON_NAME
| Type:		kstring
| Description:	The icon name text string to be used for the object in
|		place of the object's name.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ICON_NAME		95

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_SHORT_DESC
| Type:		kstring
| Description:	The short description of the software object.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_SHORT_DESC		96

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_GENERATE_EXECUTABLE
| Type:		int
| Description:	A boolean flag which specifies whether a script object
|		should be created for the software object.
|		This attribute only applies to pane objects.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_GENERATE_EXECUTABLE	97

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_WORKSPACE
| Type:		kobject
| Description:	A file object for the workspace file which can be associated
|		with a software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_WORKSPACE		98

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_UIS_MISC
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects for all miscellaneous UIS files
|		associated with the software object.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_UIS_MISC		99

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_KEYWORDS
| Type:		klist *
| List Type:	kstring
| Description:	A list of keyword strings.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_KEYWORDS		100

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_VERSION
| Type:		kstring
| Description:	A string which holds the object version.  This should be
|		a four-tuple: <release>.<major>.<minor>.<even-more-minor>,
|		for example: 2.0.0.0
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_VERSION		101

/*------------------------------------------------------------------------
| Attribute:	KCMS_CMOBJ_ASSOCIATED_OBJECT
| Type:		kstring
|		kstring
|		kstring
| Description:	A string which holds the name of an associated software
|		object.  This only applies to pane objects, which have
|		an associated kroutine.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_CMOBJ_ASSOCIATED_OBJECT	102


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/


#endif /* _kcms_cmobj_h_ */
/* Don't add after this point */
