#include "irit_sm.h"
#include "cagd_lib.h"
#include "iritprsr.h"
#include "ip_cnvrt.h"
#include "allocate.h"

void main(int argc, char **argv)
{
    int Handler,
	FourPerFlat = TRUE, /* Settable parameters of IritSurface2Polygons. */
	FineNess = 20,
	ComputeUV = FALSE,
	Optimal = FALSE;

    if ((Handler = IritPrsrOpenDataFile("-", TRUE, TRUE)) >= 0) {
	IPObjectStruct
	    *PObj = IritPrsrGetObjects(Handler);

	/* Done with file - close it. */
	IritPrsrCloseStream(Handler, TRUE);

	/* Process the surface into polygons. */
	if (IP_IS_SRF_OBJ(PObj)) {
	    IPPolygonStruct
	        *PPoly = IritSurface2Polygons(PObj -> U.Srfs, FourPerFlat,
					      FineNess, ComputeUV, Optimal);
	    IPObjectStruct
	        *PObjPoly = GenPOLYObject(PPoly);

	    IritPrsrStdoutObject(PObjPoly);

	    IPFreeObject(PObjPoly);
	}
	else
	    fprintf(stderr, "Read object is not a surface.\n");

	IPFreeObject(PObj);
    }
    else {
	fprintf(stderr, "Failed to read from stdin\n");
	exit(1);
    }

    exit(0);
}
