/**************************************************************************
# Copyright (C) 1994 Kubota Graphics Corp.
# 
# Permission to use, copy, modify, and distribute this material for
# any purpose and without fee is hereby granted, provided that the
# above copyright notice and this permission notice appear in all
# copies, and that the name of Kubota Graphics not be used in
# advertising or publicity pertaining to this material.  Kubota
# Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
# OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
# "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
# EXPRESS OR IMPLIED.
**************************************************************************/
 

#ifndef DORE_GLBATT_H
#define DORE_GLBATT_H
 
/*****************************************************************************
**  This file contains function prototypes for Dore' global attributes.
*****************************************************************************/

#include <dore/internal/modclpvol.h>
#include <dore/internal/exeset.h>
#include <dore/internal/filters.h>


    /* Structure Types Used in Function Prototypes */

struct cammat;
struct global_depcue_data;
struct global_intermdisptype_data;
struct global_lgtatn_data;
struct global_lgtspdang_data;
struct global_lgtswi_data;
struct global_mapbmp_data;
struct global_mapdifclr_data;
struct global_mapenv_data;
struct global_maptrnint_data;
struct global_smpfilter_data;
struct global_smpsuper_data;
struct global_stereo_data;
struct global_subdivspc_data;
struct global_texextuv_data;
struct global_texextuvw_data;
struct global_texintsrf_data;
struct texmatuv;
struct texmatuvw;


    /***  Function Prototypes  ***/

void        dor_global_ambint_destroy_element (DtReal*);
DtReal*     dor_global_ambint_get_data_pointer (void);
DtFlag      dor_global_ambint_get_value (DtReal*);
void        dor_global_ambint_initialize (void);
void        dor_global_ambint_pop_group (void);
DtFlag      dor_global_ambint_pop_value (void);
void        dor_global_ambint_push_value (DtReal);
void        dor_global_ambint_set_value (DtReal);
void        dor_global_ambint_update_execute (void);
void        dor_global_ambswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_ambswi_get_data_pointer (void);
DtFlag      dor_global_ambswi_get_value (DtSwitch*);
void        dor_global_ambswi_initialize (void);
void        dor_global_ambswi_pop_group (void);
DtFlag      dor_global_ambswi_pop_value (void);
void        dor_global_ambswi_push_value (DtSwitch);
void        dor_global_ambswi_set_value (DtSwitch);
void        dor_global_ambswi_update_execute (void);
void        dor_global_bacfacculble_destroy_element (DtSwitch*);
DtSwitch*   dor_global_bacfacculble_get_data_pointer (void);
DtFlag      dor_global_bacfacculble_get_value (DtSwitch*);
void        dor_global_bacfacculble_initialize (void);
void        dor_global_bacfacculble_pop_group (void);
DtFlag      dor_global_bacfacculble_pop_value (void);
void        dor_global_bacfacculble_push_value (DtSwitch);
void        dor_global_bacfacculble_set_value (DtSwitch);
void        dor_global_bacfacculble_update_execute (void);
void        dor_global_bacfacculswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_bacfacculswi_get_data_pointer (void);
DtFlag      dor_global_bacfacculswi_get_value (DtSwitch*);
void        dor_global_bacfacculswi_initialize (void);
void        dor_global_bacfacculswi_pop_group (void);
DtFlag      dor_global_bacfacculswi_pop_value (void);
void        dor_global_bacfacculswi_push_value (DtSwitch);
void        dor_global_bacfacculswi_set_value (DtSwitch);
void        dor_global_bacfacculswi_update_execute (void);
void        dor_global_bndvolswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_bndvolswi_get_data_pointer (void);
DtFlag      dor_global_bndvolswi_get_value (DtSwitch*);
void        dor_global_bndvolswi_initialize (void);
void        dor_global_bndvolswi_pop_group (void);
DtFlag      dor_global_bndvolswi_pop_value (void);
void        dor_global_bndvolswi_push_value (DtSwitch);
void        dor_global_bndvolswi_set_value (DtSwitch);
void        dor_global_bndvolswi_update_execute (void);
void        dor_global_cammat_destroy_element (struct cammat*);
struct cammat*
            dor_global_cammat_get_data_pointer (void);
DtFlag      dor_global_cammat_get_value (DtCameraMatrixType* , DtMatrix4x4);
void        dor_global_cammat_initialize (void);
void        dor_global_cammat_pop_group (void);
DtFlag      dor_global_cammat_pop_value (void);
void        dor_global_cammat_print_value (void);
void        dor_global_cammat_push_value (DtCameraMatrixType, DtMatrix4x4);
void        dor_global_cammat_set_value (DtCameraMatrixType, DtMatrix4x4);
void        dor_global_cammat_update_execute (void);
void        dor_global_clpswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_clpswi_get_data_pointer (void);
DtFlag      dor_global_clpswi_get_value (DtSwitch*);
void        dor_global_clpswi_initialize (void);
void        dor_global_clpswi_pop_group (void);
DtFlag      dor_global_clpswi_pop_value (void);
void        dor_global_clpswi_push_value (DtSwitch);
void        dor_global_clpswi_set_value (DtSwitch);
void        dor_global_clpswi_update_execute (void);
void        dor_global_clpvol_apply_volume (DtClipOperator,DtInt,DtHalfSpace*);
void        dor_global_clpvol_destroy_element (dot_modclpvol*);
dot_modclpvol*
            dor_global_clpvol_get_data_pointer (void);
DtFlag      dor_global_clpvol_get_value (DtInt*,DtPoint3*,DtVector3*,DtPoint4*);
void        dor_global_clpvol_initialize (void);
void        dor_global_clpvol_notify_change (void);
void        dor_global_clpvol_pop_group (void);
DtFlag      dor_global_clpvol_pop_value (void);
void        dor_global_clpvol_push_apply_volume (
		DtClipOperator, DtInt, DtHalfSpace*);
void        dor_global_clpvol_push_value (DtClipOperator, DtInt, DtHalfSpace*);
void        dor_global_clpvol_set_value (DtClipOperator, DtInt, DtHalfSpace*);
void        dor_global_clpvol_update_execute (DtGlobalCall, DtInt);
void        dor_global_cmptexuvcbk_destroy_element (DtObject*);
DtObject*   dor_global_cmptexuvcbk_get_data_pointer (void);
DtFlag      dor_global_cmptexuvcbk_get_value (DtObject*);
void        dor_global_cmptexuvcbk_initialize (void);
void        dor_global_cmptexuvcbk_pop_group (void);
DtFlag      dor_global_cmptexuvcbk_pop_value (void);
void        dor_global_cmptexuvcbk_push_value (DtObject);
void        dor_global_cmptexuvcbk_set_value (DtObject);
void        dor_global_cmptexuvcbk_update_execute (void);
void        dor_global_cmptexuvswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_cmptexuvswi_get_data_pointer (void);
DtFlag      dor_global_cmptexuvswi_get_value (DtSwitch*);
void        dor_global_cmptexuvswi_initialize (void);
void        dor_global_cmptexuvswi_pop_group (void);
DtFlag      dor_global_cmptexuvswi_pop_value (void);
void        dor_global_cmptexuvswi_push_value (DtSwitch);
void        dor_global_cmptexuvswi_set_value (DtSwitch);
void        dor_global_cmptexuvswi_update_execute (void);
void        dor_global_cmptexuvwcbk_destroy_element (DtObject*);
DtObject*   dor_global_cmptexuvwcbk_get_data_pointer (void);
DtFlag      dor_global_cmptexuvwcbk_get_value (DtObject*);
void        dor_global_cmptexuvwcbk_initialize (void);
void        dor_global_cmptexuvwcbk_pop_group (void);
DtFlag      dor_global_cmptexuvwcbk_pop_value (void);
void        dor_global_cmptexuvwcbk_push_value (DtObject);
void        dor_global_cmptexuvwcbk_set_value (DtObject);
void        dor_global_cmptexuvwcbk_update_execute (void);
void        dor_global_cmptexuvwswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_cmptexuvwswi_get_data_pointer (void);
DtFlag      dor_global_cmptexuvwswi_get_value (DtSwitch*);
void        dor_global_cmptexuvwswi_initialize (void);
void        dor_global_cmptexuvwswi_pop_group (void);
DtFlag      dor_global_cmptexuvwswi_pop_value (void);
void        dor_global_cmptexuvwswi_push_value (DtSwitch);
void        dor_global_cmptexuvwswi_set_value (DtSwitch);
void        dor_global_cmptexuvwswi_update_execute (void);
void        dor_global_depcue_destroy_element (struct global_depcue_data*);
struct global_depcue_data*
            dor_global_depcue_get_data_pointer (void);
DtFlag      dor_global_depcue_get_value
                (DtReal*, DtReal*, DtReal*, DtReal*, DtColorModel*, DtReal[3]);
void        dor_global_depcue_initialize (void);
void        dor_global_depcue_pop_group (void);
DtFlag      dor_global_depcue_pop_value (void);
void        dor_global_depcue_push_value
                (DtReal, DtReal, DtReal, DtReal, DtColorModel, DtReal[]);
void        dor_global_depcue_set_value
                (DtReal, DtReal, DtReal, DtReal, DtColorModel, DtReal[]);
void        dor_global_depcue_update_execute (void);
void        dor_global_depcueswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_depcueswi_get_data_pointer (void);
DtFlag      dor_global_depcueswi_get_value (DtSwitch*);
void        dor_global_depcueswi_initialize (void);
void        dor_global_depcueswi_pop_group (void);
DtFlag      dor_global_depcueswi_pop_value (void);
void        dor_global_depcueswi_push_value (DtSwitch);
void        dor_global_depcueswi_set_value (DtSwitch);
void        dor_global_depcueswi_update_execute (void);
void        dor_global_difclr_destroy_element (DtColorRGB*);
DtColorRGB* dor_global_difclr_get_data_pointer (void);
DtFlag      dor_global_difclr_get_value (DtColorModel* , DtReal[3]);
void        dor_global_difclr_initialize (void);
void        dor_global_difclr_pop_group (void);
DtFlag      dor_global_difclr_pop_value (void);
void        dor_global_difclr_push_value (DtColorRGB);
void        dor_global_difclr_set_value (DtColorRGB);
void        dor_global_difclr_update_execute (void);
void        dor_global_difint_destroy_element (DtReal*);
DtReal*     dor_global_difint_get_data_pointer (void);
DtFlag      dor_global_difint_get_value (DtReal*);
void        dor_global_difint_initialize (void);
void        dor_global_difint_pop_group (void);
DtFlag      dor_global_difint_pop_value (void);
void        dor_global_difint_push_value (DtReal);
void        dor_global_difint_set_value (DtReal);
void        dor_global_difint_update_execute (void);
void        dor_global_difswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_difswi_get_data_pointer (void);
DtFlag      dor_global_difswi_get_value (DtSwitch*);
void        dor_global_difswi_initialize (void);
void        dor_global_difswi_pop_group (void);
DtFlag      dor_global_difswi_pop_value (void);
void        dor_global_difswi_push_value (DtSwitch);
void        dor_global_difswi_set_value (DtSwitch);
void        dor_global_difswi_update_execute (void);
void        dor_global_emisclr_destroy_element (DtColorRGB*);
DtColorRGB* dor_global_emisclr_get_data_pointer (void);
DtFlag      dor_global_emisclr_get_value (DtColorModel* , DtReal[3]);
void        dor_global_emisclr_initialize (void);
void        dor_global_emisclr_pop_group (void);
DtFlag      dor_global_emisclr_pop_value (void);
void        dor_global_emisclr_push_value (DtColorRGB);
void        dor_global_emisclr_set_value (DtColorRGB);
void        dor_global_emisclr_update_execute (void);
void        dor_global_emisfct_destroy_element (DtReal*);
DtReal*     dor_global_emisfct_get_data_pointer (void);
DtFlag      dor_global_emisfct_get_value (DtReal*);
void        dor_global_emisfct_initialize (void);
void        dor_global_emisfct_pop_group (void);
DtFlag      dor_global_emisfct_pop_value (void);
void        dor_global_emisfct_push_value (DtReal);
void        dor_global_emisfct_set_value (DtReal);
void        dor_global_emisfct_update_execute (void);
void        dor_global_emisswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_emisswi_get_data_pointer (void);
DtFlag      dor_global_emisswi_get_value (DtSwitch*);
void        dor_global_emisswi_initialize (void);
void        dor_global_emisswi_pop_group (void);
DtFlag      dor_global_emisswi_pop_value (void);
void        dor_global_emisswi_push_value (DtSwitch);
void        dor_global_emisswi_set_value (DtSwitch);
void        dor_global_emisswi_update_execute (void);
void        dor_global_exeset_destroy_element (dot_exeset*);
dot_exeset* dor_global_exeset_get_data_pointer (void);
DtFlag      dor_global_exeset_get_value (dot_exeset*);
void        dor_global_exeset_initialize (void);
void        dor_global_exeset_obj_types_report (DtInt);
void        dor_global_exeset_pop_group (void);
DtFlag      dor_global_exeset_pop_value (void);
dot_exeset* dor_global_exeset_push_value (dot_exeset*);
void        dor_global_exeset_set_value (dot_exeset*);
void        dor_global_exeset_update_execute (void);
void        dor_global_fil_destroy_element (dot_filters);
DtPtr       dor_global_fil_get_data_pointer (void);
DtFlag      dor_global_fil_get_value (dot_filters);
void        dor_global_fil_initialize (void);
void        dor_global_fil_pop_group (void);
DtFlag      dor_global_fil_pop_value (void);
void        dor_global_fil_push_value (dot_filters);
void        dor_global_fil_set_value (DtFilter, dot_bitfield);
void        dor_global_fil_update_execute (void);
void        dor_global_glbrndmaxobjs_destroy_element (DtInt*);
DtInt*      dor_global_glbrndmaxobjs_get_data_pointer (void);
DtFlag      dor_global_glbrndmaxobjs_get_value (DtInt*);
void        dor_global_glbrndmaxobjs_initialize (void);
void        dor_global_glbrndmaxobjs_pop_group (void);
DtFlag      dor_global_glbrndmaxobjs_pop_value (void);
void        dor_global_glbrndmaxobjs_push_value (DtInt);
void        dor_global_glbrndmaxobjs_set_value (DtInt);
void        dor_global_glbrndmaxobjs_update_execute (void);
void        dor_global_glbrndmaxsub_destroy_element (DtInt*);
DtInt*      dor_global_glbrndmaxsub_get_data_pointer (void);
DtFlag      dor_global_glbrndmaxsub_get_value (DtInt*);
void        dor_global_glbrndmaxsub_initialize (void);
void        dor_global_glbrndmaxsub_pop_group (void);
DtFlag      dor_global_glbrndmaxsub_pop_value (void);
void        dor_global_glbrndmaxsub_push_value (DtInt);
void        dor_global_glbrndmaxsub_set_value (DtInt);
void        dor_global_glbrndmaxsub_update_execute (void);
void        dor_global_glbrndraylvl_destroy_element (DtInt*);
DtInt*      dor_global_glbrndraylvl_get_data_pointer (void);
DtFlag      dor_global_glbrndraylvl_get_value (DtInt*);
void        dor_global_glbrndraylvl_initialize (void);
void        dor_global_glbrndraylvl_pop_group (void);
DtFlag      dor_global_glbrndraylvl_pop_value (void);
void        dor_global_glbrndraylvl_push_value (DtInt);
void        dor_global_glbrndraylvl_set_value (DtInt);
void        dor_global_glbrndraylvl_update_execute (void);
void        dor_global_hidsrfswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_hidsrfswi_get_data_pointer (void);
DtFlag      dor_global_hidsrfswi_get_value (DtSwitch*);
void        dor_global_hidsrfswi_initialize (void);
void        dor_global_hidsrfswi_pop_group (void);
DtFlag      dor_global_hidsrfswi_pop_value (void);
void        dor_global_hidsrfswi_push_value (DtSwitch);
void        dor_global_hidsrfswi_set_value (DtSwitch);
void        dor_global_hidsrfswi_update_execute (void);
void        dor_global_intermdisptype_destroy_element
                (struct global_intermdisptype_data*);
struct global_intermdisptype_data*
            dor_global_intermdisptype_get_data_pointer (void);
DtFlag      dor_global_intermdisptype_get_value
                (DtIntermediateDispType* , DtInt*, DtInt, DtInt*);
void        dor_global_intermdisptype_initialize (void);
void        dor_global_intermdisptype_pop_group (void);
DtFlag      dor_global_intermdisptype_pop_value (void);
void        dor_global_intermdisptype_push_value(DtIntermediateDispType,DtInt*);
void        dor_global_intermdisptype_set_value (DtIntermediateDispType,DtInt*);
void        dor_global_intermdisptype_update_execute (void);
void        dor_global_inttyp_destroy_element (DtSwitch*);
DtInterpType*
            dor_global_inttyp_get_data_pointer (void);
DtFlag      dor_global_inttyp_get_value (DtInterpType*);
void        dor_global_inttyp_initialize (void);
void        dor_global_inttyp_pop_group (void);
DtFlag      dor_global_inttyp_pop_value (void);
void        dor_global_inttyp_push_value (DtInterpType);
void        dor_global_inttyp_set_value (DtInterpType);
void        dor_global_inttyp_update_execute (void);
void        dor_global_invswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_invswi_get_data_pointer (void);
DtFlag      dor_global_invswi_get_value (DtSwitch*);
void        dor_global_invswi_initialize (void);
void        dor_global_invswi_pop_group (void);
DtFlag      dor_global_invswi_pop_value (void);
void        dor_global_invswi_push_value (DtSwitch);
void        dor_global_invswi_set_value (DtSwitch);
void        dor_global_invswi_update_execute (void);
void        dor_global_lcstowcsmat_destroy_element (DtMatrix4x4*);
DtFlag      dor_global_lcstowcsmat_get_value (DtMatrix4x4);
void        dor_global_lcstowcsmat_initialize (void);
void        dor_global_lcstowcsmat_notify_change (void);
void        dor_global_lcstowcsmat_pop_group (void);
DtFlag      dor_global_lcstowcsmat_pop_value (void);
void        dor_global_lcstowcsmat_print_value (void);
void        dor_global_lcstowcsmat_push_value (DtMatrix4x4);
void        dor_global_lcstowcsmat_set_value (DtMatrix4x4);
void        dor_global_lcstowcsmat_update_execute
                (DtMatrix4x4, DtGlobalCall, DtInt);
void        dor_global_lgtatn_destroy_element (struct global_lgtatn_data*);
struct global_lgtatn_data*
                dor_global_lgtatn_get_data_pointer (void);
DtFlag      dor_global_lgtatn_get_value (DtReal* , DtReal*);
void        dor_global_lgtatn_initialize (void);
void        dor_global_lgtatn_pop_group (void);
DtFlag      dor_global_lgtatn_pop_value (void);
void        dor_global_lgtatn_push_value (DtReal, DtReal);
void        dor_global_lgtatn_set_value (DtReal, DtReal);
void        dor_global_lgtatn_update_execute (void);
void        dor_global_lgtclr_destroy_element (DtColorRGB*);
DtColorRGB* dor_global_lgtclr_get_data_pointer (void);
DtFlag      dor_global_lgtclr_get_value (DtColorModel* , DtReal[3]);
void        dor_global_lgtclr_initialize (void);
void        dor_global_lgtclr_pop_group (void);
DtFlag      dor_global_lgtclr_pop_value (void);
void        dor_global_lgtclr_push_value (DtColorRGB);
void        dor_global_lgtclr_set_value (DtColorRGB);
void        dor_global_lgtclr_update_execute (void);
void        dor_global_lgtint_destroy_element (DtReal*);
DtReal*     dor_global_lgtint_get_data_pointer (void);
DtFlag      dor_global_lgtint_get_value (DtReal*);
void        dor_global_lgtint_initialize (void);
void        dor_global_lgtint_pop_group (void);
DtFlag      dor_global_lgtint_pop_value (void);
void        dor_global_lgtint_push_value (DtReal);
void        dor_global_lgtint_set_value (DtReal);
void        dor_global_lgtint_update_execute (void);
void        dor_global_lgtspdang_destroy_element(struct global_lgtspdang_data*);
struct global_lgtspdang_data*
            dor_global_lgtspdang_get_data_pointer (void);
DtFlag      dor_global_lgtspdang_get_value (DtReal* , DtReal*);
void        dor_global_lgtspdang_initialize (void);
void        dor_global_lgtspdang_pop_group (void);
DtFlag      dor_global_lgtspdang_pop_value (void);
void        dor_global_lgtspdang_push_value (DtReal, DtReal);
void        dor_global_lgtspdang_set_value (DtReal, DtReal);
void        dor_global_lgtspdang_update_execute (void);
void        dor_global_lgtspdexp_destroy_element (DtReal*);
DtReal*     dor_global_lgtspdexp_get_data_pointer (void);
DtFlag      dor_global_lgtspdexp_get_value (DtReal*);
void        dor_global_lgtspdexp_initialize (void);
void        dor_global_lgtspdexp_pop_group (void);
DtFlag      dor_global_lgtspdexp_pop_value (void);
void        dor_global_lgtspdexp_push_value (DtReal);
void        dor_global_lgtspdexp_set_value (DtReal);
void        dor_global_lgtspdexp_update_execute (void);
void        dor_global_lgtswi_destroy_element (struct global_lgtswi_data *);
DtFlag      dor_global_lgtswi_get_value (DtInt* , DtPtr*, DtInt);
void        dor_global_lgtswi_initialize (void);
void        dor_global_lgtswi_pop_group (void);
DtFlag      dor_global_lgtswi_pop_value (void);
void        dor_global_lgtswi_push_value (DtInt, DtPtr*);
void        dor_global_lgtswi_set_value (DtObject, DtSwitch);
void        dor_global_lgtswi_update_execute (void);
void        dor_global_lgttyp_destroy_element (DtObject*);
DtObject*   dor_global_lgttyp_get_data_pointer (void);
DtFlag      dor_global_lgttyp_get_value (DtObject*);
void        dor_global_lgttyp_initialize (void);
void        dor_global_lgttyp_pop_group (void);
DtFlag      dor_global_lgttyp_pop_value (void);
void        dor_global_lgttyp_push_value (DtObject);
void        dor_global_lgttyp_set_value (DtObject);
void        dor_global_lgttyp_update_execute (void);
void        dor_global_lintyp_destroy_element (DtLineType*);
DtLineType* dor_global_lintyp_get_data_pointer (void);
DtFlag      dor_global_lintyp_get_value (DtLineType*);
void        dor_global_lintyp_initialize (void);
void        dor_global_lintyp_pop_group (void);
DtFlag      dor_global_lintyp_pop_value (void);
void        dor_global_lintyp_push_value (DtLineType);
void        dor_global_lintyp_set_value (DtLineType);
void        dor_global_lintyp_update_execute (void);
void        dor_global_linwid_destroy_element (DtReal*);
DtReal*     dor_global_linwid_get_data_pointer (void);
DtFlag      dor_global_linwid_get_value (DtReal*);
void        dor_global_linwid_initialize (void);
void        dor_global_linwid_pop_group (void);
DtFlag      dor_global_linwid_pop_value (void);
void        dor_global_linwid_push_value (DtReal);
void        dor_global_linwid_set_value (DtReal);
void        dor_global_linwid_update_execute (void);
void        dor_global_localaasty_destroy_element (DtLocalAntiAliasStyle*);
DtLocalAntiAliasStyle*
            dor_global_localaasty_get_data_pointer (void);
DtFlag      dor_global_localaasty_get_value (DtLocalAntiAliasStyle*);
void        dor_global_localaasty_initialize (void);
void        dor_global_localaasty_pop_group (void);
DtFlag      dor_global_localaasty_pop_value (void);
void        dor_global_localaasty_push_value (DtLocalAntiAliasStyle);
void        dor_global_localaasty_set_value (DtLocalAntiAliasStyle);
void        dor_global_localaasty_update_execute (void);
void        dor_global_localaaswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_localaaswi_get_data_pointer (void);
DtFlag      dor_global_localaaswi_get_value (DtSwitch*);
void        dor_global_localaaswi_initialize (void);
void        dor_global_localaaswi_pop_group (void);
DtFlag      dor_global_localaaswi_pop_value (void);
void        dor_global_localaaswi_push_value (DtSwitch);
void        dor_global_localaaswi_set_value (DtSwitch);
void        dor_global_localaaswi_update_execute (void);
void        dor_global_mapbmp_destroy_element (struct global_mapbmp_data*);
struct global_mapbmp_data*
            dor_global_mapbmp_get_data_pointer (void);
DtFlag      dor_global_mapbmp_get_value
                (DtInt, DtInt*, DtObject[], DtObject[], DtInt,
                 unsigned char[], DtInt[]);
void        dor_global_mapbmp_initialize (void);
void        dor_global_mapbmp_pop_group (void);
DtFlag      dor_global_mapbmp_pop_value (void);
void        dor_global_mapbmp_push_value
                (DtMapOperator, DtObject, DtObject, DtPtr, DtInt);
void        dor_global_mapbmp_set_value
                (DtMapOperator, DtObject, DtObject, DtPtr, DtInt);
void        dor_global_mapbmp_update_execute (void);
void        dor_global_mapbmpswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_mapbmpswi_get_data_pointer (void);
DtFlag      dor_global_mapbmpswi_get_value (DtSwitch*);
void        dor_global_mapbmpswi_initialize (void);
void        dor_global_mapbmpswi_pop_group (void);
DtFlag      dor_global_mapbmpswi_pop_value (void);
void        dor_global_mapbmpswi_push_value (DtSwitch);
void        dor_global_mapbmpswi_set_value (DtSwitch);
void        dor_global_mapbmpswi_update_execute (void);
void        dor_global_mapdifclr_destroy_element(struct global_mapdifclr_data*);
struct global_mapdifclr_data*
            dor_global_mapdifclr_get_data_pointer (void);
DtFlag      dor_global_mapdifclr_get_value
                (DtInt, DtInt* , DtObject[], DtObject[], DtInt,
                 unsigned char[], DtInt[]);
void        dor_global_mapdifclr_initialize (void);
void        dor_global_mapdifclr_pop_group (void);
DtFlag      dor_global_mapdifclr_pop_value (void);
void        dor_global_mapdifclr_push_value
                (DtMapOperator, DtObject, DtObject, DtPtr, DtInt);
void        dor_global_mapdifclr_set_value
                (DtMapOperator, DtObject, DtObject, DtPtr, DtInt);
void        dor_global_mapdifclr_update_execute (void);
void        dor_global_mapdifclrswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_mapdifclrswi_get_data_pointer (void);
DtFlag      dor_global_mapdifclrswi_get_value (DtSwitch*);
void        dor_global_mapdifclrswi_initialize (void);
void        dor_global_mapdifclrswi_pop_group (void);
DtFlag      dor_global_mapdifclrswi_pop_value (void);
void        dor_global_mapdifclrswi_push_value (DtSwitch);
void        dor_global_mapdifclrswi_set_value (DtSwitch);
void        dor_global_mapdifclrswi_update_execute (void);
void        dor_global_mapenv_destroy_element (struct global_mapenv_data*);
struct global_mapenv_data*
            dor_global_mapenv_get_data_pointer (void);
DtFlag      dor_global_mapenv_get_value
                (DtInt, DtInt* , DtObject[], DtObject[], DtInt,
                 unsigned char[], DtInt[]);
void        dor_global_mapenv_initialize (void);
void        dor_global_mapenv_pop_group (void);
DtFlag      dor_global_mapenv_pop_value (void);
void        dor_global_mapenv_push_value
                (DtMapOperator, DtObject, DtObject, DtPtr, DtInt);
void        dor_global_mapenv_set_value
                (DtMapOperator, DtObject, DtObject, DtPtr, DtInt);
void        dor_global_mapenv_update_execute (void);
void        dor_global_mapenvswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_mapenvswi_get_data_pointer (void);
DtFlag      dor_global_mapenvswi_get_value (DtSwitch*);
void        dor_global_mapenvswi_initialize (void);
void        dor_global_mapenvswi_pop_group (void);
DtFlag      dor_global_mapenvswi_pop_value (void);
void        dor_global_mapenvswi_push_value (DtSwitch);
void        dor_global_mapenvswi_set_value (DtSwitch);
void        dor_global_mapenvswi_update_execute (void);
void        dor_global_maptrnint_destroy_element
                (struct global_maptrnint_data*);
struct global_maptrnint_data*
            dor_global_maptrnint_get_data_pointer (void);
DtFlag      dor_global_maptrnint_get_value
                (DtInt, DtInt* , DtObject[], DtObject[], DtInt,
                 unsigned char[], DtInt[]);
void        dor_global_maptrnint_initialize (void);
void        dor_global_maptrnint_pop_group (void);
DtFlag      dor_global_maptrnint_pop_value (void);
void        dor_global_maptrnint_push_value
                (DtMapOperator, DtObject, DtObject, DtPtr, DtInt);
void        dor_global_maptrnint_set_value
                (DtMapOperator, DtObject, DtObject, DtPtr, DtInt);
void        dor_global_maptrnint_update_execute (void);
void        dor_global_maptrnintswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_maptrnintswi_get_data_pointer (void);
DtFlag      dor_global_maptrnintswi_get_value (DtSwitch*);
void        dor_global_maptrnintswi_initialize (void);
void        dor_global_maptrnintswi_pop_group (void);
DtFlag      dor_global_maptrnintswi_pop_value (void);
void        dor_global_maptrnintswi_push_value (DtSwitch);
void        dor_global_maptrnintswi_set_value (DtSwitch);
void        dor_global_maptrnintswi_update_execute (void);
struct global_minbndext_data*
            dor_global_minbndext_create_data (void);
void        dor_global_minbndext_destroy (struct global_minbndext_data*);
void        dor_global_minbndext_destroy_element (DtReal*);
DtReal*     dor_global_minbndext_get_data_pointer (void);
DtFlag      dor_global_minbndext_get_value (DtReal*);
void        dor_global_minbndext_initialize (void);
void        dor_global_minbndext_pop_group (void);
DtFlag      dor_global_minbndext_pop_value (void);
void        dor_global_minbndext_push_value (DtReal);
void        dor_global_minbndext_set_value (DtReal);
void        dor_global_minbndext_update_execute (void);
void        dor_global_mkrfnt_destroy_element (DtFont*);
DtInt*      dor_global_mkrfnt_get_data_pointer (void);
DtFlag      dor_global_mkrfnt_get_value (DtFont*);
void        dor_global_mkrfnt_initialize (void);
void        dor_global_mkrfnt_pop_group (void);
DtFlag      dor_global_mkrfnt_pop_value (void);
void        dor_global_mkrfnt_push_value (DtFont);
void        dor_global_mkrfnt_set_value (DtFont);
void        dor_global_mkrfnt_update_execute (void);
void        dor_global_mkrgly_destroy_element (DtInt*);
DtInt*      dor_global_mkrgly_get_data_pointer (void);
DtFlag      dor_global_mkrgly_get_value (DtInt*);
void        dor_global_mkrgly_initialize (void);
void        dor_global_mkrgly_pop_group (void);
DtFlag      dor_global_mkrgly_pop_value (void);
void        dor_global_mkrgly_push_value (DtInt);
void        dor_global_mkrgly_set_value (DtInt);
void        dor_global_mkrgly_update_execute (void);
struct global_mkrscl_data*
            dor_global_mkrscl_create_data (void);
void        dor_global_mkrscl_destroy (struct global_mkrscl_data*);
void        dor_global_mkrscl_destroy_element (DtReal*);
DtReal*     dor_global_mkrscl_get_data_pointer (void);
DtFlag      dor_global_mkrscl_get_value (DtReal*);
void        dor_global_mkrscl_initialize (void);
void        dor_global_mkrscl_pop_group (void);
DtFlag      dor_global_mkrscl_pop_value (void);
void        dor_global_mkrscl_push_value (DtReal);
void        dor_global_mkrscl_set_value (DtReal);
void        dor_global_mkrscl_update_execute (void);
void        dor_global_namset_destroy_element (dot_bitfield*);
dot_bitfield*
            dor_global_namset_get_data_pointer (void);
DtFlag      dor_global_namset_get_value (dot_bitfield);
void        dor_global_namset_initialize (void);
void        dor_global_namset_pop_group (void);
DtFlag      dor_global_namset_pop_value (void);
void        dor_global_namset_push_value (dot_bitfield);
void        dor_global_namset_set_value (dot_bitfield);
void        dor_global_namset_update_execute (void);
void        dor_global_pckid_destroy_element (DtInt*);
DtInt*      dor_global_pckid_get_data_pointer (void);
DtFlag      dor_global_pckid_get_value (DtInt*);
void        dor_global_pckid_initialize (void);
void        dor_global_pckid_pop_group (void);
DtFlag      dor_global_pckid_pop_value (void);
void        dor_global_pckid_push_value (DtInt);
void        dor_global_pckid_set_value (DtInt);
void        dor_global_pckid_update_execute (void);
void        dor_global_pckswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_pckswi_get_data_pointer (void);
DtFlag      dor_global_pckswi_get_value (DtSwitch*);
void        dor_global_pckswi_initialize (void);
void        dor_global_pckswi_pop_group (void);
DtFlag      dor_global_pckswi_pop_value (void);
void        dor_global_pckswi_push_value (DtSwitch);
void        dor_global_pckswi_set_value (DtSwitch);
void        dor_global_pckswi_update_execute (void);
void        dor_global_radambswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_radambswi_get_data_pointer (void);
DtFlag      dor_global_radambswi_get_value (DtSwitch*);
void        dor_global_radambswi_initialize (void);
void        dor_global_radambswi_pop_group (void);
DtFlag      dor_global_radambswi_pop_value (void);
void        dor_global_radambswi_push_value (DtSwitch);
void        dor_global_radambswi_set_value (DtSwitch);
void        dor_global_radambswi_update_execute (void);
void        dor_global_radswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_radswi_get_data_pointer (void);
DtFlag      dor_global_radswi_get_value (DtSwitch*);
void        dor_global_radswi_initialize (void);
void        dor_global_radswi_pop_group (void);
DtFlag      dor_global_radswi_pop_value (void);
void        dor_global_radswi_push_value (DtSwitch);
void        dor_global_radswi_set_value (DtSwitch);
void        dor_global_radswi_update_execute (void);
void        dor_global_reflecswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_reflecswi_get_data_pointer (void);
DtFlag      dor_global_reflecswi_get_value (DtSwitch*);
void        dor_global_reflecswi_initialize (void);
void        dor_global_reflecswi_pop_group (void);
DtFlag      dor_global_reflecswi_pop_value (void);
void        dor_global_reflecswi_push_value (DtSwitch);
void        dor_global_reflecswi_set_value (DtSwitch);
void        dor_global_reflecswi_update_execute (void);
void        dor_global_refractidx_destroy_element (DtReal*);
DtReal*     dor_global_refractidx_get_data_pointer (void);
DtFlag      dor_global_refractidx_get_value (DtReal*);
void        dor_global_refractidx_initialize (void);
void        dor_global_refractidx_pop_group (void);
DtFlag      dor_global_refractidx_pop_value (void);
void        dor_global_refractidx_push_value (DtReal);
void        dor_global_refractidx_set_value (DtReal);
void        dor_global_refractidx_update_execute (void);
void        dor_global_refractswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_refractswi_get_data_pointer (void);
DtFlag      dor_global_refractswi_get_value (DtSwitch*);
void        dor_global_refractswi_initialize (void);
void        dor_global_refractswi_pop_group (void);
DtFlag      dor_global_refractswi_pop_value (void);
void        dor_global_refractswi_push_value (DtSwitch);
void        dor_global_refractswi_set_value (DtSwitch);
void        dor_global_refractswi_update_execute (void);
void        dor_global_reptyp_destroy_element (DtSwitch*);
DtRepType*  dor_global_reptyp_get_data_pointer (void);
DtFlag      dor_global_reptyp_get_value (DtRepType*);
void        dor_global_reptyp_initialize (void);
void        dor_global_reptyp_pop_group (void);
DtFlag      dor_global_reptyp_pop_value (void);
void        dor_global_reptyp_push_value (DtRepType);
void        dor_global_reptyp_set_value (DtRepType);
void        dor_global_reptyp_update_execute (void);
void        dor_global_shadowswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_shadowswi_get_data_pointer (void);
DtFlag      dor_global_shadowswi_get_value (DtSwitch*);
void        dor_global_shadowswi_initialize (void);
void        dor_global_shadowswi_pop_group (void);
DtFlag      dor_global_shadowswi_pop_value (void);
void        dor_global_shadowswi_push_value (DtSwitch);
void        dor_global_shadowswi_set_value (DtSwitch);
void        dor_global_shadowswi_update_execute (void);
void        dor_global_shdidx_destroy_element (DtInt*);
DtInt*      dor_global_shdidx_get_data_pointer (void);
DtFlag      dor_global_shdidx_get_value (DtInt*);
void        dor_global_shdidx_initialize (void);
void        dor_global_shdidx_pop_group (void);
DtFlag      dor_global_shdidx_pop_value (void);
void        dor_global_shdidx_push_value (DtInt);
void        dor_global_shdidx_set_value (DtInt);
void        dor_global_shdidx_update_execute (void);
void        dor_global_smpadapt_destroy_element (DtReal*);
DtReal*     dor_global_smpadapt_get_data_pointer (void);
DtFlag      dor_global_smpadapt_get_value (DtReal*);
void        dor_global_smpadapt_initialize (void);
void        dor_global_smpadapt_pop_group (void);
DtFlag      dor_global_smpadapt_pop_value (void);
void        dor_global_smpadapt_push_value (DtReal);
void        dor_global_smpadapt_set_value (DtReal);
void        dor_global_smpadapt_update_execute (void);
void        dor_global_smpadaptswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_smpadaptswi_get_data_pointer (void);
DtFlag      dor_global_smpadaptswi_get_value (DtSwitch*);
void        dor_global_smpadaptswi_initialize (void);
void        dor_global_smpadaptswi_pop_group (void);
DtFlag      dor_global_smpadaptswi_pop_value (void);
void        dor_global_smpadaptswi_push_value (DtSwitch);
void        dor_global_smpadaptswi_set_value (DtSwitch);
void        dor_global_smpadaptswi_update_execute (void);
void        dor_global_smpfilter_destroy_element(struct global_smpfilter_data*);
struct global_smpfilter_data*
            dor_global_smpfilter_get_data_pointer (void);
DtFlag      dor_global_smpfilter_get_value (DtObject* , DtReal*, DtReal*);
void        dor_global_smpfilter_initialize (void);
void        dor_global_smpfilter_pop_group (void);
DtFlag      dor_global_smpfilter_pop_value (void);
void        dor_global_smpfilter_push_value (DtObject, DtReal, DtReal);
void        dor_global_smpfilter_set_value (DtObject, DtReal, DtReal);
void        dor_global_smpfilter_update_execute (void);
void        dor_global_smpjitter_destroy_element (DtReal*);
DtReal*     dor_global_smpjitter_get_data_pointer (void);
DtFlag      dor_global_smpjitter_get_value (DtReal*);
void        dor_global_smpjitter_initialize (void);
void        dor_global_smpjitter_pop_group (void);
DtFlag      dor_global_smpjitter_pop_value (void);
void        dor_global_smpjitter_push_value (DtReal);
void        dor_global_smpjitter_set_value (DtReal);
void        dor_global_smpjitter_update_execute (void);
void        dor_global_smpjitterswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_smpjitterswi_get_data_pointer (void);
DtFlag      dor_global_smpjitterswi_get_value (DtSwitch*);
void        dor_global_smpjitterswi_initialize (void);
void        dor_global_smpjitterswi_pop_group (void);
DtFlag      dor_global_smpjitterswi_pop_value (void);
void        dor_global_smpjitterswi_push_value (DtSwitch);
void        dor_global_smpjitterswi_set_value (DtSwitch);
void        dor_global_smpjitterswi_update_execute (void);
void        dor_global_smpsuper_destroy_element (struct global_smpsuper_data*);
struct global_smpsuper_data*
            dor_global_smpsuper_get_data_pointer (void);
DtFlag      dor_global_smpsuper_get_value (DtInt* , DtInt*);
void        dor_global_smpsuper_initialize (void);
void        dor_global_smpsuper_pop_group (void);
DtFlag      dor_global_smpsuper_pop_value (void);
void        dor_global_smpsuper_push_value (DtInt, DtInt);
void        dor_global_smpsuper_set_value (DtInt, DtInt);
void        dor_global_smpsuper_update_execute (void);
void        dor_global_smpsuperswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_smpsuperswi_get_data_pointer (void);
DtFlag      dor_global_smpsuperswi_get_value (DtSwitch*);
void        dor_global_smpsuperswi_initialize (void);
void        dor_global_smpsuperswi_pop_group (void);
DtFlag      dor_global_smpsuperswi_pop_value (void);
void        dor_global_smpsuperswi_push_value (DtSwitch);
void        dor_global_smpsuperswi_set_value (DtSwitch);
void        dor_global_smpsuperswi_update_execute (void);
void        dor_global_spcclr_destroy_element (DtColorRGB*);
DtColorRGB* dor_global_spcclr_get_data_pointer (void);
DtFlag      dor_global_spcclr_get_value (DtColorModel* , DtReal[3]);
void        dor_global_spcclr_initialize (void);
void        dor_global_spcclr_pop_group (void);
DtFlag      dor_global_spcclr_pop_value (void);
void        dor_global_spcclr_push_value (DtColorRGB);
void        dor_global_spcclr_set_value (DtColorRGB);
void        dor_global_spcclr_update_execute (void);
void        dor_global_spcfct_destroy_element (DtReal*);
DtReal*     dor_global_spcfct_get_data_pointer (void);
DtFlag      dor_global_spcfct_get_value (DtReal*);
void        dor_global_spcfct_initialize (void);
void        dor_global_spcfct_pop_group (void);
DtFlag      dor_global_spcfct_pop_value (void);
void        dor_global_spcfct_push_value (DtReal);
void        dor_global_spcfct_set_value (DtReal);
void        dor_global_spcfct_update_execute (void);
void        dor_global_spcint_destroy_element (DtReal*);
DtReal*     dor_global_spcint_get_data_pointer (void);
DtFlag      dor_global_spcint_get_value (DtReal*);
void        dor_global_spcint_initialize (void);
void        dor_global_spcint_pop_group (void);
DtFlag      dor_global_spcint_pop_value (void);
void        dor_global_spcint_push_value (DtReal);
void        dor_global_spcint_set_value (DtReal);
void        dor_global_spcint_update_execute (void);
void        dor_global_spcswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_spcswi_get_data_pointer (void);
DtFlag      dor_global_spcswi_get_value (DtSwitch*);
void        dor_global_spcswi_initialize (void);
void        dor_global_spcswi_pop_group (void);
DtFlag      dor_global_spcswi_pop_value (void);
void        dor_global_spcswi_push_value (DtSwitch);
void        dor_global_spcswi_set_value (DtSwitch);
void        dor_global_spcswi_update_execute (void);
void        dor_global_srfedgclr_destroy_element (DtColorRGB*);
DtColorRGB* dor_global_srfedgclr_get_data_pointer (void);
DtFlag      dor_global_srfedgclr_get_value (DtColorModel* , DtReal[3]);
void        dor_global_srfedgclr_initialize (void);
void        dor_global_srfedgclr_pop_group (void);
DtFlag      dor_global_srfedgclr_pop_value (void);
void        dor_global_srfedgclr_push_value (DtColorRGB);
void        dor_global_srfedgclr_set_value (DtColorRGB);
void        dor_global_srfedgclr_update_execute (void);
void        dor_global_srfshd_destroy_element (DtObject*);
DtObject*   dor_global_srfshd_get_data_pointer (void);
DtFlag      dor_global_srfshd_get_value (DtObject*);
void        dor_global_srfshd_initialize (void);
void        dor_global_srfshd_pop_group (void);
DtFlag      dor_global_srfshd_pop_value (void);
void        dor_global_srfshd_push_value (DtObject);
void        dor_global_srfshd_set_value (DtObject);
void        dor_global_srfshd_update_execute (void);
void        dor_global_stereo_destroy_element (struct global_stereo_data*);
struct global_stereo_data*
            dor_global_stereo_get_data_pointer (void);
DtFlag      dor_global_stereo_get_value (DtReal* , DtReal*);
void        dor_global_stereo_initialize (void);
void        dor_global_stereo_pop_group (void);
DtFlag      dor_global_stereo_pop_value (void);
void        dor_global_stereo_push_value (DtReal, DtReal);
void        dor_global_stereo_set_value (DtReal, DtReal);
void        dor_global_stereo_update_execute (void);
void        dor_global_stereoswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_stereoswi_get_data_pointer (void);
DtFlag      dor_global_stereoswi_get_value (DtSwitch*);
void        dor_global_stereoswi_initialize (void);
void        dor_global_stereoswi_pop_group (void);
DtFlag      dor_global_stereoswi_pop_value (void);
void        dor_global_stereoswi_push_value (DtSwitch);
void        dor_global_stereoswi_set_value (DtSwitch);
void        dor_global_stereoswi_update_execute (void);
DtFlag      dor_global_subdivlvl_get_value (DtReal*);
void        dor_global_subdivspc_destroy_element(struct global_subdivspc_data*);
struct global_subdivspc_data*
            dor_global_subdivspc_get_data_pointer (void);
DtFlag      dor_global_subdivspc_get_value (DtInt* , DtReal*);
void        dor_global_subdivspc_initialize (void);
void        dor_global_subdivspc_pop_group (void);
DtFlag      dor_global_subdivspc_pop_value (void);
void        dor_global_subdivspc_push_value (DtInt, DtReal*);
void        dor_global_subdivspc_set_value (DtInt, DtReal*);
void        dor_global_subdivspc_update_execute (void);
void        dor_global_texaa_destroy_element (DtTextureAntiAliasMode*);
DtTextureAntiAliasMode*
            dor_global_texaa_get_data_pointer (void);
DtFlag      dor_global_texaa_get_value (DtTextureAntiAliasMode*);
void        dor_global_texaa_initialize (void);
void        dor_global_texaa_pop_group (void);
DtFlag      dor_global_texaa_pop_value (void);
void        dor_global_texaa_push_value (DtTextureAntiAliasMode);
void        dor_global_texaa_set_value (DtTextureAntiAliasMode);
void        dor_global_texaa_update_execute (void);
void        dor_global_texextuv_destroy_element (struct global_texextuv_data*);
struct global_texextuv_data*
            dor_global_texextuv_get_data_pointer (void);
DtFlag      dor_global_texextuv_get_value (DtExtendMode* , DtExtendMode*);
void        dor_global_texextuv_initialize (void);
void        dor_global_texextuv_pop_group (void);
DtFlag      dor_global_texextuv_pop_value (void);
void        dor_global_texextuv_push_value (DtExtendMode, DtExtendMode);
void        dor_global_texextuv_set_value (DtExtendMode, DtExtendMode);
void        dor_global_texextuv_update_execute (void);
void        dor_global_texextuvw_destroy_element(struct global_texextuvw_data*);
struct global_texextuvw_data*
            dor_global_texextuvw_get_data_pointer (void);
DtFlag      dor_global_texextuvw_get_value
                (DtExtendMode* , DtExtendMode*, DtExtendMode*);
void        dor_global_texextuvw_initialize (void);
void        dor_global_texextuvw_pop_group (void);
DtFlag      dor_global_texextuvw_pop_value (void);
void        dor_global_texextuvw_push_value
                (DtExtendMode, DtExtendMode, DtExtendMode);
void        dor_global_texextuvw_set_value
                (DtExtendMode, DtExtendMode, DtExtendMode);
void        dor_global_texextuvw_update_execute (void);
void        dor_global_texintsrf_destroy_element(struct global_texintsrf_data*);
struct global_texintsrf_data*
            dor_global_texintsrf_get_data_pointer (void);
DtFlag      dor_global_texintsrf_get_value (DtObject* , Dt2PartProjType*);
void        dor_global_texintsrf_initialize (void);
void        dor_global_texintsrf_pop_group (void);
DtFlag      dor_global_texintsrf_pop_value (void);
void        dor_global_texintsrf_push_value (DtObject, Dt2PartProjType);
void        dor_global_texintsrf_set_value (DtObject, Dt2PartProjType);
void        dor_global_texintsrf_update_execute (void);
void        dor_global_texmatuv_destroy_element (struct texmatuv*);
struct texmatuv*
            dor_global_texmatuv_get_data_pointer (void);
DtFlag      dor_global_texmatuv_get_value (DtMatrix3x3);
void        dor_global_texmatuv_initialize (void);
void        dor_global_texmatuv_pop_group (void);
DtFlag      dor_global_texmatuv_pop_value (void);
void        dor_global_texmatuv_print_value (void);
void        dor_global_texmatuv_push_value (DtMatrix3x3);
void        dor_global_texmatuv_set_value (DtMatrix3x3);
void        dor_global_texmatuv_update_execute (void);
void        dor_global_texmatuvw_destroy_element (struct texmatuvw*);
struct texmatuvw*
            dor_global_texmatuvw_get_data_pointer (void);
DtFlag      dor_global_texmatuvw_get_value (DtMatrix4x4);
void        dor_global_texmatuvw_initialize (void);
void        dor_global_texmatuvw_pop_group (void);
DtFlag      dor_global_texmatuvw_pop_value (void);
void        dor_global_texmatuvw_print_value (void);
void        dor_global_texmatuvw_push_value (DtMatrix4x4);
void        dor_global_texmatuvw_set_value (DtMatrix4x4);
void        dor_global_texmatuvw_update_execute (void);
void        dor_global_texop_destroy_element (DtTextureOperator*);
DtTextureOperator*
            dor_global_texop_get_data_pointer (void);
DtFlag      dor_global_texop_get_value (DtTextureOperator*);
void        dor_global_texop_initialize (void);
void        dor_global_texop_pop_group (void);
DtFlag      dor_global_texop_pop_value (void);
void        dor_global_texop_push_value (DtTextureOperator);
void        dor_global_texop_set_value (DtTextureOperator);
void        dor_global_texop_update_execute (void);
void        dor_global_texuvidx_destroy_element (DtInt*);
DtInt*      dor_global_texuvidx_get_data_pointer (void);
DtFlag      dor_global_texuvidx_get_value (DtInt*);
void        dor_global_texuvidx_initialize (void);
void        dor_global_texuvidx_pop_group (void);
DtFlag      dor_global_texuvidx_pop_value (void);
void        dor_global_texuvidx_push_value (DtInt);
void        dor_global_texuvidx_set_value (DtInt);
void        dor_global_texuvidx_update_execute (void);
void        dor_global_texuvwidx_destroy_element (DtInt*);
DtInt*      dor_global_texuvwidx_get_data_pointer (void);
DtFlag      dor_global_texuvwidx_get_value (DtInt*);
void        dor_global_texuvwidx_initialize (void);
void        dor_global_texuvwidx_pop_group (void);
DtFlag      dor_global_texuvwidx_pop_value (void);
void        dor_global_texuvwidx_push_value (DtInt);
void        dor_global_texuvwidx_set_value (DtInt);
void        dor_global_texuvwidx_update_execute (void);
void        dor_global_transpclr_destroy_element (DtColorRGB*);
DtColorRGB* dor_global_transpclr_get_data_pointer (void);
DtFlag      dor_global_transpclr_get_value (DtColorModel* , DtReal[3]);
void        dor_global_transpclr_initialize (void);
void        dor_global_transpclr_pop_group (void);
DtFlag      dor_global_transpclr_pop_value (void);
void        dor_global_transpclr_push_value (DtColorRGB);
void        dor_global_transpclr_set_value (DtColorRGB);
void        dor_global_transpclr_update_execute (void);
void        dor_global_transpint_destroy_element (DtReal*);
DtReal*     dor_global_transpint_get_data_pointer (void);
DtFlag      dor_global_transpint_get_value (DtReal*);
void        dor_global_transpint_initialize (void);
void        dor_global_transpint_pop_group (void);
DtFlag      dor_global_transpint_pop_value (void);
void        dor_global_transpint_push_value (DtReal);
void        dor_global_transpint_set_value (DtReal);
void        dor_global_transpint_update_execute (void);
void        dor_global_transporientclr_destroy_element (DtColorRGB*);
DtColorRGB* dor_global_transporientclr_get_data_pointer (void);
DtFlag      dor_global_transporientclr_get_value (DtColorModel* , DtReal[3]);
void        dor_global_transporientclr_initialize (void);
void        dor_global_transporientclr_pop_group (void);
DtFlag      dor_global_transporientclr_pop_value (void);
void        dor_global_transporientclr_push_value (DtColorRGB);
void        dor_global_transporientclr_set_value (DtColorRGB);
void        dor_global_transporientclr_update_execute (void);
void        dor_global_transporientexp_destroy_element (DtReal*);
DtReal*     dor_global_transporientexp_get_data_pointer (void);
DtFlag      dor_global_transporientexp_get_value (DtReal*);
void        dor_global_transporientexp_initialize (void);
void        dor_global_transporientexp_pop_group (void);
DtFlag      dor_global_transporientexp_pop_value (void);
void        dor_global_transporientexp_push_value (DtReal);
void        dor_global_transporientexp_set_value (DtReal);
void        dor_global_transporientexp_update_execute (void);
void        dor_global_transporientint_destroy_element (DtReal*);
DtReal*     dor_global_transporientint_get_data_pointer (void);
DtFlag      dor_global_transporientint_get_value (DtReal*);
void        dor_global_transporientint_initialize (void);
void        dor_global_transporientint_pop_group (void);
DtFlag      dor_global_transporientint_pop_value (void);
void        dor_global_transporientint_push_value (DtReal);
void        dor_global_transporientint_set_value (DtReal);
void        dor_global_transporientint_update_execute (void);
void        dor_global_transporientswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_transporientswi_get_data_pointer (void);
DtFlag      dor_global_transporientswi_get_value (DtSwitch*);
void        dor_global_transporientswi_initialize (void);
void        dor_global_transporientswi_pop_group (void);
DtFlag      dor_global_transporientswi_pop_value (void);
void        dor_global_transporientswi_push_value (DtSwitch);
void        dor_global_transporientswi_set_value (DtSwitch);
void        dor_global_transporientswi_update_execute (void);
void        dor_global_transpswi_destroy_element (DtSwitch*);
DtSwitch*   dor_global_transpswi_get_data_pointer (void);
DtFlag      dor_global_transpswi_get_value (DtSwitch*);
void        dor_global_transpswi_initialize (void);
void        dor_global_transpswi_pop_group (void);
DtFlag      dor_global_transpswi_pop_value (void);
void        dor_global_transpswi_push_value (DtSwitch);
void        dor_global_transpswi_set_value (DtSwitch);
void        dor_global_transpswi_update_execute (void);
void        dor_global_txtaln_destroy_element (dot_txtaln*);
dot_txtaln* dor_global_txtaln_get_data_pointer (void);
DtFlag      dor_global_txtaln_get_value (dot_txtaln*);
DtFlag      dor_global_txtaln_get_value2
                (DtTextAlignHorizontal* , DtTextAlignVertical*);
void        dor_global_txtaln_initialize (void);
void        dor_global_txtaln_pop_group (void);
DtFlag      dor_global_txtaln_pop_value (void);
void        dor_global_txtaln_push_value (dot_txtaln*);
void        dor_global_txtaln_set_value (dot_txtaln*);
void        dor_global_txtaln_update_execute (void);
void        dor_global_txtexp_destroy_element (DtReal*);
DtReal*     dor_global_txtexp_get_data_pointer (void);
DtFlag      dor_global_txtexp_get_value (DtReal*);
void        dor_global_txtexp_initialize (void);
void        dor_global_txtexp_pop_group (void);
DtFlag      dor_global_txtexp_pop_value (void);
void        dor_global_txtexp_push_value (DtReal);
void        dor_global_txtexp_set_value (DtReal);
void        dor_global_txtexp_update_execute (void);
void        dor_global_txtfnt_destroy_element (DtFont*);
DtInt*      dor_global_txtfnt_get_data_pointer (void);
DtFlag      dor_global_txtfnt_get_value (DtFont*);
void        dor_global_txtfnt_initialize (void);
void        dor_global_txtfnt_pop_group (void);
DtFlag      dor_global_txtfnt_pop_value (void);
void        dor_global_txtfnt_push_value (DtFont);
void        dor_global_txtfnt_set_value (DtFont);
void        dor_global_txtfnt_update_execute (void);
void        dor_global_txthgt_destroy_element (DtReal*);
DtReal*     dor_global_txthgt_get_data_pointer (void);
DtFlag      dor_global_txthgt_get_value (DtReal*);
void        dor_global_txthgt_initialize (void);
void        dor_global_txthgt_pop_group (void);
DtFlag      dor_global_txthgt_pop_value (void);
void        dor_global_txthgt_push_value (DtReal);
void        dor_global_txthgt_set_value (DtReal);
void        dor_global_txthgt_update_execute (void);
void        dor_global_txtpat_destroy_element (DtTextPath*);
DtTextPath* dor_global_txtpat_get_data_pointer (void);
DtFlag      dor_global_txtpat_get_value (DtTextPath*);
void        dor_global_txtpat_initialize (void);
void        dor_global_txtpat_pop_group (void);
DtFlag      dor_global_txtpat_pop_value (void);
void        dor_global_txtpat_push_value (DtTextPath);
void        dor_global_txtpat_set_value (DtTextPath);
void        dor_global_txtpat_update_execute (void);
void        dor_global_txtprc_destroy_element (DtTextPrecision*);
DtTextPrecision*
            dor_global_txtprc_get_data_pointer (void);
DtFlag      dor_global_txtprc_get_value (DtTextPrecision*);
void        dor_global_txtprc_initialize (void);
void        dor_global_txtprc_pop_group (void);
DtFlag      dor_global_txtprc_pop_value (void);
void        dor_global_txtprc_push_value (DtTextPrecision);
void        dor_global_txtprc_set_value (DtTextPrecision);
void        dor_global_txtprc_update_execute (void);
void        dor_global_txtspc_destroy_element (DtReal*);
DtReal*     dor_global_txtspc_get_data_pointer (void);
DtFlag      dor_global_txtspc_get_value (DtReal*);
void        dor_global_txtspc_initialize (void);
void        dor_global_txtspc_pop_group (void);
DtFlag      dor_global_txtspc_pop_value (void);
void        dor_global_txtspc_push_value (DtReal);
void        dor_global_txtspc_set_value (DtReal);
void        dor_global_txtspc_update_execute (void);
void        dor_global_txtupvec_destroy_element (dot_txtupvec*);
dot_txtupvec*
            dor_global_txtupvec_get_data_pointer (void);
DtFlag      dor_global_txtupvec_get_value (dot_txtupvec*);
DtFlag      dor_global_txtupvec_get_value2 (DtReal* , DtReal*);
void        dor_global_txtupvec_initialize (void);
void        dor_global_txtupvec_pop_group (void);
DtFlag      dor_global_txtupvec_pop_value (void);
void        dor_global_txtupvec_push_value (dot_txtupvec*);
void        dor_global_txtupvec_set_value (dot_txtupvec*);
void        dor_global_txtupvec_update_execute (void);

#endif
