.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvSetUpdateType 3D  "Dore"
.SH NAME
DvSetUpdateType \- Set the update type of a view
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DvSetUpdateType(view, updatetype)
DtObject view ;
DtUpdateType updatetype ;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DVSUT(VIEW,UPDTYP)
INTEGER*4 VIEW
INTEGER*4 UPDTYP
.in -.5i
.fi
.SH DESCRIPTION
.IX DVSUT
.IX DvSetUpdateType
.I DvSetUpdateType
sets the update type value for a view on subsequent updates.
The parameter \f2updatetype\fP 
determines which elements of a \f2view\f1 will be taken
into account during the update.
Possible values are:
.PP
.IP "\f2DcUpdateAll\fP <\f2DCUALL\fP>"
All objects, including cameras, lights, and display objects will be updated.
This mode should be used if the cameras and lights have been modified
since the last update of this view.
.IP "\f2DcUpdateDisplay\fP <\f2DCUDIS\fP>"
This mode causes only display objects to be updated. Camera and light
information is the same as on previous updates.
.SH ERRORS
.I DvSetUpdateType
will fail if the view handle is invalid.
.TP 15
[WARNING - invalid view handle]
.SH DEFAULTS
The default \f2updatetype\fP is \f2DcUpdateAll\fP <\f2DCUALL\fP>.
.SH "SEE ALSO"
.na
.nh
DdUpdate(3D), DfUpdate(3D), DvSetClearFlag(3D), DvSetRendStyle(3D)
.ad
.hy
