.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvSetBackgroundJust 3D "Dore"
.SH NAME
DvSetBackgroundJust \- Set the background raster justification
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DvSetBackgroundJust(view, left, bottom)
DtObject view;
DtReal left;
DtReal bottom;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
CALL DVSBJ(VIEW, LEFT, BOT)
INTEGER*4 VIEW
REAL*8 LEFT
REAL*8 BOT
.in  -.5i
.fi 
.IX "DvSetBackgroundJust"
.IX "DVSBJ"
.SH DESCRIPTION
.LP
\f2DvSetBackgroundJust\fP sets the justification of the background
raster in the specified view
\f2view\fP.
When the aspect ratios of the view and the background raster returned
from the background raster callback are not the same, there will be
extra "white space" in the view.
The justification provides a mechanism for controlling where this white
space is positioned.
The "white space" will be the background color of the view.
.LP
The \f2left\fP parameter defines a value between 0.0 and 1.0 inclusive
specifying the fraction of white space to be inserted between the
bottom left hand corner of the view and the left side of the raster.
Similarly, the \f2bottom\fP parameter specifies the fraction of white
space to be inserted between the bottom left hand corner of the view
and the bottom of the raster.
.LP
If the raster is larger than the view, \f2left\fP and \f2bottom\fP
specify the portion of the raster that will be cropped from the bottom
left hand corner of the raster.
.SH ERRORS
\f2DvSetBackgroundJust\fP will fail if the view handle is invalid.
.TP 15
[WARNING - invalid view handle]
.SH DEFAULTS
The default is \f2left\fP = 0.5 and \f2bottom\fP = 0.5 creating an
even distribution of white space in both directions.
.SH SEE ALSO
.na
.nh
DsInqRaster(3D),
DvInqBackgroundRaster(3D),
DvSetBackgroundJust(3D), 
DvSetBackgroundRaster(3D)
.ad
.hy 
\&
