.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvSetActiveCamera 3D  "Dore"
.SH NAME
DvSetActiveCamera \- Set the active camera for a view
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DvSetActiveCamera(view, camera)
DtObject view;
DtObject camera;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DVSAC(VIEW, CAMERA)
INTEGER*4 VIEW
INTEGER*4 CAMERA
.in -.5i
.fi
.SH DESCRIPTION
.IX DVSAC
.IX DvSetActiveCamera
.I DvSetActiveCamera
sets the active camera to be used with 
\f2view\fP to \f2camera\fP.
The active camera specifies which
camera will be used to render a view.
If this function is not called, the last camera defined in the
studio definition group will be used as the active camera.
.SH ERRORS
.I DvSetActiveCamera
will fail if the view handle is invalid.
.TP 15
[WARNING - invalid view handle]
.PP
\f2DvSetActiveCamera\fP will fail if the camera handle is invalid.
.TP 15
[WARNING - invalid camera handle]
.SH "SEE ALSO"
DvInqActiveCamera(3D)
