.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvInqRendStyle 3D  "Dore"
.SH NAME
DvInqRendStyle \- Return the rendering style of a view
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtRenderStyle DvInqRendStyle(view)
DtObject view ;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DVQRS(VIEW)
INTEGER*4 VIEW 
.in -.5i
.fi
.SH DESCRIPTION
.IX DvInqRendStyle
.IX DVQRS
.I DvInqRendStyle
returns the rendering style of the view specified by the parameter \f2view\fP.
The rendering style is a top level selection of the rendering process.
Most Dore configurations include at least the following two 
rendering styles:
.PP
.IP "\f2DcRealTime\fP <\f2DCRLTM\fP>"
Fast, interactive display rendering.  This renderer runs fast enough for
dynamic operations that require continuous updates of the scene.
.IP "\f2DcProductionTime\fP <\f2DCPRTM\fP>"
Slower, most realistic rendering.  This renderer does the most sophisticated
rendering within the user's requested parameters.  Dor\o.\(aae. may economize
if the application's parameters negate the effect of the time-intensive
techniques.
.PP
The value returned by \f2DvInqRendStyle\fP is equivalent to the
identifier of the current renderer.  
Using a renderer other than the dynamic renderer
or the standard production renderer will result in a different
renderer identifier returned from \f2DvInqRendStyle\fP.
For a complete list of available renderers,
see your \f2Dore System Guide\fP.
.SH ERRORS
.I DvInqRendStyle
will fail if the view parameter is not a valid view; the returned value is
undefined.
.TP 15
[WARNING - invalid view handle]
.SH "SEE ALSO"
DvSetRendStyle(3D)
