.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvInqBoundary 3D  "Dore"
.SH NAME
DvInqBoundary \- Return the view boundary
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DvInqBoundary(view, boundary)
DtObject view;
DtVolume *boundary;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DVQB(VIEW, BNDRY)
INTEGER*4 VIEW
REAL*8 BNDRY(6)
.in -.5i
.fi
.SH DESCRIPTION
.IX DVQB
.IX DvInqBoundary
.I DvInqBoundary
returns the view boundary for the view specified by the parameter \f2view\fP.
The view boundary parameter \f2boundary\fP specifies the position and amount of
space occupied by the view within a frame.
.SH ERRORS
.I DvInqBoundary
will fail if the view handle is invalid.
.TP 15
[WARNING - invalid view handle]
.SH "SEE ALSO"
DvSetBoundary(3D)
