.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvInqActiveCamera 3D  "Dore"
.SH NAME
DvInqActiveCamera \- Return the active camera for a view
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DvInqActiveCamera(view)
DtObject view;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DVQAC(VIEW)
INTEGER*4 VIEW
.in -.5i
.fi
.SH DESCRIPTION
.IX DVQAC
.IX DvInqActiveCamera
.I DvInqActiveCamera
queries the active camera previously set by 
\f2DvSetActiveCamera\fP.
If no camera was set with \f2DvSetActiveCamera\fP,
\f2DcNullObject\fP is returned.
In such a case, to render a view,
a renderer will usually
select the last camera that was defined.
.SH ERRORS
.I DvInqActiveCamera
will fail if the view handle is null.
.PP
[WARNING - invalid view handle]
.SH "SEE ALSO"
DoCamera(3D), DvSetActiveCamera(3D)
