.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsSetObjNameInteger 3D  "Dore"
.SH NAME
DsSetObjNameInteger \- Set an object's name to an integer value

.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DsSetObjNameInteger (object, name, replace)
.in  +.5i
DtObject object;
DtInt name;
DtFlag replace;

.in  -.5i
FORTRAN:
.in  +.5i
CALL DSSOND(OBJECT)
INTEGER*4 OBJECT

CALL DSSONI(OBJECT, OBJNUM, REPL)
INTEGER*4 OBJECT
INTEGER*4 OBJNUM
INTEGER*4 REPL
.in  -.5i

.fi
.SH DESCRIPTION
.IX DsSetObjNameInteger
.I DsSetObjNameInteger
sets an object's name to the given integer value.
.PP
The parameter \f2object\fP specifies the object to receive the new name.
.PP
If the \f2replace\fP flag is false, then this
function will report an error if another object of the same type already
has this name.  If \f2replace\fP is true, then the name will be set for
the object and removed from all other objects that have the same name.
.PP
Note that the integer name of 0 is reserved to indicate a no-name condition.
When \f2DsSetObjNameInteger\fP is called with an integer name of 0, the
existing integer name is removed from the object.
.SH "FORTRAN SPECIFIC"
.PP
\f2DSSOND\fP sets the name of \f2OBJECT\fP to \f2DCNNON\fP.  
No name is given;
the object name will be ignored.
.PP
.I DSSONI
sets the name of \f2OBJECT\fP to the integer \f2OBJNUM\fP.
This function gives an object an integer value name.
.SH ERRORS
.I DsSetObjNameInteger
will fail if the object is invalid.
.TP 15
[WARNING - invalid or deleted object]
.PP
.I DsSetObjNameInteger
will fail if the \f2replace\fP parameter is true and another object has
the same name.
.TP 15
[WARNING - object name already in use]
.SH "SEE ALSO"
.nf
DsSetObjNameString(3D), DsInqObjViaInteger(3D), DsInqObjNameInteger(3D)
