.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsSetObjName 3D  "Dore"
.SH NAME
DsSetObjName \- This function is obsolete and has been replaced by DsSetObjNameInteger and DsSetObjNameString
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DsSetObjName(object, name_type, object_name, 
	replace)
DtObject object;
DtNameType name_type;
DtPtr object_name;
DtFlag replace;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DSSOND(OBJECT)
INTEGER*4 OBJECT
.sp
CALL DSSONI(OBJECT, OBJNUM, REPL)
INTEGER*4 OBJECT
INTEGER*4 OBJNUM
INTEGER*4 REPL
.sp
CALL DSSONS(OBJECT, OBJSTR, N, REPL)
INTEGER*4 OBJECT
INTEGER*4 REPL
INTEGER*4 N
CHARACTER*N OBJSTR
.in -.5i
.fi
.SH DESCRIPTION
.IX DSSONS
.IX DSSONI
.IX DSSOND
.IX DsSetObjName
.I DsSetObjName
sets the name of an object, 
\f2object\fP, to \f2object_name\fP.
The parameter \f2name_type\fP specifies the type of \f2object_name\fP.
Possible values for \f2name_type\fP are:
.PP
.IP "\f2DcNameInteger\fP"
\f2object_name\f1 is an integer value name.
.IP "\f2DcNameString\fP"
\f2object_name\f1 is a string value name.
.IP "\f2DcNameNone\fP"
No name given; the object name will be ignored.  The user may pass an
\f2object_name\fP of \f2DcNullPtr\fP here.
.PP
No two objects of the same object type may have the same object name.
The \f2replace\fP flag signals whether to report an error if
an object of the same type already has this name (\f2DcOff\fP <\f2DCOFF\fP>)
or to set the name in all cases and remove the name from
any object (of this type) that has the proposed name (\f2DcOn\fP <\f2DCON\fP>).
.SH "FORTRAN SPECIFIC"
\f2DSSOND\fP sets the name of \f2OBJECT\fP to \f2DCNNON\fP.  
No name is given;
the object name will be ignored.
.PP
.I DSSONI
sets the name of \f2OBJECT\fP to the integer \f2OBJNUM\fP.
This function gives an object an integer value name.
.PP
.I DSSONS
sets the name of \f2OBJECT\fP to the string of \f2N\fP characters in 
\f2OBJSTR\fP.  This function gives an object a string value name.
.SH ERRORS
.I DsSetObjName
will fail if the object is invalid.
.TP 15
[WARNING - invalid or deleted object]
.PP
.I DsSetObjName
will fail if the name is already in use and the replace flag is not 
\f2DcOn\fP <\f2DCON\fP>.
.TP 15
[WARNING - object name already in use]
.SH "SEE ALSO"
DsInqObj(3D), DsInqObjName(3D)
