.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsSetErrorVars 3D  "Dore"
.SH NAME
DsSetErrorVars \- Specify an error file and error handler
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DsSetErrorVars(errorfile, errorhandler)
DtInt errorfile;
DtPFI errorhandler;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DSSEV(ERRFIL, ERRHND)
INTEGER*4 ERRFIL
EXTERNAL ERRHND
.in -.5i
.fi
.SH DESCRIPTION
.IX DSSEV
.IX DsSetErrorVars
.I DsSetErrorVars
installs an application error file descriptor and error handler.
The parameter \f2errorfile\fP specifies the file descriptor to which
any error messages should be sent. The value 2 is usually
\f2standard error\fP, i.e., the terminal, and is also the default error file.
.PP
The parameter \f2errorhandler\fP specifies the error handling procedure to be
called when errors are detected.  If this parameter is \f2DcNullPtr\fP
<\f2DCNULL\fP>, the default error handler prints the error information
to \f2errorfile\fP and, if the error is fatal, it exits the program.
.PP
Your error handling procedure in C should have
this format:
.nf

	MyErrorFunction(errorfile, errornumber, funcname, 
		errorstring)
	DtInt errorfile;
	DtPtr funcname;	/* the name of the function where 
				   the error occurred */
	DtInt errornumber;	/* the error number */
	DtPtr errorstring;	/* an additional string provided by 
				   funcname describing the error */
.fi
.SH "FORTRAN SPECIFIC"
FORTRAN should have
this format:
.nf

	ERRFUN(ERRFIL, ERRNUM, FCNNAM, FCNNML, 
		ERRSTR, ERRSTL)
	INTEGER*4 ERRFIL
	INTEGER*4 ERRNUM
	INTEGER*4 FCNNML
	INTEGER*4 ERRSTL
	CHARACTER*FCNNML FCNNAM
	CHARACTER*ERRSTL ERRSTR

.fi
Where \f2FCNNAM\fP is a function name \f2FCNNML\fP characters
long and \f2ERRSTR\fP is an error string \f2ERRSTL\fP
characters long.
.in  -.5i
.SH "SEE ALSO" 
DsInqErrorMessage(3D)
