.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsReleaseObj 3D  "Dore"
.SH NAME
DsReleaseObj \- Release a hold previously placed on an object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DsReleaseObj(object)
DtObject object;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DSRO(OBJECT)
INTEGER*4 OBJECT
.in -.5i
.fi
.SH DESCRIPTION
.IX DSRO
.IX DsReleaseObj
\f2DsReleaseObj\fP releases a previously placed hold on an object and
deletes the object if it is not referenced by any other objects.
See \f2DsHoldObj\fP.
.BP
.SH ERRORS
\f2DsReleaseObj\fP will fail if passed an invalid object.
.TP 15
[WARNING - invalid or deleted object]
.SH "SEE ALSO"
DsHoldObj(3D), DsInqHoldObj(3D)
