.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoVarQuadMesh 3D  "Dore"
.SH NAME
DoVarQuadMesh \- Create a variable quadrilateral mesh primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoVarQuadMesh(colormodel, vertexcount, 
		vertlocs, vertnorms, vertcolors, 
		quadcount, quads, smoothflag)
DtColorModel colormodel;
DtInt vertexcount;
DtReal vertlocs[\|];
DtReal vertnorms[\|];
DtReal vertcolors[\|];
DtInt quadcount;
DtInt quads[\|];
DtFlag smoothflag;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOVQDM(COLMOD, VTXCNT, VTXLOC, 
		VTXNRM, VTXCLR, QUDCNT, 
		QUADS, SMOOFL)
INTEGER*4 COLMOD
INTEGER*4 VTXCNT
REAL*8 VTXLOC(*)
REAL*8 VTXNRM(*)
REAL*8 VTXCLR(*)
INTEGER*4 QUDCNT
INTEGER*4 QUADS(4*QUDCNT)
INTEGER*4 SMOOFL
.fi
.SH DESCRIPTION 
.IX DOVQDM
.IX DoVarQuadMesh
.I DoVarQuadMesh 
creates a primitive object that defines a variable
collection of quadrilaterals, normally interconnected.
.PP
The main difference between a variable quadrilateral mesh and a 
quadrilateral mesh is that a variable quadrilateral mesh does not 
make a copy of the vertex data into its own data space.  
It simply maintains pointers to the vertex data 
(locations, normals and colors) in user space.  
A call to \f2DpUpdVarQuadMesh\fP <\f2DPUVQM\fP> informs a 
variable quadrilateral mesh object that the user data has changed.
.PP
The parameter \f2colormodel\fP specifies the color model used if 
vertex colors are provided.
The parameter \f2vertexcount\fP specifies the total number of 
vertices in the mesh.
The parameter \f2vertlocs\fP is an array of vertex locations.
The parameter \f2vertnorms\fP is an array of vertex normals.
If vertex normals are not available use
\f2DcNullPtr\fP <\f2DCNULL\fP>.
The parameter \f2vertcolors\fP is an array of vertex colors. 
If vertex colors are not available use
\f2DcNullPtr\fP <\f2DCNULL\fP>.
.PP
The parameter \f2quadcount\fP specifies the total number of 
quadrilaterals in the mesh.  
The parameter \f2quads\fP is a one-dimensional
array containing \f2quadcount\fP quadruplets of integers.
Each quadruplet is an ordered
list of mesh vertex numbers for the four coordinates of the quadrilateral.
.PP
If vertex normals are not provided, the parameter \f2smoothflag\fP
specifies that the vertex normal for shading
purposes will be the average of the geometric normals from a vertex's
adjacent surfaces.  This assumes that the quadrilateral mesh defines a 
smooth surface.
.PP
The geometric normal to each quadrilateral is calculated using the right-hand rule
(when the fingers of the right hand point in the order of the vertices,
the thumb points in the direction of the normal).  These geometric normal
calculations require that all quadrilaterals be planar.
These normals are sometimes used for backface culling and
facet shading.
.SH ERRORS
\f2DoVarQuadMesh\fP must be called with at least four vertices.
.PP
[WARNING - invalid parameter]
.PP
.I DoVarQuadMesh
will issue a warning if a zero vertex normal is calculated by Dore.
.PP
[WARNING - quad normals sum to 0 at vertex, check for back to back quads]
.SH "SEE ALSO"
.I DoVarQuadMesh
will issue a warning if a vertex index in \f2quads\f1 is out of bounds.
.PP
[WARNING - vertex index > vertexcount or < zero]
.na
.nh
DpUpdVarQuadMesh(3D), DoQuadMesh(3D), DoVarLineList(3D),
DoVarPointList(3D), DoVarSimplePolygonMesh(3D),
DoVarTriangleStrip(3D), UPDATE THIS!!!
.ad
.hy
