.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTranspSwitch 3D  "Dore"
.SH NAME
DoTranspSwitch \- Create a primitive attribute object for enabling or disabling transparency
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTranspSwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOTS(SWVAL)
INTEGER*4 SWVAL
.in -.5i
.fi
.SH DESCRIPTION
.IX DOTS
.IX DoTranspSwitch
.I DoTranspSwitch
creates a transparent switch primitive attribute object.  The parameter
\f2switchvalue\fP specifies whether the
surfaces of subsequent primitive objects have a transparent component.
Possible values are:
.IP "\f2DcOff\fP <\f2DCOFF\fP>"
The object will render itself without transparency regardless of the settings
for transparent color and transparent intensity.
.IP "\f2DcOn\fP <\f2DCON\fP>"
The object will render itself with transparency whenever possible.
.PP
The transparent switch is one of several values
that make a surface transparent.
Other values include the transparent color
(set with \f2DoTranspColor <DOTC>\fP) and the intensity
of the transparent color (set with \f2DoTranspIntens <DOTI>\fP).
.SH DEFAULTS
The default for \f2DoTranspSwitch\fP is \f2DcOff\fP <\f2DCOFF\fP>.
.SH "SEE ALSO"
.na
.nh
DoTranspColor(3D), DoTranspIntens(3D), DoTranspOrientColor(3D),
DoTranspOrientIntens(3D),
DoTranspOrientExp(3D),
DoTranspOrientSwitch(3D)
.ad
.hy
