.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTranspOrientColor 3D "Dore"
.SH NAME
DoTranspOrientColor \- Create a transparent color primitive attribute object for orientation dependent transparency
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTranspOrientColor(colormodel, color)
DtColorModel colormodel;
DtReal color[\|];
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOTOC(COLMOD, COLOR)
INTEGER*4 COLMOD
REAL*8 COLOR(*)
.in  -.5i
.fi 
.IX "DoTranspOrientColor"
.IX "DOTOC"
.SH DESCRIPTION
.PP
\f2DoTranspOrientColor\fP creates a transparent color primitive attribute 
object for orientation dependent transparency.
.LP
Orientation dependent transparency means that the transparency of
an object varies depending on the orientation of the object and the 
view direction.
The transparency can also vary across the object if it is not 
completely flat.
.PP
The parameter \f2color\fP specifies the transparent color 
to be used for subsequent objects when the object is oriented such that
the object normal is perpendicular to the viewing direction.
If the object normal is parallel to the viewing direction,
the value defined by \f2DoTranspColor\fP is used as the
transparent color.
For other object orientations the object transparent color 
is calculated as follows:
.PP
.nf
\f2final transpcolor = 
     orientcolor + (transpcolor - orientcolor)*((I dot N) ** orientexp)\fP
.fi
.PP
where \f2orientcolor\fP is the value specified by 
\f2DoTranspOrientColor\fP,
\f2transpcolor\fP is the value specified by \f2DoTranspColor\fP,
\f2orientexp\fP is the value specified by \f2DoTranspOrientExp\fP,
\f2N\fP is the object normal, 
and \f2I\fP is the view direction (or the incoming 
ray direction for ray-tracing).
To enable orientation dependent transparency,
both \f2DoTranspOrientSwitch <DOTOS>\fP and \f2DoTranspSwitch <DOTS>\fP
must be turned on.
.SH DEFAULTS
The default \f2DoTranspOrientColor\fP is (\f2DcRGB\fP, 1.0,1.0,1.0.).
.SH SEE ALSO 
.nh
.na
DoTranspOrientSwitch(3D),
DoTranspOrientIntens(3D),
DoTranspOrientExp(3D),
DoTranspIntens(3D),
DoTranspColor(3D),
DoTranspSwitch(3D)
.hy
.ad
\&
