.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTextureMapTranspIntensSwitch 3D "Dore"
.SH NAME
DoTextureMapTranspIntensSwitch \- Create a primitive attribute object for enabling or disabling texture mapping of transparent intensity
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTextureMapTranspIntensSwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOTMTS(SWVAL)
INTEGER*4 SWVAL
.in  -.5i
.fi 
.IX "DoTextureMapTranspIntensSwitch"
.IX "DOTMDS"
.SH DESCRIPTION
.LP
\f2DoTextureMapTranspIntensSwitch\fP creates a primitive attribute object that
enables disables texture mapping of transparent intensity.
The \f2switchvalue\fP parameter is used to specify whether or not the 
transparent intensity of subsequent objects can be modified by texture mapping.
.IP "\f2DcOff\fP <\f2DCOFF\fP>"
The primitive object will ignore
any transparent intensity texture maps that have been defined with 
\f2DoTextureMapTranspIntens\fP <\f2DOTMDC\fP>.
.IP "\f2DcOn\fP <\f2DCON\fP>"
The transparent intensity will be
mapped as specified by the \f2DoTextureMapTranspIntens\fP attribute
whenever possible. 
Note that the \f2DoTranspSwitch\fP primitive attribute 
must also be \f2DcOn\fP <\f2DCON\fP>.
.SH DEFAULTS
The default for \f2DoTextureMapTranspIntensSwitch\fP is \f2DcOff\fP
<\f2DCOFF\fP>.
.SH SEE ALSO
.na
.nh
DoTranspIntens(3D), DoTranspSwitch(3D), 
DoTextureMapTranspIntens(3D)
.ad
.hy
\&
