.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTextUpVector 3D  "Dore"
.SH NAME
DoTextUpVector \- Create a text up vector primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTextUpVector(xup, yup)
DtReal xup;
DtReal yup;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOTUV(XUP, YUP)
REAL*8 XUP
REAL*8 YUP
.in -.5i
.fi
.SH DESCRIPTION
.IX DOTUV
.IX DoTextUpVector
.I DoTextUpVector
creates a text up vector primitive attribute object.  
The text up vector determines the up direction for 
the top of each character in the text plane.
A text string's plane is established
when the text primitive object is created.
For more information about text objects, see the
manual pages \f2DoText\fP and \f2DoAnnoText\fP.
.PP
The parameters \f2xup\fP and \f2yup\fP
can be treated as a single, non-normalized, two-dimensional
vector that sits on the text plane.
.SH DEFAULTS
The default \f2DoTextUpVector\fP is (0.0, 1.0).
.SH "SEE ALSO"
.na
.nh
DoAnnoText(3D), DoText(3D), DoTextAlign(3D), DoTextExpFactor(3D),
DoTextFont(3D), DoTextHeight(3D), DoTextPath(3D), DoTextPrecision(3D),
DoTextSpace(3D)
.ad
.hy
