.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTextPath 3D  "Dore"
.SH NAME
DoTextPath \- Create a text path primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTextPath(textpath)
DtTextPath textpath;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOTPA(TXPATH)
INTEGER*4 TXPATH
.in -.5i
.fi
.SH DESCRIPTION
.IX DOTPA
.IX DoTextPath
.I DoTextPath
creates a text path primitive attribute object.  The parameter \f2textpath\fP
specifies the drawing direction for subsequently executed text primitive
objects.  Possible values are:
.IP "\f2DcTextPathRight\fP <\f2DCTPR\fP>"
Each succeeding character is to the right of the previous character.
.IP "\f2DcTextPathLeft\fP <\f2DCTPL\fP>"
Each succeeding character is to the left of the previous character.
.IP "\f2DcTextPathUp\fP <\f2DCTPU\fP>"
Each succeeding character is above the previous character.
.IP "\f2DcTextPathDown\fP <\f2DCTPD\fP>"
Each succeeding character is below the previous character.
.PP
\f2DoTextUpVector\fP is used to alter the orientation of the characters
themselves.
.SH DEFAULTS
The default \f2DoTextPath\fP is \f2DcTextPathRight\fP <\f2DCTPR\fP>.
.SH "SEE ALSO"
.na
.nh
DoAnnoText(3D), DoText(3D), DoTextAlign(3D), DoTextExpFactor(3D), 
DoTextFont(3D), DoTextHeight(3D), DoTextPrecision(3D), DoTextSpace(3D),
DoTextUpVector(3D)
.ad
.hy
