.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoText 3D  "Dore"
.SH NAME
DoText \- Create a text primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoText(position, u, v, string)
DtPoint3 position;
DtVector3 u, v;
DtPtr string;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOTXT(POSITN, U, V, STRING, N)
REAL*8 POSITN(3)
REAL*8 U(3), V(3)
INTEGER*4 N
CHARACTER*N STRING
.in -.5i
.fi
.SH DESCRIPTION
.IX DOTXT
.IX DoText
.I DoText
creates a text primitive object that
defines a string of text to be rendered at a specified position and
in a specified text plane.
.PP
The parameter \f2position\fP specifies a point in space where the
text will be based.
The parameters \f2u\fP and \f2v\fP are two three-dimensional
vectors used to determine the plane in which the text will
sit.
The \f2u\fP and \f2v\fP vectors need not be unit vectors,
but they must be perpendicular to each other for well-defined
results.
The parameter \f2string\fP is the actual text.
.SH "FORTRAN SPECIFIC"
The parameter \f2STRING\fP is string of \f2N\fP characters.
.SH "SEE ALSO"
.na
.nh
DoAnnoText(3D), DoTextAlign(3D), DoTextExpFactor(3D), 
DoTextFont(3D), DoTextHeight(3D), DoTextPath(3D), DoTextPrecision(3D),
DoTextSpace(3D), DoTextUpVector(3D)
.hy
.ad
