.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoSampleSuper 3D "Dore"
.SH NAME
DoSampleSuper \- Create a supersampling camera attribute object for antialiasing
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoSampleSuper(xsamples, ysamples)
DtInt xsamples;
DtInt ysamples;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOSSPR(XSAMP, YSAMP)
INTEGER*4 XSAMP
INTEGER*4 YSAMP
.in  -.5i
.fi 
.IX "DoSampleSuper"
.IX "DOSSPR"
.SH DESCRIPTION
.LP
\f2DoSampleSuper\fP creates a supersampling camera attribute object for
antialiasing.
.LP
Supersampling means that each pixel of an image is subdivided into
subpixels, and a shade is computed for each of the subpixels.
A filter is then applied to the shades of the subpixels to obtain
the final pixel value.
.LP
The parameters \f2xsamples\fP and \f2ysamples\fP specify how to divide
each pixel into subpixels.
For example, \f2DoSampleSuper(2, 3)\fP would mean 
sample the pixel twice in the x direction, and three times in
the y direction, resulting in 6 subpixels.
.LP
Pixels will not be subdivided unless the supersampling switch is turned on.
.SH ERRORS
\f2DoSampleSuper\fP will fail if \f2xsamples\fP or \f2ysamples\fP
is smaller than 1.
.TP 15
[ERROR - value out of range]
.SH DEFAULTS
The default \f2DoSampleSuper\fP is (2, 2).
.SH SEE ALSO
.nh
.na
DoSampleSuperSwitch(3D),
DoSampleFilter(3D)
DoLocalAntiAliasStyle(3D),
DoLocalAntiAliasSwitch(3D)
.hy
.ad
\&
