.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoSampleAdaptiveSwitch 3D "Dore"
.SH NAME
DoSampleAdaptiveSwitch \- Create a camera attribute object for enabling or disabling the use of adaptive sampling for antialiasing
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoSampleAdaptiveSwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOSASW(SWVAL)
INTEGER*4 SWVAL
.in  -.5i
.fi 
.IX "DoSampleAdaptiveSwitch"
.IX "DOSASW"
.SH DESCRIPTION
.LP
\f2DoSampleAdaptiveSwitch\fP creates an adaptive sampling switch camera 
attribute object for antialiasing.
.LP
Adaptive sampling means that not all pixels will be sampled equally,
with pixels that include object edges being sampled more frequently.
Pixels will be sampled until the variance of the samples is below
a certain threshold.
Adaptive sampling can also be done in conjunction with supersampling.
.LP
The parameter \f2switchvalue\fP specifies whether subsequent cameras
can sample adaptively.
.IX DcOn
.IX DCON
.IP "\f2DcOn\fP <\f2DCON\fP>"
Adaptive sampling is enabled. 
.IX DcOff
.IX DCOFF
.IP "\f2DcOff\fP <\f2DCOFF\fP>"
Adaptive sampling is disabled.
.SH DEFAULTS
The default \f2DoSampleAdaptiveSwitch\fP is \f2DcOff\fP.
.SH SEE ALSO
.na
.nh
DoSampleAdaptive(3D),
DoSampleSuper(3D),
DoLocalAntiAliasStyle(3D),
DoLocalAntiAliasSwitch(3D)
.hy
.ad
\&
