.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoSampleAdaptive 3D "Dore"
.SH NAME
DoSampleAdaptive \- Create an adaptive sampling camera attribute object for antialiasing 
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoSampleAdaptive(variance)
DtReal variance;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOSADP(VARNCE)
INTEGER*4 VARNCE
.in  -.5i
.fi 
.IX "DoSampleAdaptive"
.IX "DOSADP"
.SH DESCRIPTION
.LP
\f2DoSampleAdaptive\fP creates an adaptive sampling camera attribute 
object for antialiasing.
.LP
Adaptive sampling means that not all pixels will be sampled equally,
with pixels that include object edges being sampled more frequently.
Pixels will be sampled until the variance of the samples is below
a certain threshold.
Adaptive sampling can also be done in conjunction with supersampling.
.LP
The parameter \f2variance\fP is a number 
specifying the acceptable level of variance for a pixel.
This number is typically between \f20.0\fP and \f21.0\fP.
A higher number indicates a higher tolerance for aliases.
.LP
Adaptive sampling is enabled
or disabled with the \f2DoSampleAdaptiveSwitch\fP
<\f2DOSJSW\fP> attribute.
.SH DEFAULTS
The default \f2DoSampleAdaptive\fP is 0.5.
.SH SEE ALSO
.na
.nh
DoSampleAdaptiveSwitch(3D),
DoSampleSuper(3D),
DoLocalAntiAliasStyle(3D),
DoLocalAntiAliasSwitch(3D)
.hy
.ad
\&
